/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.serial;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pt.lsts.neptus.util.GuiUtils;

public class SerialPortParameters
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JComboBox<?> baudRateCombo = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel1 = null;
    private JComboBox<?> stopBitsCombo = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel2 = null;
    private JComboBox<?> parityCombo = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel3 = null;
    private JComboBox<?> dataBitsCombo = null;

    public SerialPortParameters() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(360, 75));
        this.setPreferredSize(new Dimension(360, 100));
        this.add((Component)this.getJPanel(), null);
        this.add((Component)this.getJPanel2(), null);
        this.add((Component)this.getJPanel1(), null);
        this.add((Component)this.getJPanel3(), null);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jLabel = new JLabel();
            this.jLabel.setText("Baud Rate");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout);
            this.jPanel.setPreferredSize(new Dimension(180, 30));
            this.jPanel.add((Component)this.jLabel, null);
            this.jPanel.add(this.getBaudRateCombo(), null);
        }
        return this.jPanel;
    }

    private JComboBox<?> getBaudRateCombo() {
        if (this.baudRateCombo == null) {
            this.baudRateCombo = new JComboBox<String>(new String[]{"110", "300", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200"});
            this.baudRateCombo.setSelectedIndex(5);
            this.baudRateCombo.setPreferredSize(new Dimension(80, 20));
        }
        return this.baudRateCombo;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setAlignment(2);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Stop Bits");
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout2);
            this.jPanel1.setPreferredSize(new Dimension(160, 30));
            this.jPanel1.add((Component)this.jLabel1, null);
            this.jPanel1.add(this.getStopBitsCombo(), null);
        }
        return this.jPanel1;
    }

    private JComboBox<?> getStopBitsCombo() {
        if (this.stopBitsCombo == null) {
            this.stopBitsCombo = new JComboBox<String>(new String[]{"1", "1.5", "2"});
            this.stopBitsCombo.setPreferredSize(new Dimension(80, 20));
        }
        return this.stopBitsCombo;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(2);
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Parity");
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(flowLayout1);
            this.jPanel2.setPreferredSize(new Dimension(160, 30));
            this.jPanel2.add((Component)this.jLabel2, null);
            this.jPanel2.add(this.getParityCombo(), null);
        }
        return this.jPanel2;
    }

    private JComboBox<?> getParityCombo() {
        if (this.parityCombo == null) {
            this.parityCombo = new JComboBox<String>(new String[]{"None", "Even", "Odd", "Mark", "Space"});
            this.parityCombo.setPreferredSize(new Dimension(80, 20));
        }
        return this.parityCombo;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            FlowLayout flowLayout3 = new FlowLayout();
            flowLayout3.setAlignment(2);
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Data Bits");
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(flowLayout3);
            this.jPanel3.setPreferredSize(new Dimension(160, 30));
            this.jPanel3.add((Component)this.jLabel3, null);
            this.jPanel3.add(this.getDataBitsCombo(), null);
        }
        return this.jPanel3;
    }

    private JComboBox<?> getDataBitsCombo() {
        if (this.dataBitsCombo == null) {
            this.dataBitsCombo = new JComboBox<String>(new String[]{"8", "7", "6", "5"});
            this.dataBitsCombo.setPreferredSize(new Dimension(80, 20));
        }
        return this.dataBitsCombo;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dataBitsCombo.setEnabled(enabled);
        this.stopBitsCombo.setEnabled(enabled);
        this.parityCombo.setEnabled(enabled);
        this.baudRateCombo.setEnabled(enabled);
    }

    public int getBaudrate() {
        try {
            return Integer.parseInt(this.getBaudRateCombo().getSelectedItem().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 9600;
        }
    }

    public int getDataBitsNumber() {
        try {
            return Integer.parseInt(this.getDataBitsCombo().getSelectedItem().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 8;
        }
    }

    public String getParity() {
        try {
            return this.getParityCombo().getSelectedItem().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "None";
        }
    }

    public int getParityCode() {
        try {
            return this.getParityCombo().getSelectedIndex();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getStopBits() {
        try {
            return this.getStopBitsCombo().getSelectedItem().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "1";
        }
    }

    public int getStopBitsCode() {
        try {
            String valurStr = this.getStopBitsCombo().getSelectedItem().toString();
            if ("1".equalsIgnoreCase(valurStr)) {
                return 1;
            }
            if ("1".equalsIgnoreCase(valurStr)) {
                return 2;
            }
            if ("1".equalsIgnoreCase(valurStr)) {
                return 3;
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] args) {
        SerialPortParameters sp = new SerialPortParameters();
        GuiUtils.testFrame(sp, "Serial Port Params");
        try {
            Thread.sleep(7000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.printf("BaudRate: %s\nDataBits: %s\nParity: %s\nStopBits: %s", sp.getBaudrate(), sp.getDataBitsNumber(), sp.getParity(), sp.getStopBits());
    }
}

