/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.systems;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pt.lsts.imc.Announce;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusConfig;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.systems.SystemType;
import pt.lsts.neptus.systems.links.ImcSystemLink;
import pt.lsts.neptus.types.coord.LocationType;

public class SystemsManager {
    private Map<Integer, SystemType> systems = new ConcurrentHashMap<Integer, SystemType>();

    public SystemsManager(NeptusConfig config) {
    }

    public SystemsManager buildSelf() {
        return this;
    }

    @Subscribe
    public void handleIMCAnnounce(Announce announce) {
        NeptusLog.pub().info((Object)("<###> " + announce.getSrc() + " " + announce.getSysName()));
        int id = announce.getSrc();
        if (this.systems.containsKey(id)) {
            SystemType system = this.systems.get(id);
            LocationType location = new LocationType(Math.toDegrees(announce.getLat()), Math.toDegrees(announce.getLon()));
            location.setHeight(announce.getHeight());
            system.setLocation(location);
            system.setLocationAge(announce.getTimestampMillis());
        } else {
            SystemType system = new SystemType();
            system.setId(id);
            system.setName(announce.getSysName());
            system.setHumanName(announce.getSysName());
            system.setType(SystemClass.valueOf(announce.getSysType().toString()));
            LocationType location = new LocationType(Math.toDegrees(announce.getLat()), Math.toDegrees(announce.getLon()));
            location.setHeight(announce.getHeight());
            system.setLocation(location);
            system.setLocationAge(announce.getTimestampMillis());
            system.setLink(SystemLinkType.IMC, new ImcSystemLink().update((IMCMessage)announce));
            this.systems.put(id, system);
        }
    }

    public Map<Integer, SystemType> getSystems() {
        return this.systems;
    }

    public static enum SystemClass {
        CCU(0L),
        HUMANSENSOR(1L),
        UUV(2L),
        USV(3L),
        UAV(4L),
        UGV(5L),
        STATICSENSOR(6L),
        MOBILESENSOR(7L),
        WSN(8L);

        protected long value;

        public long value() {
            return this.value;
        }

        private SystemClass(long value) {
            this.value = value;
        }
    }

    public static enum SystemLinkType {
        IMC;

    }
}

