/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.systems.external;

import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class ExternalSystem
implements Comparable<ExternalSystem> {
    protected String id;
    protected VehicleType.SystemTypeEnum type = VehicleType.SystemTypeEnum.UNKNOWN;
    protected VehicleType.VehicleTypeEnum typeVehicle = VehicleType.VehicleTypeEnum.UNKNOWN;
    protected ExternalTypeEnum typeExternal = ExternalTypeEnum.UNKNOWN;
    protected boolean active = false;
    protected final CoordinateSystem location = new CoordinateSystem();
    protected long locationTimeMillis = -1L;
    protected long attitudeTimeMillis = -1L;

    public ExternalSystem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.getId();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public LocationType getLocation() {
        return this.location.getNewAbsoluteLatLonDepth();
    }

    public void setLocation(LocationType location) {
        this.location.setLocation(location);
        this.location.convertToAbsoluteLatLonDepth();
        this.setLocationTimeMillis(System.currentTimeMillis());
    }

    public void setLocation(LocationType location, long locationTimeMillis) {
        this.location.setLocation(location);
        this.location.convertToAbsoluteLatLonDepth();
        this.setLocationTimeMillis(locationTimeMillis);
    }

    public void setAttitudeDegrees(double rollDegrees, double pitchDegrees, double yawDegrees) {
        this.location.setRoll(rollDegrees);
        this.location.setPitch(pitchDegrees);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(System.currentTimeMillis());
    }

    public void setAttitudeDegrees(double rollDegrees, double pitchDegrees, double yawDegrees, long locationTimeMillis) {
        this.location.setRoll(rollDegrees);
        this.location.setPitch(pitchDegrees);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(locationTimeMillis);
    }

    public void setAttitudeDegrees(double yawDegrees) {
        this.location.setRoll(0.0);
        this.location.setPitch(0.0);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(System.currentTimeMillis());
    }

    public void setAttitudeDegrees(double yawDegrees, long locationTimeMillis) {
        this.location.setRoll(0.0);
        this.location.setPitch(0.0);
        this.location.setYaw(yawDegrees);
        this.setAttitudeTimeMillis(locationTimeMillis);
    }

    public double getRollDegrees() {
        return this.location.getRoll();
    }

    public double getPitchDegrees() {
        return this.location.getPitch();
    }

    public double getYawDegrees() {
        return this.location.getYaw();
    }

    public long getLocationTimeMillis() {
        return this.locationTimeMillis;
    }

    public void setLocationTimeMillis(long locationTimeMillis) {
        this.locationTimeMillis = locationTimeMillis;
    }

    public long getAttitudeTimeMillis() {
        return this.attitudeTimeMillis;
    }

    public void setAttitudeTimeMillis(long attitudeTimeMillis) {
        this.attitudeTimeMillis = attitudeTimeMillis;
    }

    public VehicleType.SystemTypeEnum getType() {
        return this.type;
    }

    public void setType(VehicleType.SystemTypeEnum type) {
        this.type = type;
    }

    public VehicleType.VehicleTypeEnum getTypeVehicle() {
        return this.typeVehicle;
    }

    public void setTypeVehicle(VehicleType.VehicleTypeEnum typeVehicle) {
        this.typeVehicle = typeVehicle;
    }

    public ExternalTypeEnum getTypeExternal() {
        return this.typeExternal;
    }

    public void setTypeExternal(ExternalTypeEnum typeExternal) {
        this.typeExternal = typeExternal;
    }

    @Override
    public int compareTo(ExternalSystem o) {
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public static enum ExternalTypeEnum {
        UNKNOWN,
        VEHICLE,
        CCU,
        STATICSENSOR,
        MOBILESENSOR,
        MANNED_SHIP,
        MANNED_CAR,
        MANNED_AIRPLANE,
        PERSON,
        ALL;

    }
}

