/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.systems.external;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.systems.external.ExternalSystem;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class ExternalSystemsHolder {
    private static Map<String, ExternalSystem> lookupTable = Collections.synchronizedMap(new Hashtable());
    private static Timer timer = new Timer(ExternalSystemsHolder.class.getSimpleName() + " Timer", true);
    private static TimerTask ttask = new TimerTask(){

        @Override
        public void run() {
            if (lookupTable.size() == 0) {
                return;
            }
            ImcSystem[] systems = ImcSystemsHolder.lookupAllSystems();
            block0: for (String extSystemName : lookupTable.keySet().toArray(new String[0])) {
                for (ImcSystem imcSystem : systems) {
                    if (!extSystemName.equalsIgnoreCase(imcSystem.getName())) continue;
                    lookupTable.remove(extSystemName);
                    continue block0;
                }
            }
        }
    };

    private ExternalSystemsHolder() {
    }

    public static boolean registerSystem(ExternalSystem system) {
        ExternalSystem resLook = lookupTable.get(system.getId());
        if (resLook != null) {
            return true;
        }
        lookupTable.put(system.getId(), system);
        return true;
    }

    public static ExternalSystem lookupSystem(String id) {
        return lookupTable.get(id);
    }

    public static final ExternalSystem[] lookupSystemByType(VehicleType.SystemTypeEnum type, boolean onlyActiveSystems) {
        boolean allTypes = false;
        if (type == null) {
            allTypes = true;
        }
        LinkedList<ExternalSystem> list = new LinkedList<ExternalSystem>();
        for (ExternalSystem is : lookupTable.values()) {
            if (!allTypes && type != VehicleType.SystemTypeEnum.ALL && type != is.getType() || onlyActiveSystems && !is.isActive()) continue;
            list.add(is);
        }
        return list.toArray(new ExternalSystem[list.size()]);
    }

    public static final ExternalSystem[] lookupSystemByExternalType(ExternalSystem.ExternalTypeEnum type, boolean onlyActiveSystems) {
        boolean allTypes = false;
        if (type == null) {
            allTypes = true;
        }
        LinkedList<ExternalSystem> list = new LinkedList<ExternalSystem>();
        for (ExternalSystem is : lookupTable.values()) {
            if (!allTypes && type != ExternalSystem.ExternalTypeEnum.ALL && type != is.getTypeExternal() || onlyActiveSystems && !is.isActive()) continue;
            list.add(is);
        }
        return list.toArray(new ExternalSystem[list.size()]);
    }

    public static final ExternalSystem[] lookupAllSystems() {
        return ExternalSystemsHolder.lookupSystemByType(null, false);
    }

    public static final ExternalSystem[] lookupAllActiveSystems() {
        return ExternalSystemsHolder.lookupSystemByType(null, true);
    }

    public static final ExternalSystem[] lookupSystemByType(VehicleType.SystemTypeEnum type) {
        return ExternalSystemsHolder.lookupSystemByType(type, false);
    }

    public static final ExternalSystem[] lookupActiveSystemByType(VehicleType.SystemTypeEnum type) {
        return ExternalSystemsHolder.lookupSystemByType(type, true);
    }

    public static final ExternalSystem[] lookupSystemCCUs() {
        return ExternalSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.CCU);
    }

    public static final ExternalSystem[] lookupActiveSystemCCUs() {
        return ExternalSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.CCU, true);
    }

    public static final ExternalSystem[] lookupSystemVehicles() {
        return ExternalSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.VEHICLE);
    }

    public static final ExternalSystem[] lookupActiveSystemVehicles() {
        return ExternalSystemsHolder.lookupSystemByType(VehicleType.SystemTypeEnum.VEHICLE, true);
    }

    static {
        timer.scheduleAtFixedRate(ttask, 2000L, 5000L);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ttask.cancel();
                timer.cancel();
            }
        }));
    }
}

