/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.systems.links;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import pt.lsts.imc.Announce;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.systems.links.SystemLink;

public class ImcSystemLink
extends SystemLink {
    private long owner;
    private Map<String, URI> services = new HashMap<String, URI>();

    public ImcSystemLink update(IMCMessage msg) {
        if (msg instanceof Announce) {
            this.processAnnounce((Announce)msg);
        }
        if (msg instanceof EstimatedState) {
            // empty if block
        }
        return this;
    }

    private void processAnnounce(Announce msg) {
        String[] servicesList;
        this.owner = msg.getOwner();
        String announceServices = msg.getServices();
        for (String service : servicesList = announceServices.split(",")) {
            URI uri = URI.create(service);
            this.services.put(uri.getScheme(), uri);
        }
    }

    public String toString() {
        return "ImcSystemLink [owner=" + this.owner + ", services=" + this.services.toString() + "]";
    }
}

