/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.CoordinateSystemsHolder;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.TemplateFileVehicle;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.xsl.TransformDocument;

public class TestMissionLoad {
    public void run() {
        ConfigFetch.initialize();
        CoordinateSystemsHolder csh = new CoordinateSystemsHolder(ConfigFetch.getCoordinateSystemsConfigLocation());
        NeptusLog.pub().debug((Object)("CoordinateSystems #: " + csh.size()));
        LinkedList<String> vl = ConfigFetch.getVehiclesList();
        ListIterator li = vl.listIterator();
        while (li.hasNext()) {
            CoordinateSystem cs;
            String hr = (String)li.next();
            VehicleType v = new VehicleType(ConfigFetch.resolvePath(hr));
            if (v.getCoordinateSystem() == null && (cs = csh.getCoordinateSystemList().get(v.getCoordinateSystemLabel())) != null) {
                v.setCoordinateSystem(cs);
            }
            VehiclesHolder.addVehicle(v);
        }
        NeptusLog.pub().debug((Object)("Vehicles #: " + VehiclesHolder.size()));
        MissionType mission = new MissionType(ConfigFetch.resolvePath("missions/isurus-mission-teste-lsts.xml"));
        NeptusLog.pub().debug((Object)("Mission::Id: " + mission.getId()));
        NeptusLog.pub().debug((Object)("Mission::Name: " + mission.getName()));
        NeptusLog.pub().debug((Object)("Mission::Type: " + mission.getType()));
        NeptusLog.pub().debug((Object)("Mission::Description: " + mission.getDescription()));
        NeptusLog.pub().debug((Object)("Mission::Notes #: " + mission.getNotesList().size()));
        NeptusLog.pub().debug((Object)("Mission::Vehicles #: " + mission.getVehiclesList().size()));
        NeptusLog.pub().debug((Object)("Mission::Maps #: " + mission.getMapsList().size()));
        NeptusLog.pub().debug((Object)("Mission::HomeRef Id: " + mission.getHomeRef().getId()));
        PlanType indPlan = mission.getIndividualPlansList().values().iterator().next();
        String v = indPlan.getVehicle();
        VehicleType vehicleM = VehiclesHolder.getVehiclesList().get(v);
        String maneuversXML = indPlan.getGraph().getGraphAsManeuversSeq();
        TemplateFileVehicle tfile = vehicleM.getTransformationXSLTTemplates().values().iterator().next();
        String xsltToPass = tfile.getHref();
        xsltToPass = ConfigFetch.resolvePath(xsltToPass);
        String outToPass = tfile.getOutputFileName();
        NeptusLog.pub().debug((Object)("Mission::XSLT: " + xsltToPass));
        NeptusLog.pub().debug((Object)("Mission::OUT: " + outToPass));
        Hashtable<String, String> styleSheetParam = new Hashtable<String, String>();
        styleSheetParam.put("vehicle-file", new File(vehicleM.getOriginalFilePath()).toURI().toASCIIString());
        styleSheetParam.put("mission-file", new File(mission.getOriginalFilePath()).toURI().toASCIIString());
        ByteArrayInputStream bais = new ByteArrayInputStream(maneuversXML.getBytes());
        TransformDocument processor = new TransformDocument();
        processor.setDebug(true);
        FileUtil.backupFile(outToPass);
        processor.doTransformation(processor.createStreamSource(bais), processor.createStreamSource(xsltToPass), processor.createStreamResult(outToPass), styleSheetParam);
        NeptusLog.pub().debug((Object)("Mission as XML:\n" + FileUtil.getAsPrettyPrintFormatedXMLString(mission.asDocument())));
        if (VehiclesHolder.size() > 0) {
            for (VehicleType ve : VehiclesHolder.getVehiclesList().values()) {
                NeptusLog.pub().debug((Object)("Vehicle " + ve.getId() + " as XML:\n" + FileUtil.getAsPrettyPrintFormatedXMLString(ve.asDocument())));
            }
        }
        Iterator<MapMission> it = mission.getMapsList().values().iterator();
        while (it.hasNext()) {
            MapType mp = it.next().getMap();
            NeptusLog.pub().debug((Object)("Map " + mp.getId() + " as XML:\n" + FileUtil.getAsPrettyPrintFormatedXMLString(mp.asDocument())));
        }
    }

    public static void main(String[] args) {
        TestMissionLoad tr = new TestMissionLoad();
        tr.run();
        NeptusLog.pub().info((Object)("<###> " + System.getProperty("user.name", "unknown")));
        NeptusLog.pub().info((Object)("<###> " + System.getProperty("user.home", ".")));
        NeptusLog.pub().info((Object)("<###> " + System.getProperty("user.dir", ".")));
    }
}

