/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.renderer2d.MissionRenderer;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class TrakerTeste
extends JPanel {
    private static final long serialVersionUID = 2846762143138236266L;
    private JFrame jFrame = null;
    private JPanel frameContentPane = null;
    private JPanel rendererPanel = null;
    private MissionType missionType = new MissionType();
    private LinkedList<TransponderElement> transpondersList = new LinkedList();
    private LocationType locStart = new LocationType();
    private LinkedList<CoordinateSystem> coordSystemsList = new LinkedList();
    private LinkedList<Double> distanciesList = new LinkedList();
    private MissionRenderer missionRenderer = null;
    private VehicleType ve;
    private JButton runButton = null;
    private LocationType lastKnownPos = new LocationType();
    private JPanel controlTrackerPanel = null;
    private JButton resetButton = null;
    private MapGroup mgp;
    private LinkedList<String> addedMapsIds = new LinkedList();

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setContentPane(this.getFrameContentPane());
        }
        return this.jFrame;
    }

    private JPanel getFrameContentPane() {
        if (this.frameContentPane == null) {
            this.frameContentPane = new JPanel();
            this.frameContentPane.setLayout(new BorderLayout());
            this.frameContentPane.add((Component)this, "Center");
        }
        return this.frameContentPane;
    }

    public TrakerTeste() {
        this.initTestMission();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.setSize(300, 200);
        this.add((Component)this.getRendererPanel(), "Center");
        this.add((Component)this.getControlTrackerPanel(), "North");
    }

    private void initTestMission() {
        MissionType mt;
        this.missionType = mt = new MissionType("testeTracker/mission-tracker.xml");
    }

    public static JFrame showFrame(String title) {
        TrakerTeste tr = new TrakerTeste();
        JFrame fr = tr.getJFrame();
        fr.setSize(500, 400);
        fr.setDefaultCloseOperation(3);
        fr.setVisible(true);
        tr.work();
        return fr;
    }

    private void work() {
        LinkedHashMap<String, MapMission> mpList;
        this.ve = this.missionType.getVehiclesList().values().iterator().next().getVehicle();
        LinkedHashMap<String, MapMission> mapList = mpList = this.missionType.getMapsList();
        for (MapMission mpm : mapList.values()) {
            LinkedHashMap<String, TransponderElement> transList = mpm.getMap().getTranspondersList();
            for (TransponderElement tmp : transList.values()) {
                this.transpondersList.add(tmp);
            }
        }
        boolean isFound = false;
        for (MapMission mpm : mapList.values()) {
            LinkedHashMap<String, MarkElement> transList = mpm.getMap().getMarksList();
            for (MarkElement tmp : transList.values()) {
                String name = tmp.getId();
                if (!name.equalsIgnoreCase("start")) continue;
                this.locStart.setLocation(tmp.getCenterLocation());
                isFound = true;
                break;
            }
            if (!isFound) continue;
            break;
        }
        if (isFound) {
            this.lastKnownPos = new LocationType(this.locStart);
        }
        for (int i = 0; i < this.transpondersList.size(); ++i) {
            LocationType t1 = this.transpondersList.get(i).getCenterLocation();
            LocationType t2 = i < this.transpondersList.size() - 1 ? this.transpondersList.get(i + 1).getCenterLocation() : this.transpondersList.getFirst().getCenterLocation();
            double[] res = t1.getOffsetFrom(t2);
            CoordinateUtil.cartesianToCylindricalCoordinates(res[0], res[1], res[2]);
            double distance = t1.getHorizontalDistanceInMeters(new LocationType(t2));
            double xyAngle = t1.getXYAngle(new LocationType(t2));
            CoordinateSystem cs = new CoordinateSystem();
            cs.setLocation(t1);
            cs.setYaw(Math.toDegrees(xyAngle - 1.5707963267948966));
            cs.setId(t1.getId() + t2.getId());
            cs.setName(cs.getId());
            this.coordSystemsList.add(cs);
            this.distanciesList.add(distance);
        }
        MapGroup mgp = MapGroup.getMapGroupInstance(this.missionType);
        MapType mapCS = new MapType();
        for (CoordinateSystem cs : this.coordSystemsList) {
            MarkElement mo = new MarkElement(null, null);
            mo.setCenterLocation(new LocationType(cs));
            mo.setId(cs.getId());
            mo.setYawDeg(cs.getYaw());
            mapCS.addObject(mo);
        }
        mgp.addMap(mapCS);
        SystemPositionAndAttitude sv = new SystemPositionAndAttitude(new LocationType(), 0.0, 0.0, 0.0);
        this.missionRenderer.setVehicleState(this.ve, sv);
    }

    private LocationType[] calculate(int trans1, int trans2, double trans1ToVehicleDistance, double trans2ToVehicleDistance) {
        CoordinateSystem cs = this.coordSystemsList.get(trans1);
        double distance = this.distanciesList.get(trans1);
        double da1 = trans1ToVehicleDistance;
        double db1 = trans2ToVehicleDistance;
        double paY = 0.0;
        double pbY = distance;
        String lat = cs.getLatitudeStr();
        String lon = cs.getLongitudeStr();
        double yawHR = cs.getYaw();
        double[] cyl = CoordinateUtil.sphericalToCylindricalCoordinates(cs.getOffsetDistance(), cs.getAzimuth(), cs.getZenith());
        double legacyOffsetDistance = MathMiscUtils.round(cyl[0], 3);
        double legacyTheta = MathMiscUtils.round(Math.toDegrees(cyl[1]), 3);
        double legacyOffsetNorth = cs.getOffsetNorth();
        double legacyOffsetEast = cs.getOffsetEast();
        double t1Depth = 0.0;
        double daH1 = Math.sqrt(Math.pow(da1, 2.0) - Math.pow(t1Depth, 2.0));
        double dbH1 = Math.sqrt(Math.pow(db1, 2.0) - Math.pow(t1Depth, 2.0));
        double offsetY = (Math.pow(daH1, 2.0) - Math.pow(dbH1, 2.0) + Math.pow(pbY, 2.0) - Math.pow(paY, 2.0)) / (2.0 * pbY - 2.0 * paY);
        double offsetX = Math.sqrt(Math.pow(daH1, 2.0) - Math.pow(offsetY - paY, 2.0));
        double[] offsetsIne = CoordinateUtil.bodyFrameToInertialFrame(offsetX, offsetY, 0.0, 0.0, 0.0, Math.toRadians(yawHR));
        double offsetNorth = MathMiscUtils.round(offsetsIne[0], 3) + legacyOffsetNorth;
        double offsetEast = MathMiscUtils.round(offsetsIne[1], 3) + legacyOffsetEast;
        double[] offsetsIne2 = CoordinateUtil.bodyFrameToInertialFrame(-offsetX, offsetY, 0.0, 0.0, 0.0, Math.toRadians(yawHR));
        double offsetNorth2 = MathMiscUtils.round(offsetsIne2[0], 3) + legacyOffsetNorth;
        double offsetEast2 = MathMiscUtils.round(offsetsIne2[1], 3) + legacyOffsetEast;
        LocationType loc = new LocationType();
        loc.setLatitudeStr(lat);
        loc.setLongitudeStr(lon);
        loc.setDepth(t1Depth);
        loc.setOffsetNorth(offsetNorth);
        loc.setOffsetEast(offsetEast);
        loc.setOffsetDistance(legacyOffsetDistance);
        loc.setAzimuth(legacyTheta);
        LocationType loc2 = new LocationType();
        loc2.setLatitudeStr(lat);
        loc2.setLongitudeStr(lon);
        loc2.setDepth(t1Depth);
        loc2.setOffsetNorth(offsetNorth2);
        loc2.setOffsetEast(offsetEast2);
        loc2.setOffsetDistance(legacyOffsetDistance);
        loc2.setAzimuth(legacyTheta);
        LocationType[] locArray = new LocationType[]{loc, loc2};
        return locArray;
    }

    public LocationType fixLocationWithLastKnown(LocationType[] newLocArray, LocationType lasKnownLoc) {
        double lasKnownLocDist;
        LocationType fixedLoc = new LocationType();
        LocationType newLoc = new LocationType(newLocArray[0]);
        LocationType helperLoc = new LocationType(newLocArray[1]);
        double newLocDist = lasKnownLoc.getDistanceInMeters(newLoc);
        if (newLocDist <= (lasKnownLocDist = lasKnownLoc.getDistanceInMeters(helperLoc))) {
            fixedLoc = newLoc;
            NeptusLog.pub().info((Object)("<###>" + newLocDist + " & " + lasKnownLocDist));
        } else {
            fixedLoc = helperLoc;
            NeptusLog.pub().info((Object)("<###>Trocou!! " + newLocDist + " & " + lasKnownLocDist));
        }
        NeptusLog.pub().info((Object)("<###>    " + newLoc.getDebugString()));
        NeptusLog.pub().info((Object)("<###>    " + helperLoc.getDebugString()));
        return fixedLoc;
    }

    private JPanel getRendererPanel() {
        if (this.rendererPanel == null) {
            this.rendererPanel = new JPanel();
            this.rendererPanel.setLayout(new BorderLayout());
            this.missionRenderer = new MissionRenderer(null, MapGroup.getMapGroupInstance(this.missionType), 2);
            this.rendererPanel.add((Component)this.missionRenderer, "Center");
        }
        return this.rendererPanel;
    }

    private JButton getRunButton() {
        if (this.runButton == null) {
            this.runButton = new JButton();
            this.runButton.setText("Simulate tracker");
            this.runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateTask uTask = new UpdateTask();
                    uTask.init();
                    Timer timer = new Timer("Teste");
                    timer.scheduleAtFixedRate((TimerTask)uTask, 1000L, 1000L);
                }
            });
        }
        return this.runButton;
    }

    private JPanel getControlTrackerPanel() {
        if (this.controlTrackerPanel == null) {
            this.controlTrackerPanel = new JPanel();
            this.controlTrackerPanel.add((Component)this.getRunButton(), null);
            this.controlTrackerPanel.add((Component)this.getResetButton(), null);
        }
        return this.controlTrackerPanel;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrakerTeste.this.lastKnownPos = new LocationType(TrakerTeste.this.locStart);
                    SystemPositionAndAttitude sv = new SystemPositionAndAttitude(TrakerTeste.this.lastKnownPos, 0.0, 0.0, 0.0);
                    TrakerTeste.this.missionRenderer.setVehicleState(TrakerTeste.this.ve, sv);
                    for (String mapId : TrakerTeste.this.addedMapsIds) {
                        TrakerTeste.this.mgp.removeMap(mapId);
                    }
                    TrakerTeste.this.addedMapsIds.clear();
                }
            });
        }
        return this.resetButton;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        TrakerTeste.showFrame("Tracker teste");
    }

    class UpdateTask
    extends TimerTask {
        LinkedList<DataFeed> dataFeed = new LinkedList();
        int i = 0;

        UpdateTask() {
        }

        public void init() {
            this.dataFeed.add(new DataFeed(0, 1, 10.9, 9.83));
            this.dataFeed.add(new DataFeed(1, 2, 9.83, 14.0));
            this.dataFeed.add(new DataFeed(2, 0, 14.0, 10.9));
            this.dataFeed.add(new DataFeed(0, 1, 8.83, 6.8));
            this.dataFeed.add(new DataFeed(1, 2, 6.8, 10.9));
            this.dataFeed.add(new DataFeed(2, 0, 10.9, 8.83));
            this.dataFeed.add(new DataFeed(0, 1, 6.99, 4.86));
            this.dataFeed.add(new DataFeed(1, 2, 4.86, 8.12));
            this.dataFeed.add(new DataFeed(2, 0, 8.12, 6.99));
            this.dataFeed.add(new DataFeed(0, 1, 9.0, 17.7));
            this.dataFeed.add(new DataFeed(1, 2, 17.7, 16.0));
            this.dataFeed.add(new DataFeed(2, 0, 16.0, 9.0));
            this.dataFeed.add(new DataFeed(0, 1, 7.98, 17.56));
            this.dataFeed.add(new DataFeed(1, 2, 17.56, 12.33));
            this.dataFeed.add(new DataFeed(2, 0, 12.33, 7.98));
            this.i = 0;
            NeptusLog.pub().info((Object)("<###>DataFeed: " + this.dataFeed.size()));
        }

        @Override
        public void run() {
            NeptusLog.pub().info((Object)("<###>Tick: " + this.i));
            DataFeed dFeed = this.dataFeed.get(this.i++);
            LocationType[] locArray = TrakerTeste.this.calculate(dFeed.trans1, dFeed.trans2, dFeed.dist1, dFeed.dist2);
            LocationType loc = TrakerTeste.this.fixLocationWithLastKnown(locArray, TrakerTeste.this.lastKnownPos);
            double newYaw = TrakerTeste.this.lastKnownPos.getXYAngle(loc);
            TrakerTeste.this.lastKnownPos.setLocation(loc);
            SystemPositionAndAttitude sv = new SystemPositionAndAttitude(loc, 0.0, 0.0, newYaw);
            TrakerTeste.this.missionRenderer.setVehicleState(TrakerTeste.this.ve, sv);
            TrakerTeste.this.mgp = MapGroup.getMapGroupInstance(TrakerTeste.this.missionType);
            MapType mapCS = new MapType();
            MarkElement mo = new MarkElement(null, null);
            mo.setCenterLocation(loc);
            mo.setId("tracker-" + this.i);
            mapCS.addObject(mo);
            TrakerTeste.this.addedMapsIds.add(mapCS.getId());
            TrakerTeste.this.mgp.addMap(mapCS);
            if (this.dataFeed.size() == this.i) {
                this.cancel();
            }
        }

        class DataFeed {
            public int trans1;
            public int trans2;
            public double dist1;
            public double dist2;

            public DataFeed(int trans1, int trans2, double trans1ToVehicleDistance, double trans2ToVehicleDistance) {
                this.trans1 = trans1;
                this.trans2 = trans2;
                this.dist1 = trans1ToVehicleDistance;
                this.dist2 = trans2ToVehicleDistance;
            }
        }
    }
}

