/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.checklist;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;

public class CheckAutoUserLogItem
extends CheckAutoSubItem {
    private String logRequest = null;
    private String logMessage = null;

    public CheckAutoUserLogItem(String xml) {
        this.setSubItemType("userLog");
        this.load(xml);
    }

    public CheckAutoUserLogItem() {
        this.subItemType = "userLog";
    }

    public String getLogRequest() {
        return this.logRequest;
    }

    public void setLogRequest(String logRequest) {
        this.logRequest = logRequest;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("checked", Boolean.toString(this.isChecked()));
        root.addElement("logRequest").setText(this.getLogRequest());
        root.addElement("logMessage").setText(this.getLogMessage());
        return document;
    }

    @Override
    public boolean load(String xml) {
        String fileAsString = xml;
        try {
            this.doc = DocumentHelper.parseText((String)fileAsString);
            this.setChecked(Boolean.parseBoolean(this.doc.selectSingleNode("/userLog/@checked").getText()));
            Node nd = this.doc.selectSingleNode("/userLog/logRequest");
            if (nd != null) {
                this.setLogRequest(nd.getText());
            }
            if ((nd = this.doc.selectSingleNode("/userLog/logMessage")) != null) {
                this.setLogMessage(nd.getText());
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }
}

