/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.checklist;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;

public class CheckAutoVarIntervalItem
extends CheckAutoSubItem {
    private String varName = null;
    private String varPath = null;
    private Double varValue = null;
    private Double startInterval = null;
    private boolean startInclusion = true;
    private Double endInterval = null;
    private boolean endInclusion = true;
    private boolean outInterval = false;

    public CheckAutoVarIntervalItem(String xml) {
        this.setSubItemType("variableTestRange");
        this.load(xml);
    }

    public CheckAutoVarIntervalItem() {
        this.subItemType = "variableTestRange";
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public Double getStartInterval() {
        return this.startInterval;
    }

    public void setStartInterval(Double startInterval) {
        this.startInterval = startInterval;
    }

    public Double getEndInterval() {
        return this.endInterval;
    }

    public void setEndInterval(Double endInterval) {
        this.endInterval = endInterval;
    }

    public boolean isOutInterval() {
        return this.outInterval;
    }

    public void setOutInterval(boolean outInterval) {
        this.outInterval = outInterval;
    }

    public boolean isStartInclusion() {
        return this.startInclusion;
    }

    public void setStartInclusion(boolean startInclusion) {
        this.startInclusion = startInclusion;
    }

    public boolean isEndInclusion() {
        return this.endInclusion;
    }

    public void setEndInclusion(boolean endInclusion) {
        this.endInclusion = endInclusion;
    }

    public String getVarPath() {
        return this.varPath;
    }

    public void setVarPath(String varPath) {
        this.varPath = varPath;
    }

    public Double getVarValue() {
        return this.varValue;
    }

    public void setVarValue(Double varValue) {
        this.varValue = varValue;
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("checked", Boolean.toString(this.isChecked()));
        root.addElement("variableName").setText(this.getVarName());
        root.addElement("variablePath").setText(this.getVarPath());
        if (this.getVarValue() != null && !Double.isNaN(this.getVarValue())) {
            root.addElement("registedValue").setText(Double.toString(this.getVarValue()));
        }
        Element intervalElem = root.addElement("interval");
        if (this.getStartInterval() != null && !Double.isInfinite(this.getStartInterval())) {
            intervalElem.addAttribute("start", Double.toString(this.getStartInterval()));
        }
        if (this.getStartInterval() != null && !Double.isInfinite(this.getEndInterval())) {
            intervalElem.addAttribute("end", Double.toString(this.getEndInterval()));
        }
        intervalElem.addAttribute("startInclusion", Boolean.toString(this.isStartInclusion()));
        intervalElem.addAttribute("endInclusion", Boolean.toString(this.isEndInclusion()));
        intervalElem.addAttribute("complement", Boolean.toString(this.isOutInterval()));
        return document;
    }

    @Override
    public boolean load(String xml) {
        String fileAsString = xml;
        try {
            this.doc = DocumentHelper.parseText((String)fileAsString);
            this.setChecked(Boolean.parseBoolean(this.doc.selectSingleNode("/variableTestRange/@checked").getText()));
            Node nd = this.doc.selectSingleNode("/variableTestRange/variableName");
            if (nd != null) {
                this.setVarName(nd.getText());
            }
            if ((nd = this.doc.selectSingleNode("/variableTestRange/variablePath")) != null) {
                NeptusLog.pub().info((Object)("<###> " + nd.getText()));
                this.setVarPath(nd.getText());
            }
            if ((nd = this.doc.selectSingleNode("/variableTestRange/registedValue")) != null) {
                this.setVarValue(Double.parseDouble(nd.getText()));
            }
            if ((nd = this.doc.selectSingleNode("/variableTestRange/interval")) != null) {
                Node ndaux = nd.selectSingleNode("./@start");
                if (ndaux != null) {
                    this.setStartInterval(Double.parseDouble(ndaux.getText()));
                }
                if ((ndaux = nd.selectSingleNode("./@end")) != null) {
                    this.setEndInterval(Double.parseDouble(ndaux.getText()));
                }
                if ((ndaux = nd.selectSingleNode("./@startInclusion")) != null) {
                    this.setStartInclusion(Boolean.parseBoolean(ndaux.getText()));
                }
                if ((ndaux = nd.selectSingleNode("./@endInclusion")) != null) {
                    this.setEndInclusion(Boolean.parseBoolean(ndaux.getText()));
                }
                if ((ndaux = nd.selectSingleNode("./@complement")) != null) {
                    this.setOutInterval(Boolean.parseBoolean(ndaux.getText()));
                }
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }
}

