/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.checklist;

import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserActionItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserLogItem;
import pt.lsts.neptus.types.checklist.CheckAutoVarIntervalItem;

public class CheckItem
implements XmlOutputMethods {
    protected static final String DEFAULT_ROOT_ELEMENT = "item";
    protected String name = "";
    protected boolean isChecked = false;
    protected boolean skiped = false;
    protected double runDurationSeconds = Double.NaN;
    protected String dateChecked = "";
    protected String note = "";
    private Vector<CheckAutoSubItem> autoSubItems = new Vector();
    private Document doc;

    public CheckItem(String xml) {
        this.load(xml);
    }

    public CheckItem() {
    }

    public boolean load(String xml) {
        String fileAsString = xml;
        try {
            this.doc = DocumentHelper.parseText((String)fileAsString);
            this.setName(this.doc.selectSingleNode("/item/@name").getText());
            Node nd = this.doc.selectSingleNode("/item/note");
            if (nd != null) {
                this.setNote(nd.getText());
            }
            if ((nd = this.doc.selectSingleNode("/item/@checked")) != null) {
                this.setChecked(Boolean.parseBoolean(nd.getText()));
            } else {
                this.setChecked(false);
            }
            nd = this.doc.selectSingleNode("/item/@skiped");
            if (nd != null) {
                this.setSkiped(Boolean.parseBoolean(nd.getText()));
            } else {
                this.setChecked(false);
            }
            nd = this.doc.selectSingleNode("/item/@date-checked");
            if (nd != null) {
                this.setDateChecked(nd.getText());
            } else {
                this.setDateChecked("");
            }
            nd = this.doc.selectSingleNode("/item/@run-duration-seconds");
            if (nd != null) {
                try {
                    this.setRunDurationSeconds(Double.parseDouble(nd.getText()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setRunDurationSeconds(Double.NaN);
                }
            } else {
                this.setRunDurationSeconds(Double.NaN);
            }
            List lt = this.doc.selectNodes("/item/subItems/*");
            if (!lt.isEmpty()) {
                for (Node aux : lt) {
                    CheckAutoSubItem casi = null;
                    if (aux.getName().equals("variableTestRange")) {
                        casi = new CheckAutoVarIntervalItem(aux.asXML());
                    } else if (aux.getName().equals("userLog")) {
                        casi = new CheckAutoUserLogItem(aux.asXML());
                    } else if (aux.getName().equals("userAction")) {
                        casi = new CheckAutoUserActionItem(aux.asXML());
                    }
                    if (casi == null) continue;
                    this.autoSubItems.add(casi);
                }
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }

    public void addAutoSubItem(CheckAutoSubItem asi) {
        this.autoSubItems.add(asi);
    }

    public void removeAutoSubItem(CheckAutoSubItem asi) {
        this.autoSubItems.remove(asi);
    }

    public Vector<CheckAutoSubItem> getAutoSubItems() {
        return this.autoSubItems;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDateChecked() {
        return this.dateChecked;
    }

    public void setDateChecked(String dateChecked) {
        this.dateChecked = dateChecked;
    }

    public double getRunDurationSeconds() {
        return this.runDurationSeconds;
    }

    public void setRunDurationSeconds(double runDurationSeconds) {
        this.runDurationSeconds = runDurationSeconds;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        if (note == null) {
            this.note = "";
        }
        this.note = note;
    }

    public boolean isSkiped() {
        return this.skiped;
    }

    public void setSkiped(boolean skiped) {
        this.skiped = skiped;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addAttribute("name", this.getName());
        root.addAttribute("checked", Boolean.toString(this.isChecked()));
        if (!this.isSkiped()) {
            root.addAttribute("skiped", Boolean.toString(this.isSkiped()));
        }
        if (this.isChecked()) {
            if (!this.getDateChecked().equalsIgnoreCase("")) {
                root.addAttribute("date-checked", this.getDateChecked());
            }
            if (!Double.isNaN(this.getRunDurationSeconds())) {
                root.addAttribute("run-duration-seconds", this.getRunDurationSeconds() + "");
            }
        }
        if (!this.getNote().equalsIgnoreCase("")) {
            root.addElement("note").setText(this.getNote());
        }
        if (!this.autoSubItems.isEmpty()) {
            Element subItem = DocumentHelper.createElement((String)"subItems");
            for (CheckAutoSubItem casi : this.autoSubItems) {
                subItem.add(casi.asElement());
            }
            if (!subItem.content().isEmpty()) {
                root.add(subItem);
            }
        }
        return document;
    }
}

