/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.checklist;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.XmlInputMethods;
import pt.lsts.neptus.types.XmlInputMethodsFromFile;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.checklist.CheckItem;
import pt.lsts.neptus.types.mission.ChecklistMission;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.XMLValidator;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ChecklistType
implements XmlOutputMethods,
XmlInputMethods,
XmlInputMethodsFromFile {
    protected static final String DEFAULT_ROOT_ELEMENT = "checklist";
    public static final String FLAT_ID = "flat";
    protected String name = "";
    protected String version = "";
    protected String description = null;
    protected boolean isFlat = true;
    protected boolean isLoadOk = true;
    protected LinkedHashMap<String, LinkedList<CheckItem>> groupList = new LinkedHashMap();
    private Document doc;
    private String originalFilePath = "";

    public ChecklistType(String url) {
        this.loadFile(url);
    }

    public ChecklistType() {
    }

    @Override
    public boolean load(Element elem) {
        this.doc = Dom4JUtil.elementToDocument(elem);
        if (this.doc == null) {
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    private boolean load() {
        long initTime = System.currentTimeMillis();
        try {
            this.setName(this.doc.selectSingleNode("/checklist/@name").getText());
            Node nd = this.doc.selectSingleNode("/checklist/description");
            if (nd != null) {
                this.setDescription(nd.getText());
            } else {
                nd = this.doc.selectSingleNode("/checklist/@description");
                if (nd != null) {
                    this.setDescription(nd.getText());
                } else {
                    this.setDescription(null);
                }
            }
            nd = this.doc.selectSingleNode("/checklist/@version");
            if (nd != null) {
                this.setVersion(nd.getText());
            } else {
                this.setVersion("");
            }
            nd = this.doc.selectSingleNode("/checklist/item");
            if (nd != null) {
                this.setFlat(true);
            } else {
                this.setFlat(false);
            }
            if (this.isFlat()) {
                List lt = this.doc.selectNodes("/checklist/item");
                if (!lt.isEmpty()) {
                    LinkedList<CheckItem> lkl = new LinkedList<CheckItem>();
                    Iterator it = lt.iterator();
                    while (it.hasNext()) {
                        CheckItem ci = new CheckItem(((Node)it.next()).asXML());
                        lkl.add(ci);
                    }
                    this.groupList.put(FLAT_ID, lkl);
                }
            } else {
                List lt = this.doc.selectNodes("/checklist/group");
                if (!lt.isEmpty()) {
                    for (Node nd1 : lt) {
                        String name = nd1.selectSingleNode("./@name").getText();
                        List lt1 = nd1.selectNodes("./item");
                        LinkedList<CheckItem> lkl = new LinkedList<CheckItem>();
                        Iterator it1 = lt1.iterator();
                        while (it1.hasNext()) {
                            CheckItem ci = new CheckItem(((Node)it1.next()).asXML());
                            lkl.add(ci);
                        }
                        this.groupList.put(name, lkl);
                    }
                }
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            long totalTime = System.currentTimeMillis() - initTime;
            NeptusLog.pub().info((Object)(this + ": Total checklist load time: " + totalTime + " ms."));
            this.isLoadOk = false;
            return false;
        }
        long totalTime = System.currentTimeMillis() - initTime;
        NeptusLog.pub().info((Object)(this + ": Total checklist load time: " + totalTime + " ms."));
        this.isLoadOk = true;
        return true;
    }

    @Override
    public boolean loadFile(File file) {
        return this.loadFile(file.getAbsolutePath());
    }

    @Override
    public boolean loadFile(String url) {
        this.originalFilePath = new File(url).getAbsolutePath();
        String fileAsString = FileUtil.getFileAsString(url);
        this.isLoadOk = ChecklistType.validate(fileAsString);
        return this.load(fileAsString);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public void setFlat(boolean isFlat) {
        this.isFlat = isFlat;
    }

    public LinkedHashMap<String, LinkedList<CheckItem>> getGroupList() {
        return this.groupList;
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document;
        block6: {
            Element root;
            block5: {
                document = DocumentHelper.createDocument();
                root = document.addElement(rootElementName);
                root.addComment(ConfigFetch.getSaveAsCommentForXML());
                root.addAttribute("name", this.getName());
                if (this.getVersion() != null && !"".equalsIgnoreCase(this.getVersion())) {
                    root.addAttribute("version", this.getVersion());
                }
                if (this.getDescription() != null) {
                    root.addElement("description").setText(this.getDescription());
                }
                if (!this.isFlat()) break block5;
                if (this.groupList.isEmpty()) break block6;
                LinkedList<CheckItem> lkl = this.groupList.values().iterator().next();
                for (CheckItem ci : lkl) {
                    root.add(ci.asElement());
                }
                break block6;
            }
            for (String name : this.groupList.keySet()) {
                Element groupElem = root.addElement("group");
                groupElem.addAttribute("name", name);
                LinkedList<CheckItem> lkl = this.groupList.get(name);
                for (CheckItem ci : lkl) {
                    groupElem.add(ci.asElement());
                }
            }
        }
        return document;
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    public static boolean validate(String xml) {
        try {
            String sLoc = new File(ConfigFetch.getChecklistSchemaLocation()).getAbsoluteFile().toURI().toString();
            XMLValidator xmlVal = new XMLValidator(xml, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"ChecklistType:validate", (Throwable)e);
            return false;
        }
    }

    public boolean isTotallyChecked() {
        return true;
    }

    public static boolean validate(File file) {
        try {
            String xml = FileUtil.getFileAsString(file);
            return ChecklistType.validate(xml);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"ChecklistType:validate", (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.getName();
    }

    public ChecklistMission getCheckListMission() {
        ChecklistMission clm = new ChecklistMission();
        clm.setChecklist(this);
        clm.setId(this.getName());
        clm.setName(this.getName());
        return clm;
    }

    public ChecklistType createCopy() {
        ChecklistType ret = null;
        try {
            ret = (ChecklistType)this.clone();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this + ": Error creating copy of Checklist"), (Throwable)e);
        }
        return ret;
    }

    protected Object clone() throws CloneNotSupportedException {
        ChecklistType tmpChc = new ChecklistType();
        tmpChc.load(this.asElement());
        tmpChc.setOriginalFilePath("");
        return tmpChc;
    }
}

