/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.comm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PasswordPanel;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.comm.protocol.AdjustTimeShellArgs;
import pt.lsts.neptus.types.comm.protocol.FTPArgs;
import pt.lsts.neptus.types.comm.protocol.IMCArgs;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;

public class CommMean
implements XmlOutputMethods {
    protected static final String DEFAULT_ROOT_ELEMENT = "comm-mean";
    public static final String IMC = "imc";
    public static final String HTTP = "http";
    public static final String IRIDIUM = "iridium";
    public static final String GSM = "gsm";
    protected String name = "";
    protected String type = "";
    protected String hostAddress = "127.0.0.1";
    protected String userName = "root";
    protected String password = null;
    protected boolean isPasswordSaved = false;
    protected LinkedList<String> protocols = new LinkedList();
    protected LinkedHashMap<String, ProtocolArgs> protocolsArgs = new LinkedHashMap();
    protected String latency = "";
    protected String latencyUnit = "";
    protected boolean isActive = true;
    private Document doc = null;

    public CommMean() {
    }

    public CommMean(String xml) {
        this.load(xml);
    }

    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
            this.name = this.doc.selectSingleNode("//name").getText();
            this.type = this.doc.selectSingleNode("//type").getText();
            this.hostAddress = this.doc.selectSingleNode("//host-address").getText();
            this.userName = this.doc.selectSingleNode("//credentials/@username").getText();
            Node nd = this.doc.selectSingleNode("//credentials/@password");
            if (nd != null) {
                this.password = nd.getText();
                this.isPasswordSaved = true;
            } else {
                this.isPasswordSaved = false;
            }
            nd = this.doc.selectSingleNode("//protocols");
            String protocolsStr = nd.getText();
            StringTokenizer strt = new StringTokenizer(protocolsStr, " ");
            while (strt.hasMoreTokens()) {
                this.protocols.add(strt.nextToken());
            }
            this.latency = this.doc.selectSingleNode("//latency/@value").getText();
            nd = this.doc.selectSingleNode("//latency/@unit");
            if (nd != null) {
                this.latencyUnit = nd.getText();
            }
            List lt = this.doc.selectNodes("//protocols-args/*");
            for (Node ndP : lt) {
                String nodeName = ndP.getName();
                if (nodeName.equalsIgnoreCase("ftp")) {
                    FTPArgs ftpA = new FTPArgs(ndP.asXML());
                    this.protocolsArgs.put("ftp", ftpA);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(IMC)) {
                    IMCArgs imcA = new IMCArgs(ndP.asXML());
                    this.protocolsArgs.put(IMC, imcA);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("time-shell")) continue;
                AdjustTimeShellArgs adjTimeParam = new AdjustTimeShellArgs(ndP.asXML());
                this.protocolsArgs.put("time-shell", adjTimeParam);
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        if (this.password == null || !this.isPasswordSaved()) {
            String[] ret = PasswordPanel.showPasswordDialog("Enter password for " + this.hostAddress, this.userName, this.password, this.isPasswordSaved);
            this.setPassword(ret[0]);
            this.setPasswordSaved(Boolean.parseBoolean(ret[1]));
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPasswordSaved() {
        return this.isPasswordSaved;
    }

    public void setPasswordSaved(boolean isPasswordSaved) {
        this.isPasswordSaved = isPasswordSaved;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public String getLatency() {
        return this.latency;
    }

    public void setLatency(String latency) {
        this.latency = latency;
    }

    public String getLatencyUnit() {
        return this.latencyUnit;
    }

    public void setLatencyUnit(String latencyUnit) {
        this.latencyUnit = latencyUnit;
    }

    public LinkedList<String> getProtocols() {
        return this.protocols;
    }

    public LinkedHashMap<String, ProtocolArgs> getProtocolsArgs() {
        return this.protocolsArgs;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("name").setText(this.name);
        root.addElement("type").setText(this.type);
        root.addElement("host-address").setText(this.hostAddress);
        Element cred = root.addElement("credentials");
        cred.addAttribute("username", this.userName);
        if (this.isPasswordSaved) {
            cred.addAttribute("password", this.password);
        }
        String protocolsStr = "";
        for (String pt : this.protocols) {
            protocolsStr = protocolsStr + " " + pt;
        }
        root.addElement("protocols").setText(protocolsStr);
        Element laten = root.addElement("latency");
        laten.addAttribute("value", this.latency);
        if (!"".equals(this.latencyUnit)) {
            laten.addAttribute("unit", this.latencyUnit);
        }
        if (this.protocolsArgs.size() > 0) {
            Element protoArgs = root.addElement("protocols-args");
            Iterator<Object> it = this.protocolsArgs.values().iterator();
            while (it.hasNext()) {
                Element elem = ((ProtocolArgs)it.next()).asElement();
                protoArgs.add(elem);
            }
        }
        return document;
    }
}

