/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.comm.protocol;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.util.Dom4JUtil;

public class AdjustTimeShellArgs
extends ProtocolArgs {
    public static final String DEFAULT_ROOT_ELEMENT = "time-shell";
    protected boolean setSeconds = true;
    protected boolean setYear = true;
    protected boolean use2DigitYear = false;
    protected boolean useHwClock = true;
    private Document doc = null;
    private boolean isLoadOk = true;

    public AdjustTimeShellArgs() {
    }

    public AdjustTimeShellArgs(String xml) {
        this.load(xml);
    }

    public boolean isSetSeconds() {
        return this.setSeconds;
    }

    public void setSetSeconds(boolean setSeconds) {
        this.setSeconds = setSeconds;
    }

    public boolean isSetYear() {
        return this.setYear;
    }

    public void setSetYear(boolean setYear) {
        this.setYear = setYear;
    }

    public boolean isUse2DigitYear() {
        return this.use2DigitYear;
    }

    public void setUse2DigitYear(boolean use2DigitYear) {
        this.use2DigitYear = use2DigitYear;
    }

    public boolean isUseHwClock() {
        return this.useHwClock;
    }

    public void setUseHwClock(boolean useHwClock) {
        this.useHwClock = useHwClock;
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    @Override
    public boolean load(Element elem) {
        try {
            this.doc = Dom4JUtil.elementToDocument(elem);
            if (this.doc == null) {
                this.isLoadOk = false;
                return false;
            }
            Node node = this.doc.selectSingleNode("//set-seconds");
            if (node != null) {
                this.setSeconds = Boolean.parseBoolean(node.getText());
            }
            if ((node = this.doc.selectSingleNode("//set-year")) != null) {
                this.setYear = Boolean.parseBoolean(node.getText());
            }
            if ((node = this.doc.selectSingleNode("//use-2-digit-year")) != null) {
                this.use2DigitYear = Boolean.parseBoolean(node.getText());
            }
            if ((node = this.doc.selectSingleNode("//use-hwclock")) != null) {
                this.useHwClock = Boolean.parseBoolean(node.getText());
            }
            this.isLoadOk = true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
            return this.load(this.doc.getRootElement());
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("set-seconds").setText(Boolean.toString(this.isSetSeconds()));
        root.addElement("set-year").setText(Boolean.toString(this.isSetYear()));
        root.addElement("use-2-digit-year").setText(Boolean.toString(this.isUse2DigitYear()));
        root.addElement("use-hwclock").setText(Boolean.toString(this.isUseHwClock()));
        return document;
    }
}

