/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.comm.protocol;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;

public class FTPArgs
extends ProtocolArgs {
    protected static final String DEFAULT_ROOT_ELEMENT = "ftp";
    public static final String BINARY_TRANSFER_MODE = "binary";
    public static final String ASCII_TRANSFER_MODE = "ascii";
    public static final String ACTIVE_CONNECTION_MODE = "active";
    public static final String PASV_CONNECTION_MODE = "pasv";
    protected String transferMode = "binary";
    protected String connectionMode = "pasv";
    private Document doc = null;
    private boolean isLoadOk = true;

    public FTPArgs() {
    }

    public FTPArgs(String xml) {
        this.load(xml);
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    @Override
    public boolean load(Element elem) {
        try {
            this.transferMode = elem.selectSingleNode("//transfer/@mode").getText();
            this.connectionMode = elem.selectSingleNode("//connection/@mode").getText();
            this.isLoadOk = true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
            return this.load(this.doc.getRootElement());
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
    }

    public String getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(String transferMode) {
        this.transferMode = transferMode;
    }

    public String getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(String connectionMode) {
        this.connectionMode = connectionMode;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("transfer").addAttribute("mode", this.transferMode);
        root.addElement("connection").addAttribute("mode", this.connectionMode);
        return document;
    }
}

