/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.comm.protocol;

import java.net.URL;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;

public class HTTPArgs
extends ProtocolArgs {
    protected URL url;
    protected Vector<String> formats;
    protected boolean loadOk;

    public HTTPArgs() {
        this.DEFAULT_ROOT_ELEMENT = "http";
        this.formats = new Vector();
        this.loadOk = true;
    }

    @Override
    public boolean isLoadOk() {
        return this.loadOk;
    }

    @Override
    public boolean load(Element elem) {
        try {
            this.url = new URL(elem.selectSingleNode("//url").getText());
            String fmts = elem.selectSingleNode("//supported-formats").getText();
            for (String f : fmts.split(",")) {
                this.formats.add(f.trim().toLowerCase());
            }
            this.loadOk = true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.loadOk = false;
        }
        return this.loadOk;
    }

    @Override
    public boolean load(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            this.loadOk = this.load(doc.getRootElement());
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.loadOk = false;
        }
        return this.loadOk;
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("url").setText(this.url.getPath());
        String tmp = "";
        if (this.formats.size() > 0) {
            tmp = this.formats.get(0);
        }
        for (int i = 1; i < this.formats.size(); ++i) {
            tmp = tmp + ", " + this.formats.get(i);
        }
        root.addElement("supported-formats").setText(tmp);
        return document;
    }

    public final URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public final Vector<String> getSupportedFormats() {
        return this.formats;
    }

    public void setSupportedFormats(Vector<String> formats) {
        for (int i = 0; i < formats.size(); ++i) {
            formats.setElementAt(formats.get(i).trim().toLowerCase(), i);
        }
        this.formats = formats;
    }

    public boolean isFormatSupported(String format) {
        return this.formats.contains(format.trim().toLowerCase());
    }
}

