/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.comm.protocol;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.util.Dom4JUtil;

public class IMCArgs
extends ProtocolArgs {
    protected static final String DEFAULT_ROOT_ELEMENT = "imc";
    public static final int DEFAULT_PORT = 6002;
    protected int port = 6002;
    protected int portTCP = 6002;
    protected boolean udpOn = true;
    protected boolean tcpOn = false;
    protected ImcId16 imc3Id = null;
    private Document doc = null;
    private boolean isLoadOk = true;

    public IMCArgs() {
    }

    public IMCArgs(String xml) {
        this.load(xml);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPortTCP() {
        return this.portTCP;
    }

    public void setPortTCP(int portTCP) {
        this.portTCP = portTCP;
    }

    public boolean isUdpOn() {
        return this.udpOn;
    }

    public void setUdpOn(boolean udpOn) {
        this.udpOn = udpOn;
    }

    public boolean isTcpOn() {
        return this.tcpOn;
    }

    public void setTcpOn(boolean tcpOn) {
        this.tcpOn = tcpOn;
    }

    public ImcId16 getImc3Id() {
        return this.imc3Id;
    }

    public void setImc3Id(ImcId16 imc3Id) {
        this.imc3Id = imc3Id;
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    @Override
    public boolean load(Element elem) {
        try {
            this.doc = Dom4JUtil.elementToDocument(elem);
            if (this.doc == null) {
                this.isLoadOk = false;
                return false;
            }
            this.port = Integer.parseInt(this.doc.selectSingleNode("//port").getText());
            Node node = this.doc.selectSingleNode("//port-tcp");
            this.portTCP = node != null ? Integer.parseInt(node.getText()) : 6002;
            node = this.doc.selectSingleNode("//udp-on");
            this.udpOn = node != null ? Boolean.parseBoolean(node.getText()) : true;
            node = this.doc.selectSingleNode("//tcp-on");
            this.tcpOn = node != null ? Boolean.parseBoolean(node.getText()) : false;
            node = this.doc.selectSingleNode("//imc3-id");
            this.imc3Id = node != null ? new ImcId16(node.getText()) : null;
            this.isLoadOk = true;
        }
        catch (Exception e) {
            this.port = 6002;
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
            return this.load(this.doc.getRootElement());
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("port").setText(Integer.toString(this.port));
        root.addElement("port-tcp").setText(Integer.toString(this.portTCP));
        root.addElement("udp-on").setText(Boolean.toString(this.isUdpOn()));
        root.addElement("tcp-on").setText(Boolean.toString(this.isTcpOn()));
        if (this.getImc3Id() != null) {
            root.addElement("imc3-id").setText(this.getImc3Id().toPrettyString());
        }
        return document;
    }
}

