/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.util.Arrays;

public class CoordAxisUtil {
    public static final short[] NED = new short[]{0, 2, 5};
    public static final short[][] VALID_AXIS_DIRECTIONS = new short[][]{{0, 2, 5}, {0, 5, 3}, {0, 3, 4}, {0, 4, 2}};
    public static final double[][] VALID_AXIS_ANGLES = new double[][]{{0.0, 0.0, 0.0}, {90.0, 0.0, 0.0}, {180.0, 0.0, 0.0}, {-90.0, 0.0, 0.0}};

    public static double[] getAxisAngles(short xAxisDirection, short yAxisDirection, short zAxisDirection) {
        boolean test = false;
        short[] dir = new short[]{xAxisDirection, yAxisDirection, zAxisDirection};
        for (int i = 0; i < VALID_AXIS_DIRECTIONS.length; ++i) {
            short[] dirTest = VALID_AXIS_DIRECTIONS[i];
            test = Arrays.equals(dir, dirTest);
            if (!test) continue;
            if (i >= VALID_AXIS_ANGLES.length) {
                return null;
            }
            double[] result = VALID_AXIS_ANGLES[i];
            return result;
        }
        return null;
    }

    public static short[] getAxisDirections(double roll, double pitch, double yaw) {
        short[] unknown = new short[]{-1, -1, -1};
        boolean test = false;
        double[] ang = new double[]{roll, pitch, yaw};
        for (int i = 0; i < VALID_AXIS_ANGLES.length; ++i) {
            double[] angTest = VALID_AXIS_ANGLES[i];
            test = Arrays.equals(ang, angTest);
            if (!test) continue;
            if (i >= VALID_AXIS_DIRECTIONS.length) {
                return unknown;
            }
            short[] result = VALID_AXIS_DIRECTIONS[i];
            return result;
        }
        return unknown;
    }

    public static short parseDirection(String dir) {
        if (dir.equalsIgnoreCase("north")) {
            return 0;
        }
        if (dir.equalsIgnoreCase("south")) {
            return 1;
        }
        if (dir.equalsIgnoreCase("east")) {
            return 2;
        }
        if (dir.equalsIgnoreCase("west")) {
            return 3;
        }
        if (dir.equalsIgnoreCase("up")) {
            return 4;
        }
        if (dir.equalsIgnoreCase("down")) {
            return 5;
        }
        if (dir.equalsIgnoreCase("n")) {
            return 0;
        }
        if (dir.equalsIgnoreCase("s")) {
            return 1;
        }
        if (dir.equalsIgnoreCase("e")) {
            return 2;
        }
        if (dir.equalsIgnoreCase("w")) {
            return 3;
        }
        if (dir.equalsIgnoreCase("u")) {
            return 4;
        }
        if (dir.equalsIgnoreCase("d")) {
            return 5;
        }
        return -1;
    }

    public static String getDirectionAsString(short dir) {
        if (dir == 0) {
            return "north";
        }
        if (dir == 1) {
            return "south";
        }
        if (dir == 2) {
            return "east";
        }
        if (dir == 3) {
            return "west";
        }
        if (dir == 4) {
            return "up";
        }
        if (dir == 5) {
            return "down";
        }
        return "unknown";
    }
}

