/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordAxisUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.MathMiscUtils;

public class CoordinateSystem
extends LocationType {
    protected static final String DEFAULT_CS_NAME = "N0E0_NED";
    protected static final String DEFAULT_CS_ID = "N0E0_NED";
    public static final short MIN_DIRECTION = -1;
    public static final short UNKNOWN_DIRECTION = -1;
    public static final short NORTH_DIRECTION = 0;
    public static final short SOUTH_DIRECTION = 1;
    public static final short EAST_DIRECTION = 2;
    public static final short WEST_DIRECTION = 3;
    public static final short UP_DIRECTION = 4;
    public static final short DOWN_DIRECTION = 5;
    public static final short MAX_DIRECTION = 5;
    public static final String UNKNOWN_DIRECTION_STRING = "unknown";
    public static final String NORTH_DIRECTION_STRING = "north";
    public static final String SOUTH_DIRECTION_STRING = "south";
    public static final String EAST_DIRECTION_STRING = "east";
    public static final String WEST_DIRECTION_STRING = "west";
    public static final String UP_DIRECTION_STRING = "up";
    public static final String DOWN_DIRECTION_STRING = "down";
    protected static final String DEFAULT_ROOT_ELEMENT = "coordinate-system-def";
    protected boolean anglesUsed = true;
    protected double roll = 0.0;
    protected double pitch = 0.0;
    protected double yaw = 0.0;
    protected short xAxisDirection = 0;
    protected short yAxisDirection = (short)2;
    protected short zAxisDirection = (short)5;

    public CoordinateSystem() {
    }

    public CoordinateSystem(String xml) {
        this.load(xml);
    }

    public void setCoordinateSystem(CoordinateSystem anotherCS) {
        this.setLocation(anotherCS);
        this.setRoll(anotherCS.getRoll());
        this.setPitch(anotherCS.getPitch());
        this.setYaw(anotherCS.getYaw());
    }

    @Override
    public boolean load(Document doc) {
        try {
            boolean res = super.load(doc);
            if (!res) {
                throw new DocumentException();
            }
            Node nd = doc.selectSingleNode("//axis-attitude/roll");
            if (nd != null) {
                this.setRoll(Double.parseDouble(nd.getText()), true);
                nd = doc.selectSingleNode("//axis-attitude/pitch");
                if (nd != null) {
                    this.setPitch(Double.parseDouble(nd.getText()));
                }
                if ((nd = doc.selectSingleNode("//axis-attitude/yaw")) != null) {
                    this.setYaw(Double.parseDouble(nd.getText()));
                }
            } else {
                nd = doc.selectSingleNode("//axis-attitude/x-axis-direction");
                if (nd != null) {
                    short[] dir = new short[3];
                    dir[0] = CoordAxisUtil.parseDirection(nd.getText());
                    nd = doc.selectSingleNode("//axis-attitude/y-axis-direction");
                    dir[1] = CoordAxisUtil.parseDirection(nd.getText());
                    nd = doc.selectSingleNode("//axis-attitude/z-axis-direction");
                    dir[2] = CoordAxisUtil.parseDirection(nd.getText());
                    boolean tr = this.setAxisDirections(dir[0], dir[1], dir[2], true);
                    if (!tr) {
                        return false;
                    }
                }
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean setAxisDirections(short xAxisDirection, short yAxisDirection, short zAxisDirection, boolean useDirectionsInXMLOutput) {
        boolean res = this.setAxisDirections(xAxisDirection, yAxisDirection, zAxisDirection);
        if (res) {
            this.setAnglesUsed(!useDirectionsInXMLOutput);
        }
        return res;
    }

    private boolean setAxisDirections(short xAxisDirection, short yAxisDirection, short zAxisDirection) {
        if (xAxisDirection < -1 & xAxisDirection > 5) {
            return false;
        }
        if (yAxisDirection < -1 & yAxisDirection > 5) {
            return false;
        }
        if (zAxisDirection < -1 & zAxisDirection > 5) {
            return false;
        }
        double[] ang = CoordAxisUtil.getAxisAngles(xAxisDirection, yAxisDirection, zAxisDirection);
        if (ang == null) {
            return false;
        }
        this.setXAxisDirection(xAxisDirection);
        this.setYAxisDirection(yAxisDirection);
        this.setZAxisDirection(zAxisDirection);
        this.setRoll(ang[0]);
        this.setPitch(ang[1]);
        this.setYaw(ang[2]);
        return true;
    }

    private void updateAxisDirections() {
        short[] dir = CoordAxisUtil.getAxisDirections(this.roll, this.pitch, this.yaw);
        this.setXAxisDirection(dir[0]);
        this.setYAxisDirection(dir[1]);
        this.setZAxisDirection(dir[2]);
    }

    public double getRoll() {
        return this.roll;
    }

    public void setRoll(double rollDegrees) {
        this.roll = rollDegrees;
        this.updateAxisDirections();
    }

    public void setRoll(double rollDegrees, boolean useAnglesInXMLOutput) {
        this.setRoll(rollDegrees);
        this.setAnglesUsed(useAnglesInXMLOutput);
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitchDegrees) {
        this.pitch = pitchDegrees;
        this.updateAxisDirections();
    }

    public void setPitch(double pitchDegrees, boolean useAnglesInXMLOutput) {
        this.setPitch(pitchDegrees);
        this.setAnglesUsed(useAnglesInXMLOutput);
    }

    public double getYaw() {
        return this.yaw;
    }

    public void setYaw(double yawDegrees) {
        this.yaw = yawDegrees;
        this.updateAxisDirections();
    }

    public void setYaw(double yawDegrees, boolean useAnglesInXMLOutput) {
        this.setYaw(yawDegrees);
        this.setAnglesUsed(useAnglesInXMLOutput);
    }

    private short getXAxisDirection() {
        return this.xAxisDirection;
    }

    private void setXAxisDirection(short axisDirection) {
        this.xAxisDirection = axisDirection;
    }

    private short getYAxisDirection() {
        return this.yAxisDirection;
    }

    private void setYAxisDirection(short axisDirection) {
        this.yAxisDirection = axisDirection;
    }

    private short getZAxisDirection() {
        return this.zAxisDirection;
    }

    private void setZAxisDirection(short axisDirection) {
        this.zAxisDirection = axisDirection;
    }

    public boolean isAnglesUsed() {
        return this.anglesUsed;
    }

    public void setAnglesUsed(boolean anglesUsed) {
        this.anglesUsed = anglesUsed;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("id").addText(this.getId());
        root.addElement("name").addText(this.getName());
        Element origin = root.addElement("origin");
        origin.addElement("latitude").addText(this.getLatitudeStr());
        origin.addElement("longitude").addText(this.getLongitudeStr());
        origin.addElement("depth").addText(String.valueOf(this.getDepth()));
        if (this.getOffsetDistance() != 0.0) {
            origin.addElement("azimuth").addText(String.valueOf(this.getAzimuth()));
            origin.addElement("offset-distance").addText(String.valueOf(this.getOffsetDistance()));
            origin.addElement("zenith").addText(String.valueOf(this.getZenith()));
        }
        if (!(this.getOffsetNorth() == 0.0 & this.getOffsetEast() == 0.0 & this.getOffsetUp() == 0.0)) {
            if (this.isOffsetNorthUsed()) {
                origin.addElement("offset-north").addText(String.valueOf(this.getOffsetNorth()));
            } else {
                origin.addElement("offset-south").addText(String.valueOf(this.getOffsetSouth()));
            }
            if (this.isOffsetEastUsed()) {
                origin.addElement("offset-east").addText(String.valueOf(this.getOffsetEast()));
            } else {
                origin.addElement("offset-west").addText(String.valueOf(this.getOffsetWest()));
            }
            if (this.isOffsetUpUsed()) {
                origin.addElement("offset-up").addText(String.valueOf(this.getOffsetUp()));
            } else {
                origin.addElement("offset-down").addText(String.valueOf(this.getOffsetDown()));
            }
        }
        if (!(this.getRoll() == 0.0 & this.getPitch() == 0.0 & this.getYaw() == 0.0)) {
            Element axisAttitude = root.addElement("axis-attitude");
            boolean teb = this.isAnglesUsed();
            if (!(teb || this.getXAxisDirection() != -1 && this.getYAxisDirection() != -1 && this.getZAxisDirection() != -1)) {
                teb = true;
            }
            if (teb) {
                axisAttitude.addElement("roll").addText(String.valueOf(MathMiscUtils.round(this.getRoll(), 2)));
                axisAttitude.addElement("pitch").addText(String.valueOf(MathMiscUtils.round(this.getPitch(), 2)));
                axisAttitude.addElement("yaw").addText(String.valueOf(MathMiscUtils.round(this.getYaw(), 2)));
            } else {
                axisAttitude.addElement("x-axis-direction").addText(CoordAxisUtil.getDirectionAsString(this.getXAxisDirection()));
                axisAttitude.addElement("y-axis-direction").addText(CoordAxisUtil.getDirectionAsString(this.getYAxisDirection()));
                axisAttitude.addElement("z-axis-direction").addText(CoordAxisUtil.getDirectionAsString(this.getZAxisDirection()));
            }
        }
        return document;
    }

    public static CoordinateSystem createDefaultCoordinateSystem() {
        CoordinateSystem cs = new CoordinateSystem();
        cs.setId("N0E0_NED");
        cs.setName("N0E0_NED");
        return cs;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CoordinateSystem)) {
            return false;
        }
        CoordinateSystem otherCS = (CoordinateSystem)obj;
        if (otherCS.getDistanceInMeters(new LocationType(this)) != 0.0) {
            return false;
        }
        if (otherCS.getRoll() != this.getRoll()) {
            return false;
        }
        if (otherCS.getYaw() != this.getYaw()) {
            return false;
        }
        return otherCS.getPitch() == this.getPitch();
    }

    @Override
    public String toString() {
        String ang = "   ::   ";
        ang = this.isAnglesUsed() ? ang + "roll=" + this.getRoll() + "\u00b0 pitch=" + this.getPitch() + "\u00b0 yaw=" + this.getYaw() + "\u00b0" : ang + "x-dir=" + this.getXAxisDirection() + "  y-dir=" + this.getYAxisDirection() + "  z-dir=" + this.getZAxisDirection();
        return super.toString() + ang;
    }

    @Override
    public <L extends LocationType> L getNewAbsoluteLatLonDepth() {
        CoordinateSystem coord;
        Object ret = super.getNewAbsoluteLatLonDepth();
        if (ret instanceof CoordinateSystem) {
            coord = (CoordinateSystem)ret;
        } else {
            coord = new CoordinateSystem();
            coord.setLocation((LocationType)ret);
        }
        coord.anglesUsed = this.anglesUsed;
        coord.roll = this.roll;
        coord.pitch = this.pitch;
        coord.yaw = this.yaw;
        coord.xAxisDirection = this.xAxisDirection;
        coord.yAxisDirection = this.yAxisDirection;
        coord.zAxisDirection = this.zAxisDirection;
        ret = coord;
        return ret;
    }

    @Override
    public String getClipboardText() {
        return super.getClipboardText() + this.getRoll() + " " + this.getPitch() + " " + this.getYaw() + "\n";
    }

    @Override
    public boolean fromClipboardText(String text) {
        boolean ret = super.fromClipboardText(text);
        if (!ret) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(text);
        if (st.countTokens() == 11) {
            this.setAnglesUsed(false);
            this.setRoll(0.0);
            this.setPitch(0.0);
            this.setYaw(0.0);
        } else if (st.countTokens() >= 14) {
            for (int i = 0; i < 11; ++i) {
                st.nextToken();
            }
            this.setRoll(Double.parseDouble(st.nextToken()));
            this.setPitch(Double.parseDouble(st.nextToken()));
            this.setYaw(Double.parseDouble(st.nextToken()));
        } else {
            ret = false;
        }
        return ret;
    }

    public static void main(String[] args) {
        CoordinateSystem c1 = new CoordinateSystem();
        CoordinateSystem c2 = (CoordinateSystem)c1.getNewAbsoluteLatLonDepth();
        NeptusLog.pub().info((Object)("<###> " + c1));
        NeptusLog.pub().info((Object)("<###> " + c2));
        LocationType l1 = new LocationType();
        Object l2 = l1.getNewAbsoluteLatLonDepth();
        Object l3 = c1.getNewAbsoluteLatLonDepth();
        NeptusLog.pub().info((Object)("<###> " + l1));
        NeptusLog.pub().info((Object)("<###> " + l2));
        NeptusLog.pub().info((Object)("<###> " + l3));
        try {
            c2 = (CoordinateSystem)l1.getNewAbsoluteLatLonDepth();
            NeptusLog.pub().info((Object)("<###> " + l1));
            NeptusLog.pub().info((Object)("<###> " + c2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        l1.translatePosition(100.0, 50.0, 2.0);
        String clp = l1.getClipboardText();
        CoordinateSystem cc1 = new CoordinateSystem();
        cc1.fromClipboardText(clp);
        LocationType ll1 = new LocationType();
        ll1.fromClipboardText(clp);
        CoordinateSystem cc2 = new CoordinateSystem();
        cc2.fromClipboardText(cc1.getClipboardText());
        LocationType ll2 = new LocationType();
        ll2.fromClipboardText(cc2.getClipboardText());
        NeptusLog.pub().info((Object)("<###> " + l1));
        NeptusLog.pub().info((Object)("<###> " + cc1));
        NeptusLog.pub().info((Object)("<###> " + ll1));
        NeptusLog.pub().info((Object)("<###> " + cc2));
        NeptusLog.pub().info((Object)("<###> " + ll2));
        NeptusLog.pub().info((Object)("<###> " + l1.asXML()));
        NeptusLog.pub().info((Object)("<###> " + c1.asXML()));
    }
}

