/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.XMLValidator;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class CoordinateSystemsHolder {
    private static LinkedHashMap<String, CoordinateSystem> coordinateSystemList = new LinkedHashMap();
    private Document doc;

    public CoordinateSystemsHolder(String url) {
        this.load(url);
    }

    public boolean load(String url) {
        String fileAsString = FileUtil.getFileAsString(url);
        try {
            String sLoc = new File(ConfigFetch.getCoordinateSystemSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(fileAsString, sLoc);
            xmlVal.validate();
        }
        catch (Exception e1) {
            NeptusLog.pub().error((Object)this, (Throwable)e1);
        }
        try {
            this.doc = DocumentHelper.parseText((String)fileAsString);
            List lst = this.doc.selectNodes("/coordinateSystems/coordinateSystem");
            ListIterator lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                Element elem = (Element)lstIt.next();
                CoordinateSystem cs = new CoordinateSystem(elem.asXML());
                coordinateSystemList.put(cs.getId(), cs);
            }
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
        }
        return true;
    }

    public int size() {
        return coordinateSystemList.size();
    }

    public LinkedHashMap<String, CoordinateSystem> getCoordinateSystemList() {
        return coordinateSystemList;
    }

    public static void main(String[] args) {
        new CoordinateSystemsHolder("conf/neptus-coordinateSystems.xml");
    }
}

