/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.vecmath.Matrix3d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.coord.MapTileUtil;

public class CoordinateUtil {
    public static final char CHAR_DEGREE = '\u00b0';
    public static final float MINUTE = 0.016666668f;
    public static final double MINUTE_D = 0.016666666666666666;
    public static final float SECOND = 2.7777778E-4f;
    public static final double SECOND_D = 2.777777777777778E-4;
    public static final double c_wgs84_a = 6378137.0;
    public static final double c_wgs84_e2 = 0.00669437999013;
    public static final double c_wgs84_f = 0.0033528106647475;
    private static final String DELIM = "NnSsEeWw\u00ba'\": \t\n\r\f\u00b0";
    public static final NumberFormat heading3DigitsFormat = new DecimalFormat("000");

    public static String[] parseCoordToStringArray(String coord) {
        String[] result = new String[]{"N", "0", "0", "0"};
        if (coord == null) {
            return null;
        }
        if ((coord = coord.replace(',', '.')).toUpperCase().indexOf(78) != -1) {
            result[0] = "N";
        } else if (coord.toUpperCase().indexOf(83) != -1) {
            result[0] = "S";
        } else if (coord.toUpperCase().indexOf(69) != -1) {
            result[0] = "E";
        } else if (coord.toUpperCase().indexOf(87) != -1) {
            result[0] = "W";
        } else {
            return null;
        }
        StringTokenizer strt = new StringTokenizer(coord, DELIM);
        if (strt.countTokens() < 1 | strt.countTokens() > 3) {
            return null;
        }
        int i = 1;
        while (strt.hasMoreTokens()) {
            result[i] = strt.nextToken();
            try {
                Double.parseDouble(result[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public static String[] parseLatitudeCoordToStringArray(String coord) {
        String[] result = CoordinateUtil.parseCoordToStringArray(coord);
        if (result == null) {
            return null;
        }
        if (result[0].equalsIgnoreCase("N")) {
            return result;
        }
        if (result[0].equalsIgnoreCase("S")) {
            return result;
        }
        return null;
    }

    public static String[] parseLongitudeCoordToStringArray(String coord) {
        String[] result = CoordinateUtil.parseCoordToStringArray(coord);
        if (result == null) {
            return null;
        }
        if (result[0].equalsIgnoreCase("E")) {
            return result;
        }
        if (result[0].equalsIgnoreCase("W")) {
            return result;
        }
        return null;
    }

    public static double parseLatitudeCoordToDoubleValue(String coord) {
        try {
            return Double.parseDouble(coord);
        }
        catch (Exception e) {
            double result = Double.NaN;
            String[] latStr = CoordinateUtil.parseLatitudeCoordToStringArray(coord);
            if (latStr == null) {
                return Double.NaN;
            }
            double latD = Double.NaN;
            double latM = Double.NaN;
            double latS = Double.NaN;
            try {
                latD = Double.parseDouble(latStr[1]);
                latM = Double.parseDouble(latStr[2]);
                latS = Double.parseDouble(latStr[3]);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
            double latDouble = latD;
            latDouble += latM * 0.016666666666666666;
            latDouble += latS * 2.777777777777778E-4;
            if (!latStr[0].equalsIgnoreCase("N")) {
                latDouble = -latDouble;
            }
            while (latDouble > 90.0) {
                latDouble -= 180.0;
            }
            while (latDouble < -90.0) {
                latDouble += 180.0;
            }
            result = latDouble;
            return result;
        }
    }

    public static double parseLongitudeCoordToDoubleValue(String coord) {
        try {
            return Double.parseDouble(coord);
        }
        catch (Exception e) {
            double result = Double.NaN;
            String[] lonStr = CoordinateUtil.parseLongitudeCoordToStringArray(coord);
            if (lonStr == null) {
                return Double.NaN;
            }
            double lonD = Double.NaN;
            double lonM = Double.NaN;
            double lonS = Double.NaN;
            try {
                lonD = Double.parseDouble(lonStr[1]);
                lonM = Double.parseDouble(lonStr[2]);
                lonS = Double.parseDouble(lonStr[3]);
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
            double lonDouble = lonD;
            lonDouble += lonM * 0.016666666666666666;
            lonDouble += lonS * 2.777777777777778E-4;
            if (!lonStr[0].equalsIgnoreCase("E")) {
                lonDouble = -lonDouble;
            }
            while (lonDouble > 180.0) {
                lonDouble -= 360.0;
            }
            while (lonDouble < -180.0) {
                lonDouble += 360.0;
            }
            result = lonDouble;
            return result;
        }
    }

    public static double[] parseLatitudeStringToDMS(String latitude) {
        double[] dms = new double[3];
        String[] latStr = CoordinateUtil.parseLatitudeCoordToStringArray(latitude);
        try {
            dms[0] = latStr[0].equalsIgnoreCase("S") ? -Double.parseDouble(latStr[1]) : Double.parseDouble(latStr[1]);
            dms[1] = Double.parseDouble(latStr[2]);
            dms[2] = Double.parseDouble(latStr[3]);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"parseLatitudeStringToDMS(String latitude)", (Throwable)e);
        }
        return dms;
    }

    public static double[] parseLongitudeStringToDMS(String longitude) {
        double[] dms = new double[3];
        String[] lonStr = CoordinateUtil.parseLongitudeCoordToStringArray(longitude);
        try {
            dms[0] = lonStr[0].equalsIgnoreCase("W") ? -Double.parseDouble(lonStr[1]) : Double.parseDouble(lonStr[1]);
            dms[1] = Double.parseDouble(lonStr[2]);
            dms[2] = Double.parseDouble(lonStr[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dms;
    }

    public static double dmsToDecimalDegrees(double degrees, double minutes, double seconds) {
        double signal = 1.0;
        while (degrees > 90.0) {
            degrees -= 180.0;
        }
        while (degrees < -90.0) {
            degrees += 180.0;
        }
        if (degrees < 0.0) {
            signal = -1.0;
        }
        return degrees + minutes * signal * 0.016666666666666666 + seconds * signal * 2.777777777777778E-4;
    }

    public static double[] dmsToDm(double degrees, double minutes, double seconds) {
        while (degrees > 90.0) {
            degrees -= 180.0;
        }
        while (degrees < -90.0) {
            degrees += 180.0;
        }
        double[] res = new double[]{degrees, minutes + seconds * 0.016666666666666666};
        return res;
    }

    public static double[] decimalDegreesToDMS(double decimalDegress) {
        double[] dms = new double[3];
        int multiplier = 1;
        if (decimalDegress < 0.0) {
            multiplier = -1;
            decimalDegress = -decimalDegress;
        }
        double remainder = decimalDegress - (double)((int)decimalDegress);
        dms[0] = Math.floor(decimalDegress);
        dms[1] = Math.floor(remainder * 60.0);
        dms[2] = (remainder -= dms[1] / 60.0) * 3600.0;
        dms[0] = (double)multiplier * dms[0];
        return dms;
    }

    public static double[] decimalDegreesToDM(double decimalDegress) {
        double[] dms = new double[3];
        double[] dm = new double[2];
        dms = CoordinateUtil.decimalDegreesToDMS(decimalDegress);
        dm[0] = dms[0];
        dm[1] = dms[1] + dms[2] / 60.0;
        return dm;
    }

    private static String dmsToLatLonString(double[] dms, boolean isLat, int maxDecimalHouses) {
        return CoordinateUtil.dmsToLatLonString(dms, isLat, false, maxDecimalHouses);
    }

    private static String dmToLatLonString(double[] dm, boolean isLat, int maxDecimalHouses) {
        return CoordinateUtil.dmsToLatLonString(dm, isLat, true, maxDecimalHouses);
    }

    private static String dmsToLatLonString(double[] dms, boolean isLat, boolean dmonly, int maxDecimalHouses) {
        if (maxDecimalHouses < 0) {
            maxDecimalHouses = 3;
        }
        String l = "N";
        if (!isLat) {
            l = "E";
        }
        double d = dms[0];
        double m = dms[1];
        double s = 0.0;
        if (!dmonly) {
            s = dms[2];
        }
        if ((d < 0.0 || "-0.0".equalsIgnoreCase("" + d)) && d + m + s != 0.0) {
            l = "S";
            if (!isLat) {
                l = "W";
            }
            d = Math.abs(d);
        }
        NumberFormat nformat = DecimalFormat.getInstance(Locale.US);
        nformat.setMaximumFractionDigits(maxDecimalHouses);
        nformat.setMinimumFractionDigits(Math.min(3, maxDecimalHouses));
        nformat.setGroupingUsed(false);
        if (CoordinateUtil.hasFracPart(d)) {
            nformat.setMaximumFractionDigits(maxDecimalHouses);
            return nformat.format(d) + l;
        }
        if (dmonly) {
            return new String((int)d + l + nformat.format(m));
        }
        if (CoordinateUtil.hasFracPart(m)) {
            nformat.setMaximumFractionDigits(maxDecimalHouses);
            return (int)Math.floor(d) + l + nformat.format(m);
        }
        nformat.setMaximumFractionDigits(maxDecimalHouses);
        return new String((int)Math.floor(d) + l + (int)Math.floor(m) + "'" + nformat.format(s) + "''");
    }

    private static boolean hasFracPart(double num) {
        double intPart = Math.floor(num);
        return num - intPart > 0.0;
    }

    public static String dmsToLatString(double[] dms) {
        return CoordinateUtil.dmsToLatLonString(dms, true, -1);
    }

    public static String dmsToLatString(double[] dms, int maxDecimalHouses) {
        return CoordinateUtil.dmsToLatLonString(dms, true, maxDecimalHouses);
    }

    public static String dmToLatString(double[] dm) {
        return CoordinateUtil.dmToLatLonString(dm, true, -1);
    }

    public static String dmToLatString(double[] dm, int maxDecimalHouses) {
        return CoordinateUtil.dmToLatLonString(dm, true, maxDecimalHouses);
    }

    public static String dmsToLatString(double d, double m, double s) {
        double[] dms = new double[]{d, m, s};
        return CoordinateUtil.dmsToLatLonString(dms, true, -1);
    }

    public static String dmsToLatString(double d, double m, double s, int maxDecimalHouses) {
        double[] dms = new double[]{d, m, s};
        return CoordinateUtil.dmsToLatLonString(dms, true, maxDecimalHouses);
    }

    public static String dmToLatString(double d, double m) {
        double[] dm = new double[]{d, m};
        return CoordinateUtil.dmToLatLonString(dm, true, -1);
    }

    public static String dmToLatString(double d, double m, int maxDecimalHouses) {
        double[] dm = new double[]{d, m};
        return CoordinateUtil.dmToLatLonString(dm, true, maxDecimalHouses);
    }

    public static String dmsToLonString(double[] dms) {
        return CoordinateUtil.dmsToLatLonString(dms, false, -1);
    }

    public static String dmsToLonString(double[] dms, int maxDecimalHouses) {
        return CoordinateUtil.dmsToLatLonString(dms, false, maxDecimalHouses);
    }

    public static String dmToLonString(double[] dm) {
        return CoordinateUtil.dmToLatLonString(dm, false, -1);
    }

    public static String dmToLonString(double[] dm, int maxDecimalHouses) {
        return CoordinateUtil.dmToLatLonString(dm, false, maxDecimalHouses);
    }

    public static String dmsToLonString(double d, double m, double s) {
        double[] dms = new double[]{d, m, s};
        return CoordinateUtil.dmsToLatLonString(dms, false, -1);
    }

    public static String dmsToLonString(double d, double m, double s, int maxDecimalHouses) {
        double[] dms = new double[]{d, m, s};
        return CoordinateUtil.dmsToLatLonString(dms, false, maxDecimalHouses);
    }

    public static String dmToLonString(double d, double m) {
        double[] dm = new double[]{d, m};
        return CoordinateUtil.dmToLatLonString(dm, false, -1);
    }

    public static String dmToLonString(double d, double m, int maxDecimalHouses) {
        double[] dm = new double[]{d, m};
        return CoordinateUtil.dmToLatLonString(dm, false, maxDecimalHouses);
    }

    private static String latLonTo83PFormatWorker(double latLonDegrees, boolean isLatOrLon) {
        String pad;
        String letter = latLonDegrees >= 0.0 ? (isLatOrLon ? "N" : "E") : (isLatOrLon ? "S" : "W");
        double[] latLonDM = CoordinateUtil.decimalDegreesToDM(AngleCalc.nomalizeAngleDegrees180(latLonDegrees));
        String latLonStr = CoordinateUtil.dmToLatString(latLonDM[0], latLonDM[1], 5);
        latLonStr = latLonStr.replaceAll("[NSEW]", ".");
        String[] latLonParts = latLonStr.split("\\.");
        int sizeD = latLonParts[0].length();
        int insertPad = 3 - sizeD;
        String string = pad = isLatOrLon ? "0 " : "00";
        while (insertPad > 0) {
            latLonParts[0] = pad.charAt(2 - insertPad--) + latLonParts[0];
        }
        if (latLonParts[1].length() < 2) {
            latLonParts[1] = "0" + latLonParts[1];
        }
        sizeD = latLonParts[2].length();
        insertPad = 5 - sizeD;
        pad = "0000";
        while (insertPad > 0) {
            latLonParts[2] = latLonParts[2] + pad.charAt(2 - insertPad--);
        }
        String ret = latLonParts[0] + "." + latLonParts[1] + "." + latLonParts[2] + " " + letter;
        return ret;
    }

    public static String latTo83PFormatWorker(double latDegrees) {
        return CoordinateUtil.latLonTo83PFormatWorker(latDegrees, true);
    }

    public static String lonTo83PFormatWorker(double lonDegrees) {
        return CoordinateUtil.latLonTo83PFormatWorker(lonDegrees, false);
    }

    private static double latLonFrom83PFormatWorker(String latLonStr) {
        String[] parts = latLonStr.trim().split("[\\. ]");
        double sign = -1.0;
        if ("N".equalsIgnoreCase(parts[3].trim()) || "E".equalsIgnoreCase(parts[3].trim())) {
            sign = 1.0;
        }
        return sign * (Double.parseDouble(parts[0].trim()) + Double.parseDouble(parts[1].trim() + "." + parts[2].trim()) / 60.0);
    }

    public static double latFrom83PFormatWorker(String latStr) {
        return CoordinateUtil.latLonFrom83PFormatWorker(latStr);
    }

    public static double lonFrom83PFormatWorker(String lonStr) {
        return CoordinateUtil.latLonFrom83PFormatWorker(lonStr);
    }

    public static double[] latLonAddNE2(double lat, double lon, double north, double east) {
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(lat);
        loc.setLongitudeDegs(lon);
        return CoordinateUtil.WGS84displace(lat, lon, 0.0, north, east, 0.0);
    }

    public static double[] latLonDiff(double lat, double lon, double alat, double alon) {
        double[] ret = CoordinateUtil.WGS84displacement(lat, lon, 0.0, alat, alon, 0.0);
        return new double[]{ret[0], ret[1]};
    }

    public static double[] bodyFrameToInertialFrame(double x, double y, double z, double phi, double theta, double psi) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        double cpsi = Math.cos(psi);
        double spsi = Math.sin(psi);
        double ctheta = Math.cos(theta);
        double stheta = Math.sin(theta);
        double cphi = Math.cos(phi);
        double sphi = Math.sin(phi);
        double t3 = y * cpsi;
        double t4 = stheta * sphi;
        double t6 = y * spsi;
        double t8 = z * cpsi;
        double t9 = stheta * cphi;
        double t11 = z * spsi;
        result[0] = cpsi * ctheta * x + t3 * t4 - t6 * cphi + t8 * t9 + t11 * sphi;
        result[1] = spsi * ctheta * x + t6 * t4 + t3 * cphi + t11 * t9 - t8 * sphi;
        result[2] = -stheta * x + ctheta * sphi * y + ctheta * cphi * z;
        return result;
    }

    public static double[] inertialFrameToBodyFrame(double x, double y, double z, double phi, double theta, double psi) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        double t1 = Math.cos(psi);
        double t2 = Math.cos(theta);
        double t5 = Math.sin(psi);
        double t8 = Math.sin(theta);
        result[0] = t1 * t2 * x + t5 * t2 * y - t8 * z;
        double t10 = x * t1;
        double t11 = Math.sin(phi);
        double t12 = t8 * t11;
        double t14 = x * t5;
        double t15 = Math.cos(phi);
        double t17 = y * t5;
        double t19 = y * t1;
        result[1] = t10 * t12 - t14 * t15 + t17 * t12 + t19 * t15 + t11 * t2 * z;
        double t23 = t8 * t15;
        result[2] = t10 * t23 + t14 * t11 + t17 * t23 - t19 * t11 + t15 * t2 * z;
        return result;
    }

    public static double[] sphericalToCartesianCoordinates(double r, double theta, double phi) {
        double[] cartesian = new double[3];
        if (r == 0.0) {
            cartesian[0] = 0.0;
            cartesian[1] = 0.0;
            cartesian[2] = 0.0;
            return cartesian;
        }
        theta = Math.toRadians(theta);
        phi = Math.toRadians(phi);
        double x = r * Math.cos(theta) * Math.sin(phi);
        double y = r * Math.sin(theta) * Math.sin(phi);
        double z = r * Math.cos(phi);
        cartesian[0] = x;
        cartesian[1] = y;
        cartesian[2] = z;
        return cartesian;
    }

    public static double[] cylindricalToCartesianCoordinates(double r, double theta, double h) {
        double[] cartesian = new double[3];
        if (r == 0.0) {
            cartesian[0] = 0.0;
            cartesian[1] = 0.0;
            cartesian[2] = h;
            return cartesian;
        }
        theta = Math.toRadians(theta);
        double x = r * Math.cos(theta);
        double y = r * Math.sin(theta);
        double z = h;
        cartesian[0] = x;
        cartesian[1] = y;
        cartesian[2] = z;
        return cartesian;
    }

    public static double[] cartesianToSphericalCoordinates(double x, double y, double z) {
        double[] polar = new double[3];
        double r = Math.sqrt(x * x + y * y + z * z);
        if (r >= 1.0E-6) {
            double theta = 0.0;
            if (Math.abs(x) > 1.0E-6) {
                theta = x > 0.0 ? Math.atan(y / x) : Math.PI + Math.atan(y / x);
            } else if (y == 0.0) {
                theta = 0.0;
            } else if (y > 0.0) {
                theta = 1.5707963267948966;
            } else if (y < 0.0) {
                theta = -1.5707963267948966;
            }
            double phi = Math.acos(z / r);
            polar[0] = r;
            polar[1] = theta;
            polar[2] = phi;
        } else if (r < 1.0E-6) {
            polar[0] = 0.0;
            polar[1] = 0.0;
            polar[2] = 0.0;
        }
        return polar;
    }

    public static double[] cartesianToCylindricalCoordinates(double x, double y, double z) {
        double[] cyl = new double[3];
        double r = Math.sqrt(x * x + y * y);
        double h = z;
        if (r >= 1.0E-6) {
            double theta = 0.0;
            if (Math.abs(x) > 1.0E-6) {
                theta = x > 0.0 ? Math.atan(y / x) : Math.PI + Math.atan(y / x);
            } else if (y == 0.0) {
                theta = 0.0;
            } else if (y > 0.0) {
                theta = 1.5707963267948966;
            } else if (y < 0.0) {
                theta = -1.5707963267948966;
            }
            cyl[0] = r;
            cyl[1] = theta;
            cyl[2] = h;
        } else if (r < 1.0E-6) {
            cyl[0] = 0.0;
            cyl[1] = 0.0;
            cyl[2] = h;
        }
        return cyl;
    }

    public static double[] sphericalToCylindricalCoordinates(double r, double theta, double phi) {
        double[] rec = CoordinateUtil.sphericalToCartesianCoordinates(r, theta, phi);
        double[] cyl = CoordinateUtil.cartesianToCylindricalCoordinates(rec[0], rec[1], rec[2]);
        return cyl;
    }

    public static double[] cylindricalToShericalCoordinates(double r, double theta, double h) {
        double[] rec = CoordinateUtil.cylindricalToCartesianCoordinates(r, theta, h);
        double[] sph = CoordinateUtil.cartesianToSphericalCoordinates(rec[0], rec[1], rec[2]);
        return sph;
    }

    public static double[] addSphericalToCartesianOffsetsAndGetAsCylindrical(double r, double theta, double phi, double x, double y, double z) {
        double[] sphRec = CoordinateUtil.sphericalToCartesianCoordinates(r, theta, phi);
        double[] recSum = new double[]{x + sphRec[0], y + sphRec[1], z + sphRec[2]};
        double[] result = CoordinateUtil.cartesianToCylindricalCoordinates(recSum[0], recSum[1], recSum[2]);
        return result;
    }

    private static double[] latLonDepthToGeocentricXYZ(double latitude, double longitude, double depth) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double Hi = -depth;
        double Lat = Math.toRadians(latitude);
        double Lon = Math.toRadians(longitude);
        double CFi = Math.cos(Lat);
        double SFi = Math.sin(Lat);
        double N = 4.0680631590769E13 / Math.sqrt(4.0680631590769E13 * CFi * CFi + 4.0408299984087055E13 * SFi * SFi);
        double[] xyz = new double[]{(N + Hi) * CFi * Math.cos(Lon), (N + Hi) * CFi * Math.sin(Lon), (0.9933056199957391 * N + Hi) * SFi};
        return xyz;
    }

    private static double[] geocentricXYZToLatLonDepth(double[] xyz) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double XY2 = xyz[0] * xyz[0] + xyz[1] * xyz[1];
        double XY = Math.sqrt(XY2);
        double en2 = 42841.31160397719;
        double ed2 = en2 * 6356752.3142 / 6378137.0;
        double den2 = xyz[2] * xyz[2] * 4.0680631590769E13 + XY2 * 4.0408299984087055E13;
        double den = Math.sqrt(den2);
        double Lat = Math.atan2(xyz[2] + en2 * 6378137.0 * 6378137.0 * 6378137.0 * xyz[2] * xyz[2] * xyz[2] / (den2 * den), XY - ed2 * 6356752.3142 * 6356752.3142 * 6356752.3142 * XY2 * XY / (den2 * den));
        double Lon = Math.atan2(xyz[1], xyz[0]);
        double CLat = Math.cos(Lat);
        double SLat = Math.sin(Lat);
        double N = 4.0680631590769E13 / Math.sqrt(4.0680631590769E13 * CLat * CLat + 4.0408299984087055E13 * SLat * SLat);
        double Hi = XY / CLat - N;
        double[] ret = new double[]{Math.toDegrees(Lat), Math.toDegrees(Lon), -Hi};
        return ret;
    }

    private static Matrix3d makeNedToEarthConversionMatrix(double[] latLonDepth) {
        double Lat = Math.toRadians(latLonDepth[0]);
        double Lon = Math.toRadians(latLonDepth[1]);
        Matrix3d m3d = new Matrix3d();
        m3d.m00 = -Math.sin(Lat) * Math.cos(Lon);
        m3d.m01 = -Math.sin(Lon);
        m3d.m02 = -Math.cos(Lat) * Math.cos(Lon);
        m3d.m10 = -Math.sin(Lat) * Math.sin(Lon);
        m3d.m11 = Math.cos(Lon);
        m3d.m12 = -Math.cos(Lat) * Math.sin(Lon);
        m3d.m20 = Math.cos(Lat);
        m3d.m21 = 0.0;
        m3d.m22 = -Math.sin(Lat);
        return m3d;
    }

    protected static double[] normalizeOffsetToLocation(double[] nedOffset, double[] LatLonDepth) {
        Matrix3d conversionMatrix = CoordinateUtil.makeNedToEarthConversionMatrix(LatLonDepth);
        double v3dx = nedOffset[0];
        double v3dy = nedOffset[1];
        double v3dz = nedOffset[2];
        double x = conversionMatrix.m00 * v3dx + conversionMatrix.m01 * v3dx + conversionMatrix.m02 * v3dx;
        double y = conversionMatrix.m10 * v3dy + conversionMatrix.m11 * v3dx + conversionMatrix.m12 * v3dx;
        double z = conversionMatrix.m20 * v3dz + conversionMatrix.m21 * v3dz + conversionMatrix.m22 * v3dz;
        return new double[]{x, y, z};
    }

    protected double[] latLonToUTM(double lat, double lon) {
        double WGS84_radius = 6378137.0;
        double WGS84_eccSqared = 0.00669438;
        double a = WGS84_radius;
        double eccSquared = WGS84_eccSqared;
        double k0 = 0.9996;
        double LatRad = Math.toRadians(lat);
        double LongRad = Math.toRadians(lon);
        int ZoneNumber = (int)((lon + 180.0) / 6.0) + 1;
        if (lon == 180.0) {
            ZoneNumber = 60;
        }
        if (lat >= 56.0 && lat < 64.0 && lon >= 3.0 && lon < 12.0) {
            ZoneNumber = 32;
        }
        if (lat >= 72.0 && lat < 84.0) {
            if (lon >= 0.0 && lon < 9.0) {
                ZoneNumber = 31;
            } else if (lon >= 9.0 && lon < 21.0) {
                ZoneNumber = 33;
            } else if (lon >= 21.0 && lon < 33.0) {
                ZoneNumber = 35;
            } else if (lon >= 33.0 && lon < 42.0) {
                ZoneNumber = 37;
            }
        }
        double LongOrigin = (ZoneNumber - 1) * 6 - 180 + 3;
        double LongOriginRad = Math.toRadians(LongOrigin);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double N = a / Math.sqrt(1.0 - eccSquared * Math.sin(LatRad) * Math.sin(LatRad));
        double T = Math.tan(LatRad) * Math.tan(LatRad);
        double C = eccPrimeSquared * Math.cos(LatRad) * Math.cos(LatRad);
        double A = Math.cos(LatRad) * (LongRad - LongOriginRad);
        double M = a * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * LatRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * LatRad) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * LatRad) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * LatRad));
        double UTMEasting = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;
        double UTMNorthing = (float)(k0 * (M + N * Math.tan(LatRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0)));
        if (lat < 0.0) {
            UTMNorthing += 1.0E7;
        }
        return new double[]{UTMNorthing * 1000.0, UTMEasting * 1000.0};
    }

    public static String latitudeAsString(double latitude) {
        return CoordinateUtil.latitudeAsString(latitude, true);
    }

    public static String longitudeAsString(double longitude) {
        return CoordinateUtil.longitudeAsString(longitude, true);
    }

    public static String latitudeAsPrettyString(double latitude, boolean showSeconds) {
        return CoordinateUtil.latitudeAsString(latitude, !showSeconds, showSeconds ? 6 : 8);
    }

    public static String longitudeAsPrettyString(double longitude, boolean showSeconds) {
        return CoordinateUtil.longitudeAsString(longitude, !showSeconds, showSeconds ? 6 : 8);
    }

    public static String latitudeAsString(double latitude, boolean minutesOnly) {
        return CoordinateUtil.latitudeAsString(latitude, minutesOnly, -1);
    }

    public static String latitudeAsString(double latitude, boolean minutesOnly, int maxDecimalHouses) {
        if (!minutesOnly) {
            return CoordinateUtil.dmsToLatLonString(CoordinateUtil.decimalDegreesToDMS(latitude), true, maxDecimalHouses);
        }
        return CoordinateUtil.dmToLatLonString(CoordinateUtil.decimalDegreesToDM(latitude), true, maxDecimalHouses);
    }

    public static String longitudeAsString(double longitude, boolean minutesOnly) {
        return CoordinateUtil.longitudeAsString(longitude, minutesOnly, -1);
    }

    public static String longitudeAsString(double longitude, boolean minutesOnly, int maxDecimalHouses) {
        if (!minutesOnly) {
            return CoordinateUtil.dmsToLatLonString(CoordinateUtil.decimalDegreesToDMS(longitude), false, maxDecimalHouses);
        }
        return CoordinateUtil.dmToLatLonString(CoordinateUtil.decimalDegreesToDM(longitude), false, maxDecimalHouses);
    }

    public static void copyToClipboard(LocationType lt) {
        LocationType lt2 = new LocationType();
        double[] absCoords = lt.getAbsoluteLatLonDepth();
        lt2.setLatitudeDegs(absCoords[0]);
        lt2.setLongitudeDegs(absCoords[1]);
        lt2.setDepth(absCoords[2]);
        ClipboardOwner owner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(lt2.getClipboardText()), owner);
    }

    private static double[] toECEF(double latDegrees, double lonDegrees, double depth) {
        double[] lld = new double[]{latDegrees, lonDegrees, depth};
        lld[0] = Math.toRadians(lld[0]);
        lld[1] = Math.toRadians(lld[1]);
        double cos_lat = Math.cos(lld[0]);
        double sin_lat = Math.sin(lld[0]);
        double cos_lon = Math.cos(lld[1]);
        double sin_lon = Math.sin(lld[1]);
        double rn = 6378137.0 / Math.sqrt(1.0 - 0.00669437999013 * sin_lat * sin_lat);
        double[] ned = new double[]{(rn - lld[2]) * cos_lat * cos_lon, (rn - lld[2]) * cos_lat * sin_lon, (0.99330562000987 * rn - lld[2]) * sin_lat};
        return ned;
    }

    private static double n_rad(double lat) {
        double lat_sin = Math.sin(lat);
        return 6378137.0 / Math.sqrt(1.0 - 0.00669437999013 * (lat_sin * lat_sin));
    }

    private static double[] toGeodetic(double x, double y, double z) {
        double[] lld = new double[3];
        double p = Math.sqrt(x * x + y * y);
        lld[1] = Math.atan2(y, x);
        lld[0] = Math.atan2(z / p, 0.01);
        double n = CoordinateUtil.n_rad(lld[0]);
        lld[2] = p / Math.cos(lld[0]) - n;
        double old_hae = -1.0E-9;
        double num = z / p;
        while (Math.abs(lld[2] - old_hae) > 1.0E-4) {
            old_hae = lld[2];
            double den = 1.0 - 0.00669437999013 * n / (n + lld[2]);
            lld[0] = Math.atan2(num, den);
            n = CoordinateUtil.n_rad(lld[0]);
            lld[2] = p / Math.cos(lld[0]) - n;
        }
        lld[0] = Math.toDegrees(lld[0]);
        lld[1] = Math.toDegrees(lld[1]);
        return lld;
    }

    public static double[] WGS84displacement(LocationType loc1, LocationType loc2) {
        Object locTmp1 = loc1.getNewAbsoluteLatLonDepth();
        Object locTmp2 = loc2.getNewAbsoluteLatLonDepth();
        return CoordinateUtil.WGS84displacement(((LocationType)locTmp1).getLatitudeDegs(), ((LocationType)locTmp1).getLongitudeDegs(), ((LocationType)locTmp1).getDepth(), ((LocationType)locTmp2).getLatitudeDegs(), ((LocationType)locTmp2).getLongitudeDegs(), ((LocationType)locTmp2).getDepth());
    }

    public static double[] WGS84displacement(double latDegrees1, double lonDegrees1, double depth1, double latDegrees2, double lonDegrees2, double depth2) {
        double[] cs1 = CoordinateUtil.toECEF(latDegrees1, lonDegrees1, depth1);
        double[] cs2 = CoordinateUtil.toECEF(latDegrees2, lonDegrees2, depth2);
        double ox = cs2[0] - cs1[0];
        double oy = cs2[1] - cs1[1];
        double oz = cs2[2] - cs1[2];
        double[] lld1 = new double[]{latDegrees1, lonDegrees1, depth1};
        double slat = Math.sin(Math.toRadians(lld1[0]));
        double clat = Math.cos(Math.toRadians(lld1[0]));
        double slon = Math.sin(Math.toRadians(lld1[1]));
        double clon = Math.cos(Math.toRadians(lld1[1]));
        double[] ret = new double[]{-slat * clon * ox - slat * slon * oy + clat * oz, -slon * ox + clon * oy, depth1 - depth2};
        return ret;
    }

    public static double[] WGS84displace(double latDegrees, double lonDegrees, double depth, double n, double e, double d) {
        double[] xyz = CoordinateUtil.toECEF(latDegrees, lonDegrees, depth);
        double[] lld = new double[]{latDegrees, lonDegrees, depth};
        double phi = Math.atan2(xyz[2], Math.sqrt(xyz[0] * xyz[0] + xyz[1] * xyz[1]));
        double slon = Math.sin(Math.toRadians(lld[1]));
        double clon = Math.cos(Math.toRadians(lld[1]));
        double sphi = Math.sin(phi);
        double cphi = Math.cos(phi);
        xyz[0] = xyz[0] + (-slon * e - clon * sphi * n - clon * cphi * d);
        xyz[1] = xyz[1] + (clon * e - slon * sphi * n - slon * cphi * d);
        xyz[2] = xyz[2] + (cphi * n - sphi * d);
        lld = CoordinateUtil.toGeodetic(xyz[0], xyz[1], xyz[2]);
        lld[2] = d != 0.0 ? depth + d : depth;
        return lld;
    }

    public static double[] getNEBearingDegreesAndRange(LocationType loc1, LocationType loc2) {
        double bearing = 0.0;
        double range = 0.0;
        double[] ne = CoordinateUtil.WGS84displacement(loc1, loc2);
        double n = ne[0];
        double e = ne[1];
        bearing = Math.atan2(e, n);
        range = Math.sqrt(n * n + e * e);
        return new double[]{Math.toDegrees(bearing), range};
    }

    @Deprecated
    public static LocationType getAbsoluteLatLonDepth(LocationType point) {
        return point.getNewAbsoluteLatLonDepth();
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)heading3DigitsFormat.format(34L));
        LocationType locA = new LocationType();
        locA.setLatitudeStr("41N10.6938");
        locA.setLongitudeStr("8W42.5051");
        LocationType locB = new LocationType();
        locB.setLatitudeStr("44N40.7312");
        locB.setLongitudeStr("63W32.2072");
        LocationType locC = new LocationType(locA);
        locC.translatePosition(100.0, 100.0, 0.0);
        locC.convertToAbsoluteLatLonDepth();
        LocationType locD = new LocationType(locB);
        locD.translatePosition(100.0, 100.0, 0.0);
        locD.convertToAbsoluteLatLonDepth();
        LocationType locE = new LocationType(locA);
        locE.translatePosition(10000.0, 10000.0, 0.0);
        locE.convertToAbsoluteLatLonDepth();
        LocationType locF = new LocationType(locB);
        locF.translatePosition(10000.0, 10000.0, 0.0);
        locF.convertToAbsoluteLatLonDepth();
        LocationType locG = new LocationType(locA);
        locG.setLatitudeDegs(locG.getLatitudeDegs() + 2.0);
        locG.setLongitudeDegs(locG.getLongitudeDegs() + 2.0);
        LocationType locH = new LocationType(locB);
        locH.setLatitudeDegs(locH.getLatitudeDegs() + 2.0);
        locH.setLongitudeDegs(locH.getLongitudeDegs() + 2.0);
        LocationType locI = new LocationType(locA);
        locI.setLatitudeDegs(locI.getLatitudeDegs() + 2.0);
        LocationType locJ = new LocationType(locB);
        locJ.setLatitudeDegs(locH.getLatitudeDegs() + 2.0);
        LocationType locK = new LocationType(locA);
        locK.setLongitudeDegs(locK.getLongitudeDegs() + 2.0);
        LocationType locL = new LocationType(locB);
        locL.setLongitudeDegs(locL.getLongitudeDegs() + 2.0);
        String[] obs = new String[]{"loc1 Leix\u00f5es :: loc2 Halifax, Canada", "loc1 Leix\u00f5es :: loc2=loc1 + N100m,E100m", "loc1 Halifax :: loc2=loc1 + N100m,E100m", "loc1 Leix\u00f5es :: loc2=loc1 + N10000m,E10000m", "loc1 Halifax :: loc2=loc1 + N10000m,E10000m", "loc1 Leix\u00f5es :: loc2=loc1 + N2\u00b0,E2\u00b0", "loc1 Halifax :: loc2=loc1 + N2\u00b0,E2\u00b0", "loc1 Leix\u00f5es :: loc2=loc1 + N2\u00b0", "loc1 Halifax :: loc2=loc1 + N2\u00b0", "loc1 Leix\u00f5es :: loc2=loc1 + E2\u00b0", "loc1 Halifax :: loc2=loc1 + E2\u00b0"};
        LocationType[] locations = new LocationType[]{locA, locB, locA, locC, locB, locD, locA, locE, locB, locF, locA, locG, locB, locH, locA, locI, locB, locJ, locA, locK, locB, locL};
        for (int i = 0; i < locations.length; ++i) {
            LocationType loc1 = locations[i];
            LocationType loc2 = locations[++i];
            NeptusLog.pub().info((Object)"_______________________________________________________________________________");
            NeptusLog.pub().info((Object)(">>> " + obs[i / 2] + " <<<"));
            System.out.println("loc1: {" + loc1.getLatitudeDegs() + "\u00b0, " + loc1.getLongitudeDegs() + "\u00b0, " + loc1.getDepth() + "]");
            System.out.println("loc2: {" + loc2.getLatitudeDegs() + "\u00b0, " + loc2.getLongitudeDegs() + "\u00b0, " + loc1.getDepth() + "]");
            double[] diff1 = loc1.getOffsetFrom(loc2);
            NeptusLog.pub().info((Object)("loc1.getOffsetFrom(loc2)\t\t[" + diff1[0] + ", " + diff1[1] + ", " + diff1[2] + "]"));
            double[] neDiff = CoordinateUtil.latLonDiff(loc2.getLatitudeDegs(), loc2.getLongitudeDegs(), loc1.getLatitudeDegs(), loc1.getLongitudeDegs());
            NeptusLog.pub().info((Object)("loc1.getOffsetFromWorker(loc2)\t\t[" + neDiff[0] + ", " + neDiff[1] + ", " + 0 + "]"));
            double[] locC1 = CoordinateUtil.latLonDepthToGeocentricXYZ(loc1.getLatitudeDegs(), loc1.getLongitudeDegs(), loc1.getDepth());
            NeptusLog.pub().info((Object)("latLonDepthToGeocentricXYZ:loc1 \t[[" + locC1[0] + ", " + locC1[1] + ", " + locC1[2] + "]]"));
            double[] locC2 = CoordinateUtil.latLonDepthToGeocentricXYZ(loc2.getLatitudeDegs(), loc2.getLongitudeDegs(), loc2.getDepth());
            NeptusLog.pub().info((Object)("latLonDepthToGeocentricXYZ:loc2 \t[[" + locC2[0] + ", " + locC2[1] + ", " + locC2[2] + "]]"));
            double[] diff2 = new double[]{locC1[0] - locC2[0], locC1[1] - locC2[1], locC1[2] - locC2[2]};
            NeptusLog.pub().info((Object)("diff of latLonDepthToGeocentricXYZ \t[" + diff2[0] + ", \t" + diff2[1] + ", \t" + diff2[2] + "]"));
            double ox = locC1[0] - locC2[0];
            double oy = locC1[1] - locC2[1];
            double oz = locC1[2] - locC2[2];
            double slat = Math.sin(loc2.getLatitudeRads());
            double clat = Math.cos(loc2.getLatitudeRads());
            double slon = Math.sin(loc2.getLongitudeRads());
            double clon = Math.cos(loc2.getLongitudeRads());
            double n = -slat * clon * ox - slat * slon * oy + clat * oz;
            double e = -slon * ox + clon * oy;
            NeptusLog.pub().info((Object)("diff similar to dune \t\t\t[" + n + ", \t" + e + ", \t" + 0 + "]"));
            double[] locC3 = CoordinateUtil.WGS84displacement(loc2, loc1);
            NeptusLog.pub().info((Object)("WGS84displacement(loc2, loc1) \t\t[" + locC3[0] + ", \t" + locC3[1] + ", \t" + locC3[2] + "]"));
            double[] diffPx = MapTileUtil.getOffsetFrom(loc2.getLatitudeDegs(), loc2.getLongitudeDegs(), loc1.getLatitudeDegs(), loc1.getLongitudeDegs());
            NeptusLog.pub().info((Object)("MapTileUtil.getOffsetFrom(loc2, loc1) \t[" + diffPx[0] + ", \t" + diffPx[1] + ", \t" + 0 + "]"));
            NeptusLog.pub().info((Object)"_______________________________________________________________________________");
        }
        String te = "41N3.6117";
        String[] st = CoordinateUtil.parseLatitudeCoordToStringArray(te);
        NeptusLog.pub().info((Object)(st[1] + st[0] + st[2] + " " + st[3]));
        NeptusLog.pub().info((Object)CoordinateUtil.parseLatitudeCoordToDoubleValue(te));
        te = "8W27.4009";
        st = CoordinateUtil.parseLongitudeCoordToStringArray(te);
        NeptusLog.pub().info((Object)(st[1] + st[0] + st[2] + " " + st[3]));
        NeptusLog.pub().info((Object)CoordinateUtil.parseLongitudeCoordToDoubleValue(te));
        NeptusLog.pub().info((Object)"\nVandalizado por RG em 20/1/2005");
        NeptusLog.pub().info((Object)"rotation of pi/2 of point (1,1,1). The result should be (-1,1,1)");
        double[] teste = CoordinateUtil.bodyFrameToInertialFrame(1.0, 1.0, 1.0, 0.0, 0.0, 1.5707963267948966);
        NeptusLog.pub().info((Object)(teste[0] + " " + teste[1] + " " + teste[2]));
        NeptusLog.pub().info((Object)"rotation of -pi/2 of point (-1,1,1). The result should be initial (1,1,1)");
        teste = CoordinateUtil.inertialFrameToBodyFrame(-1.0, 1.0, 1.0, 0.0, 0.0, 1.5707963267948966);
        NeptusLog.pub().info((Object)(teste[0] + " " + teste[1] + " " + teste[2]));
        NeptusLog.pub().info((Object)">>> Test latLonDepthToGeocentricXYZ and geocentricXYZToLatLonDepth:");
        double[] latLonDep = new double[]{41.3433, -8.2334, 100.0};
        double[] rev = CoordinateUtil.latLonDepthToGeocentricXYZ(latLonDep[0], latLonDep[1], latLonDep[2]);
        double[] latLonDep2 = CoordinateUtil.geocentricXYZToLatLonDepth(rev);
        NeptusLog.pub().info((Object)("Lat: " + latLonDep[0] + ", Lon: " + latLonDep[1] + ", Dep: " + latLonDep[2]));
        NeptusLog.pub().info((Object)("X: " + rev[0] + ", Y: " + rev[1] + ", Z: " + rev[2]));
        NeptusLog.pub().info((Object)("Lat: " + latLonDep2[0] + ", Lon: " + latLonDep2[1] + ", Dep: " + latLonDep2[2]));
        LocationType lt1 = new LocationType();
        lt1.setLatitudeDegs(41.0);
        lt1.setLongitudeDegs(-8.0);
        lt1.translatePosition(340.0, 234.0, 23.0);
        LocationType lt2 = new LocationType();
        lt2.setLatitudeDegs(42.655);
        lt2.setLongitudeDegs(-8.0012);
        lt2.translatePosition(23.0, 34.0, 435.0);
        lt2.setAzimuth(34.0);
        lt2.setOffsetDistance(456.0);
        double[] offs = lt2.getOffsetFrom(lt1);
        LocationType lt3 = new LocationType(lt1);
        lt3.translatePosition(offs[0], offs[1], offs[2]);
        NeptusLog.pub().info((Object)lt3.getDistanceInMeters(lt2));
        NeptusLog.pub().info((Object)CoordinateUtil.latitudeAsPrettyString(39.543, false));
        double lat1 = 41.345634567834345;
        String lat1Str = CoordinateUtil.dmsToLatString(CoordinateUtil.decimalDegreesToDMS(lat1));
        double lat1M = CoordinateUtil.parseLatitudeCoordToDoubleValue(lat1Str);
        NeptusLog.pub().info((Object)"--------------------------------------------------------");
        NeptusLog.pub().info((Object)lat1);
        NeptusLog.pub().info((Object)lat1Str);
        NeptusLog.pub().info((Object)lat1M);
        NeptusLog.pub().info((Object)CoordinateUtil.latitudeAsPrettyString(lat1, true));
        NeptusLog.pub().info((Object)"_________________________________________________________");
        NeptusLog.pub().info((Object)locC);
        NeptusLog.pub().info((Object)CoordinateUtil.latitudeAsString(0.56, true));
        NeptusLog.pub().info((Object)CoordinateUtil.latitudeAsString(1.06, true));
        NeptusLog.pub().info((Object)CoordinateUtil.latitudeAsString(-0.56, true));
        NeptusLog.pub().info((Object)CoordinateUtil.latitudeAsString(-1.06, true));
        NeptusLog.pub().info((Object)CoordinateUtil.longitudeAsString(0.56, true));
        NeptusLog.pub().info((Object)CoordinateUtil.longitudeAsString(1.06, true));
        NeptusLog.pub().info((Object)CoordinateUtil.longitudeAsString(-0.56, true));
        NeptusLog.pub().info((Object)CoordinateUtil.longitudeAsString(-1.06, true));
        NeptusLog.pub().info((Object)"_________________________________________________________");
        LocationType locA1 = new LocationType(0.0, 0.0);
        LocationType locA2 = new LocationType(1.0E-6, 0.0);
        NeptusLog.pub().info((Object)locA1.getDistanceInMeters(locA2));
    }
}

