/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import pt.lsts.neptus.NeptusLog;

public class GISCoordinate {
    public static final int SPHERE = 0;
    public static final int WGS84 = 1;
    public static final int NAD27 = 2;
    public static final int International = 3;
    public static final int Krasovsky = 4;
    public static final int Bessel = 5;
    public static final int WGS72 = 6;
    public static final int WGS66 = 7;
    public static final int FAI_sphere = 8;
    public static final int User = 9;
    public static final int NAD83 = 1;
    public static final int GRS80 = 1;
    private static Ellipsoid[] ells = new Ellipsoid[10];
    private double _lat = 0.0;
    private double _lon = 0.0;
    private String _sep = ",";
    private boolean _printLonFirst = false;

    public GISCoordinate(String lat, String latDir, String lon, String lonDir) throws Exception {
        this.setCoordinates(lat, latDir, lon, lonDir);
    }

    public GISCoordinate(double lat, double lon, boolean rad) {
        if (rad) {
            this._lat = lat * 57.29577951308232;
            this._lon = lon * 57.29577951308232;
        } else {
            this._lat = lat;
            this._lon = lon;
        }
        this.verify();
    }

    public void setCoordinates(String lat, String latDir, String lon, String lonDir) throws Exception {
        this._lat = this.parselatlon(lat) * (double)(latDir.equals("N") ? 1 : -1);
        this._lon = this.parselatlon(lon) * (double)(lonDir.equals("E") ? 1 : -1);
        this.verify();
    }

    public double getLatInRad() {
        return this._lat * (Math.PI / 180);
    }

    public double getLonInRad() {
        return this._lon * (Math.PI / 180);
    }

    public double getLatInDecDeg() {
        return this._lat;
    }

    public double getLonInDecDeg() {
        return this._lon;
    }

    public String getLatDeg() {
        String latS = this.degtodm(Math.abs(this._lat));
        return latS.substring(0, latS.indexOf(58));
    }

    public String getLatMin() {
        String latS = this.degtodm(Math.abs(this._lat));
        return latS.substring(latS.indexOf(58) + 1, latS.lastIndexOf(58));
    }

    public String getLatSec() {
        String latS = this.degtodm(Math.abs(this._lat));
        return latS.substring(latS.lastIndexOf(58) + 1);
    }

    public String getLonDeg() {
        String lonS = this.degtodm(Math.abs(this._lon));
        return lonS.substring(0, lonS.indexOf(58));
    }

    public String getLonMin() {
        String lonS = this.degtodm(Math.abs(this._lon));
        return lonS.substring(lonS.indexOf(58) + 1, lonS.lastIndexOf(58));
    }

    public String getLonSec() {
        String lonS = this.degtodm(Math.abs(this._lon));
        return lonS.substring(lonS.lastIndexOf(58) + 1);
    }

    public void printDEGDEC(PrintStream ps) {
        if (this._printLonFirst) {
            ps.print(this.getLonInDecDeg() + this._sep + this.getLatInDecDeg());
        } else {
            ps.print(this.getLatInDecDeg() + this._sep + this.getLonInDecDeg());
        }
    }

    public void printDEGMIN(PrintStream ps) {
        String lats = this.degtodm(Math.abs(this._lat));
        String lons = this.degtodm(Math.abs(this._lon));
        if (this._printLonFirst) {
            ps.print(lons + "(" + (this._lon < 0.0 ? "W" : "E") + ")" + this._sep + lats + "(" + (this._lat < 0.0 ? "S" : "N") + ")");
        } else {
            ps.print(lats + "(" + (this._lat < 0.0 ? "S" : "N") + ")" + this._sep + lons + "(" + (this._lon < 0.0 ? "W" : "E") + ")");
        }
    }

    public String getPrintSeparator() {
        return this._sep;
    }

    public void setPrintSeparator(String sep) {
        this._sep = sep;
    }

    public boolean getPrintLonFirst() {
        return this._printLonFirst;
    }

    public void setPrintLonFirst(boolean f) {
        this._printLonFirst = f;
    }

    public void move(double distft, double direction, int model) throws Exception {
        double distNM = distft / 6076.115485564304;
        double dirRAD = direction * Math.PI / 180.0;
        Ellipsoid ellipse = ells[model];
        if (ellipse.name.equals("Sphere")) {
            this.direct(this.getLatInRad(), -this.getLonInRad(), dirRAD, distNM /= 3437.7467707849396);
        } else {
            this.direct_ell(this.getLatInRad(), this.getLonInRad(), dirRAD, distNM, ellipse);
        }
    }

    public String toString() {
        try {
            boolean bLatFirst = this.getPrintLonFirst();
            String sep = this.getPrintSeparator();
            this.setPrintLonFirst(false);
            this.setPrintSeparator(",");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.printDEGMIN(new PrintStream(baos));
            baos.close();
            this.setPrintLonFirst(bLatFirst);
            this.setPrintSeparator(sep);
            return baos.toString();
        }
        catch (Throwable t) {
            return t.toString();
        }
    }

    public static GISCoordinate FromString(String s) throws Exception {
        String lat = s.substring(0, s.indexOf(40));
        String latDir = Character.toString(s.charAt(s.indexOf(40) + 1));
        String lon = s.substring(s.indexOf(",") + 1, s.lastIndexOf(40));
        String lonDir = Character.toString(s.charAt(s.lastIndexOf("(") + 1));
        GISCoordinate g = new GISCoordinate(lat, latDir, lon, lonDir);
        return g;
    }

    public GISCoordinate makeClone() throws Exception {
        return new GISCoordinate(this._lat, this._lon, false);
    }

    private void verify() {
        if (Math.abs(this._lat) > 90.0) {
            this._lat = 0.0;
            System.err.println("invalid latitude: " + this._lat + " setting as 0.");
        }
        if (Math.abs(this._lon) > 180.0) {
            this._lon = 0.0;
            System.err.println("invalid longitude: " + this._lon + " setting as 0.");
        }
    }

    private void direct(double latRad, double lonRad, double dirRad, double distNM) throws Exception {
        double lon;
        double EPS = 5.0E-11;
        if (Math.abs(Math.cos(latRad)) < EPS && !(Math.abs(Math.sin(dirRad)) < EPS)) {
            throw new Exception("Only N-S courses are meaningful, starting at a pole!");
        }
        double lat = Math.asin(Math.sin(latRad) * Math.cos(distNM) + Math.cos(latRad) * Math.sin(distNM) * Math.cos(dirRad));
        if (Math.abs(Math.cos(lat)) < EPS) {
            lon = 0.0;
        } else {
            double dlon = Math.atan2(Math.sin(dirRad) * Math.sin(distNM) * Math.cos(latRad), Math.cos(distNM) - Math.sin(latRad) * Math.sin(lat));
            lon = this.mod(lonRad - dlon + Math.PI, Math.PI * 2) - Math.PI;
        }
        this._lat = lat * 57.29577951308232;
        this._lon = lon * 57.29577951308232;
    }

    private void direct_ell(double glat1, double glon1, double faz, double s, Ellipsoid ellipse) throws Exception {
        double EPS = 5.0E-11;
        double r = 0.0;
        double tu = 0.0;
        double sf = 0.0;
        double cf = 0.0;
        double b = 0.0;
        double cu = 0.0;
        double su = 0.0;
        double sa = 0.0;
        double c2a = 0.0;
        double x = 0.0;
        double c = 0.0;
        double d = 0.0;
        double y = 0.0;
        double sy = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double e = 0.0;
        double a = 0.0;
        if (Math.abs(Math.cos(glat1)) < EPS && !(Math.abs(Math.sin(faz)) < EPS)) {
            throw new Exception("Only N-S courses are meaningful, starting at a pole!");
        }
        a = ellipse.a;
        double f = 1.0 / ellipse.invf;
        r = 1.0 - f;
        tu = r * Math.tan(glat1);
        sf = Math.sin(faz);
        cf = Math.cos(faz);
        b = cf == 0.0 ? 0.0 : 2.0 * Math.atan2(tu, cf);
        cu = 1.0 / Math.sqrt(1.0 + tu * tu);
        su = tu * cu;
        sa = cu * sf;
        c2a = 1.0 - sa * sa;
        x = 1.0 + Math.sqrt(1.0 + c2a * (1.0 / (r * r) - 1.0));
        x = (x - 2.0) / x;
        c = 1.0 - x;
        c = (x * x / 4.0 + 1.0) / c;
        d = (0.375 * x * x - 1.0) * x;
        y = tu = s / (r * a * c);
        c = y + 1.0;
        while (Math.abs(y - c) > EPS) {
            sy = Math.sin(y);
            cy = Math.cos(y);
            cz = Math.cos(b + y);
            e = 2.0 * cz * cz - 1.0;
            c = y;
            x = e * cy;
            y = e + e - 1.0;
            y = (((sy * sy * 4.0 - 3.0) * y * cz * d / 6.0 + x) * d / 4.0 - cz) * sy * d + tu;
        }
        b = cu * cy * cf - su * sy;
        c = r * Math.sqrt(sa * sa + b * b);
        d = su * cy + cu * sy * cf;
        double glat2 = this.modlat(Math.atan2(d, c));
        c = cu * cy - su * sy * cf;
        x = Math.atan2(sy * sf, c);
        c = ((-3.0 * c2a + 4.0) * f + 4.0) * c2a * f / 16.0;
        d = ((e * cy * c + cz) * sy * c + y) * sa;
        double glon2 = this.modlon(glon1 + x - (1.0 - c) * d * f);
        double baz = this.modcrs(Math.atan2(sa, b) + Math.PI);
        this._lat = glat2 * 57.29577951308232;
        this._lon = glon2 * 57.29577951308232;
    }

    private double mod(double x, double y) {
        return x - y * Math.floor(x / y);
    }

    private double modlat(double x) {
        return this.mod(x + 1.5707963267948966, Math.PI * 2) - 1.5707963267948966;
    }

    private double modlon(double x) {
        return this.mod(x + Math.PI, Math.PI * 2) - Math.PI;
    }

    private double modcrs(double x) {
        return this.mod(x, Math.PI * 2);
    }

    private double parselatlon(String str) throws Exception {
        double ret = 0.0;
        StringTokenizer tok = new StringTokenizer(str, ":");
        if (tok.hasMoreTokens()) {
            try {
                ret += (double)Integer.parseInt(tok.nextToken());
            }
            catch (NumberFormatException e) {
                throw new Exception("Degrees must be an integer");
            }
            if (tok.hasMoreTokens()) {
                int min = 0;
                try {
                    min = Integer.parseInt(tok.nextToken());
                }
                catch (NumberFormatException e) {
                    throw new Exception("minutes must be an integer");
                }
                if (min >= 60) {
                    throw new Exception("minutes must be less than 60");
                }
                ret += (double)min / 60.0;
                if (tok.hasMoreTokens()) {
                    double sec = 0.0;
                    try {
                        sec = Double.parseDouble(tok.nextToken());
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("minutes must be in decimal or integer format");
                    }
                    if (sec >= 60.0) {
                        throw new Exception("seconds must be less than 60");
                    }
                    ret += sec / 3600.0;
                }
            }
        } else {
            throw new Exception(str + " is not a valid coordinate format");
        }
        return ret;
    }

    private String degtodm(double degdec) {
        int deg = (int)Math.floor(degdec);
        int min = (int)Math.floor(60.0 * (degdec - (double)deg));
        double sec = (60.0 * (degdec - (double)deg) - (double)min) * 60.0;
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(5);
        return Integer.toString(deg) + ":" + Integer.toString(min) + ":" + nf.format(sec);
    }

    public static void main(String[] args) {
        try {
            GISCoordinate g = new GISCoordinate("37:55:15", "N", "122:20:59", "W");
            System.out.print("Original location in decimal degrees:");
            g.printDEGDEC(System.out);
            System.out.println();
            System.out.print("Original location in degrees:");
            g.printDEGMIN(System.out);
            System.out.println();
            double movedist = 2640.0;
            double movedeg = 167.0;
            NeptusLog.pub().info((Object)("<###>Moving " + movedist + " Feet, in a direction of " + movedeg + " degrees..."));
            g.move(movedist, movedeg, 1);
            System.out.print("New location in decimal degrees:");
            g.printDEGDEC(System.out);
            System.out.println();
            System.out.print("New location in degrees:");
            g.printDEGMIN(System.out);
            NeptusLog.pub().info((Object)("<###>\ntesting the toString function:" + GISCoordinate.FromString(g.toString()).toString()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        GISCoordinate.ells[0] = new Ellipsoid("Spherical (1'=1nm)", "Sphere", 3437.7467707849396, Double.POSITIVE_INFINITY);
        GISCoordinate.ells[1] = new Ellipsoid("WGS84/NAD83/GRS80", "WGS84", 3443.918466522678, 298.257223563);
        GISCoordinate.ells[2] = new Ellipsoid("Clarke (1866)/NAD27", "NAD27", 3443.955939524838, 294.9786982138);
        GISCoordinate.ells[3] = new Ellipsoid("International", "International", 3444.0539956803455, 297.0);
        GISCoordinate.ells[4] = new Ellipsoid("Krasovsky", "Krasovsky", 3443.976781857451, 298.3);
        GISCoordinate.ells[5] = new Ellipsoid("Bessel (1841)", "Bessel", 3443.518982181425, 299.1528);
        GISCoordinate.ells[6] = new Ellipsoid("WGS72", "WGS72", 3443.9173866090714, 298.26);
        GISCoordinate.ells[7] = new Ellipsoid("WGS66", "WGS66", 3443.922786177106, 298.25);
        GISCoordinate.ells[8] = new Ellipsoid("FAI sphere", "FAI sphere", 3440.0647948164146, 1.0E9);
        GISCoordinate.ells[9] = new Ellipsoid("User Defined", "User", 0.0, 0.0);
    }

    public static class Ellipsoid {
        public String dispName;
        public String name;
        public double a;
        public double invf;

        public Ellipsoid(String dispName, String name, double a, double invf) {
            this.dispName = dispName;
            this.name = name;
            this.a = a;
            this.invf = invf;
        }
    }
}

