/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.coord.MapTileUtil;

public class LocationType
implements XmlOutputMethods,
Serializable,
Comparable<LocationType>,
Cloneable {
    private static final long serialVersionUID = -5672043713440034944L;
    protected static final String DEFAULT_ROOT_ELEMENT = "coordinate";
    public static final LocationType ABSOLUTE_ZERO = new LocationType();
    public static final LocationType FEUP = new LocationType(41.17785, -8.59796);
    public static double ONE_LAT_DEGREE = 0.0;
    private static NumberFormat nf6;
    private static NumberFormat nf2;
    protected String id;
    protected String name;
    protected double latitudeRads;
    protected double longitudeRads;
    private double depth;
    protected double offsetDistance;
    protected double azimuth;
    protected double zenith;
    private boolean isOffsetNorthUsed;
    private double offsetNorth;
    private boolean isOffsetEastUsed;
    private double offsetEast;
    private boolean isOffsetUpUsed;
    private double offsetDown;

    public LocationType() {
        this.name = this.id = NameNormalizer.getRandomID();
        this.latitudeRads = 0.0;
        this.longitudeRads = 0.0;
        this.depth = 0.0;
        this.offsetDistance = 0.0;
        this.azimuth = 0.0;
        this.zenith = 90.0;
        this.isOffsetNorthUsed = true;
        this.offsetNorth = 0.0;
        this.isOffsetEastUsed = true;
        this.offsetEast = 0.0;
        this.isOffsetUpUsed = true;
        this.offsetDown = 0.0;
    }

    public LocationType(String xml) {
        this.name = this.id = NameNormalizer.getRandomID();
        this.latitudeRads = 0.0;
        this.longitudeRads = 0.0;
        this.depth = 0.0;
        this.offsetDistance = 0.0;
        this.azimuth = 0.0;
        this.zenith = 90.0;
        this.isOffsetNorthUsed = true;
        this.offsetNorth = 0.0;
        this.isOffsetEastUsed = true;
        this.offsetEast = 0.0;
        this.isOffsetUpUsed = true;
        this.offsetDown = 0.0;
        this.load(xml);
    }

    public LocationType(LocationType anotherLocation) {
        this.name = this.id = NameNormalizer.getRandomID();
        this.latitudeRads = 0.0;
        this.longitudeRads = 0.0;
        this.depth = 0.0;
        this.offsetDistance = 0.0;
        this.azimuth = 0.0;
        this.zenith = 90.0;
        this.isOffsetNorthUsed = true;
        this.offsetNorth = 0.0;
        this.isOffsetEastUsed = true;
        this.offsetEast = 0.0;
        this.isOffsetUpUsed = true;
        this.offsetDown = 0.0;
        this.setLocation(anotherLocation);
    }

    public LocationType(double latitudeDegrees, double longitudeDegrees) {
        this.name = this.id = NameNormalizer.getRandomID();
        this.latitudeRads = 0.0;
        this.longitudeRads = 0.0;
        this.depth = 0.0;
        this.offsetDistance = 0.0;
        this.azimuth = 0.0;
        this.zenith = 90.0;
        this.isOffsetNorthUsed = true;
        this.offsetNorth = 0.0;
        this.isOffsetEastUsed = true;
        this.offsetEast = 0.0;
        this.isOffsetUpUsed = true;
        this.offsetDown = 0.0;
        this.latitudeRads = Math.toRadians(latitudeDegrees);
        this.longitudeRads = Math.toRadians(longitudeDegrees);
    }

    public boolean load(Element elem) {
        Document doc = Dom4JUtil.elementToDocument(elem);
        if (doc == null) {
            return false;
        }
        return this.load(doc);
    }

    public boolean load(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            return this.load(doc);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
    }

    public boolean load(Document doc) {
        Node node = doc.selectSingleNode("//id");
        if (node != null) {
            this.setId(node.getText());
        }
        if ((node = doc.selectSingleNode("//name")) != null) {
            this.setName(node.getText());
        }
        this.setLatitudeStr(doc.selectSingleNode("//latitude").getText());
        this.setLongitudeStr(doc.selectSingleNode("//longitude").getText());
        Node nd = doc.selectSingleNode("//height");
        if (nd != null) {
            this.setHeight(Double.parseDouble(nd.getText()));
        } else {
            nd = doc.selectSingleNode("//depth");
            if (nd != null) {
                this.setDepth(Double.parseDouble(nd.getText()));
            }
        }
        nd = doc.selectSingleNode("//azimuth");
        if (nd != null) {
            this.setAzimuth(Double.parseDouble(nd.getText()));
        }
        if ((nd = doc.selectSingleNode("//offset-distance")) != null) {
            this.setOffsetDistance(Double.parseDouble(nd.getText()));
        }
        if ((nd = doc.selectSingleNode("//zenith")) != null) {
            this.setZenith(Double.parseDouble(nd.getText()));
        }
        if ((nd = doc.selectSingleNode("//offset-north")) != null) {
            this.setOffsetNorth(Double.parseDouble(nd.getText()), true);
        } else {
            nd = doc.selectSingleNode("//offset-south");
            if (nd != null) {
                this.setOffsetSouth(Double.parseDouble(nd.getText()), true);
            }
        }
        nd = doc.selectSingleNode("//offset-east");
        if (nd != null) {
            this.setOffsetEast(Double.parseDouble(nd.getText()), true);
        } else {
            nd = doc.selectSingleNode("//offset-west");
            if (nd != null) {
                this.setOffsetWest(Double.parseDouble(nd.getText()), true);
            }
        }
        nd = doc.selectSingleNode("//offset-up");
        if (nd != null) {
            this.setOffsetUp(Double.parseDouble(nd.getText()), true);
        } else {
            nd = doc.selectSingleNode("//offset-down");
            if (nd != null) {
                this.setOffsetDown(Double.parseDouble(nd.getText()), true);
            }
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLatitudeStr() {
        return CoordinateUtil.dmsToLatString(CoordinateUtil.decimalDegreesToDMS(Math.toDegrees(this.latitudeRads)));
    }

    public double getLatitudeDegs() {
        return Math.toDegrees(this.latitudeRads);
    }

    public double getLatitudeRads() {
        return this.latitudeRads;
    }

    public void setLatitudeStr(String latitude) {
        if (latitude != null) {
            this.setLatitudeDegs(CoordinateUtil.parseLatitudeCoordToDoubleValue(latitude));
        }
    }

    public void setLatitudeDegs(double latitude) {
        this.setLatitudeRads(Math.toRadians(latitude));
    }

    public void setLatitudeRads(double latitudeRads) {
        this.latitudeRads = latitudeRads;
    }

    public String getLongitudeStr() {
        return CoordinateUtil.dmsToLonString(CoordinateUtil.decimalDegreesToDMS(this.getLongitudeDegs()));
    }

    public double getLongitudeDegs() {
        return Math.toDegrees(this.longitudeRads);
    }

    public double getLongitudeRads() {
        return this.longitudeRads;
    }

    public void setLongitudeStr(String longitude) {
        if (longitude != null) {
            this.setLongitudeDegs(CoordinateUtil.parseLongitudeCoordToDoubleValue(longitude));
        }
    }

    public void setLongitudeDegs(double longitude) {
        this.setLongitudeRads(Math.toRadians(longitude));
    }

    public void setLongitudeRads(double longitudeRads) {
        this.longitudeRads = longitudeRads;
    }

    public double getDepth() {
        if (this.depth == 0.0) {
            return 0.0;
        }
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getHeight() {
        return -this.getDepth();
    }

    public void setHeight(double height) {
        this.depth = -height;
    }

    public double getOffsetDistance() {
        return this.offsetDistance;
    }

    public void setOffsetDistance(double offsetDistance) {
        this.offsetDistance = offsetDistance;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public double getZenith() {
        return this.zenith;
    }

    public void setZenith(double zenith) {
        this.zenith = zenith;
    }

    public double getOffsetNorth() {
        return this.offsetNorth;
    }

    public void setOffsetNorth(double offsetNorth) {
        this.offsetNorth = offsetNorth;
    }

    public void setOffsetNorth(double offsetNorth, boolean useOffsetNorthInXMLOutput) {
        this.setOffsetNorth(offsetNorth);
        this.setOffsetNorthUsed(useOffsetNorthInXMLOutput);
    }

    public double getOffsetSouth() {
        if (this.offsetNorth == 0.0) {
            return this.offsetNorth;
        }
        return -this.offsetNorth;
    }

    public void setOffsetSouth(double offsetSouth) {
        this.offsetNorth = -offsetSouth;
        if (this.offsetNorth == 0.0) {
            this.offsetNorth = 0.0;
        }
    }

    public void setOffsetSouth(double offsetSouth, boolean useOffsetSouthInXMLOutput) {
        this.setOffsetSouth(offsetSouth);
        this.setOffsetNorthUsed(!useOffsetSouthInXMLOutput);
    }

    public double getOffsetEast() {
        return this.offsetEast;
    }

    public void setOffsetEast(double offsetEast) {
        this.offsetEast = offsetEast;
    }

    public void setOffsetEast(double offsetEast, boolean useOffsetEastInXMLOutput) {
        this.setOffsetEast(offsetEast);
        this.setOffsetEastUsed(useOffsetEastInXMLOutput);
    }

    public double getOffsetWest() {
        if (this.offsetEast == 0.0) {
            return this.offsetEast;
        }
        return -this.offsetEast;
    }

    public void setOffsetWest(double offsetWest) {
        this.offsetEast = -offsetWest;
        if (this.offsetEast == 0.0) {
            this.offsetEast = 0.0;
        }
    }

    public void setOffsetWest(double offsetWest, boolean useOffsetWestInXMLOutput) {
        this.setOffsetWest(offsetWest);
        this.setOffsetEastUsed(!useOffsetWestInXMLOutput);
    }

    public double getOffsetUp() {
        if (this.offsetDown == 0.0) {
            return this.offsetDown;
        }
        return -this.offsetDown;
    }

    public void setOffsetUp(double offsetUp) {
        this.offsetDown = -offsetUp;
        if (this.offsetDown == 0.0) {
            this.offsetDown = 0.0;
        }
    }

    public void setOffsetUp(double offsetUp, boolean useOffsetUpInXMLOutput) {
        this.setOffsetUp(offsetUp);
        this.setOffsetUpUsed(useOffsetUpInXMLOutput);
    }

    public double getOffsetDown() {
        return this.offsetDown;
    }

    public void setOffsetDown(double offsetDown) {
        this.offsetDown = offsetDown;
    }

    public void setOffsetDown(double offsetDown, boolean useOffsetDownInXMLOutput) {
        this.setOffsetDown(offsetDown);
        this.setOffsetUpUsed(!useOffsetDownInXMLOutput);
    }

    public boolean isOffsetEastUsed() {
        return this.isOffsetEastUsed;
    }

    public void setOffsetEastUsed(boolean isOffsetEastUsed) {
        this.isOffsetEastUsed = isOffsetEastUsed;
    }

    public boolean isOffsetNorthUsed() {
        return this.isOffsetNorthUsed;
    }

    public void setOffsetNorthUsed(boolean isOffsetNorthUsed) {
        this.isOffsetNorthUsed = isOffsetNorthUsed;
    }

    public boolean isOffsetUpUsed() {
        return this.isOffsetUpUsed;
    }

    public void setOffsetUpUsed(boolean isOffsetUpUsed) {
        this.isOffsetUpUsed = isOffsetUpUsed;
    }

    public String toString() {
        double[] absLoc = this.getAbsoluteLatLonDepth();
        double lat = absLoc[0];
        double lon = absLoc[1];
        String latStr = "N";
        String lonStr = "E";
        if (lat < 0.0) {
            lat = -lat;
            latStr = "S";
        }
        if (lon < 0.0) {
            lon = -lon;
            lonStr = "W";
        }
        return latStr + nf6.format(lat) + '\u00b0' + ", " + lonStr + nf6.format(lon) + '\u00b0' + (this.getHeight() != 0.0 ? ", " + nf2.format(this.getHeight()) : "");
    }

    public static LocationType valueOf(String value) {
        String[] parts = value.split("[ ,]+");
        LocationType loc = new LocationType();
        loc.setLatitudeStr(parts[0]);
        loc.setLongitudeStr(parts[1]);
        loc.setHeight(parts.length < 3 ? 0.0 : Double.parseDouble(parts[2]));
        return loc;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("id").addText(this.getId());
        root.addElement("name").addText(this.getName());
        Element coordinate = root.addElement(DEFAULT_ROOT_ELEMENT);
        if (this.getLatitudeStr() != null) {
            coordinate.addElement("latitude").addText(this.getLatitudeStr());
        }
        if (this.getLongitudeStr() != null) {
            coordinate.addElement("longitude").addText(this.getLongitudeStr());
        }
        coordinate.addElement("height").addText(String.valueOf(MathMiscUtils.round(this.getHeight(), 3)));
        if (this.getOffsetDistance() != 0.0) {
            coordinate.addElement("azimuth").addText(String.valueOf(MathMiscUtils.round(this.getAzimuth(), 3)));
            coordinate.addElement("offset-distance").addText(String.valueOf(MathMiscUtils.round(this.getOffsetDistance(), 3)));
            coordinate.addElement("zenith").addText(String.valueOf(MathMiscUtils.round(this.getZenith(), 3)));
        }
        if (!(this.getOffsetNorth() == 0.0 & this.getOffsetEast() == 0.0 & this.getOffsetUp() == 0.0)) {
            if (this.isOffsetNorthUsed) {
                coordinate.addElement("offset-north").addText(String.valueOf(MathMiscUtils.round(this.getOffsetNorth(), 3)));
            } else {
                coordinate.addElement("offset-south").addText(String.valueOf(MathMiscUtils.round(this.getOffsetSouth(), 3)));
            }
            if (this.isOffsetEastUsed) {
                coordinate.addElement("offset-east").addText(String.valueOf(MathMiscUtils.round(this.getOffsetEast(), 3)));
            } else {
                coordinate.addElement("offset-west").addText(String.valueOf(MathMiscUtils.round(this.getOffsetWest(), 3)));
            }
            if (this.isOffsetUpUsed) {
                coordinate.addElement("offset-up").addText(String.valueOf(MathMiscUtils.round(this.getOffsetUp(), 3)));
            } else {
                coordinate.addElement("offset-down").addText(String.valueOf(MathMiscUtils.round(this.getOffsetDown(), 3)));
            }
        }
        return document;
    }

    public double[] getOffsetFrom(LocationType otherLocation) {
        return CoordinateUtil.WGS84displacement(otherLocation, this);
    }

    public double getDistanceInMeters(LocationType anotherLocation) {
        double[] offsets = this.getOffsetFrom(anotherLocation);
        double sum = offsets[0] * offsets[0] + offsets[1] * offsets[1] + offsets[2] * offsets[2];
        return Math.sqrt(sum);
    }

    public double getHorizontalDistanceInMeters(LocationType anotherLocation) {
        double[] offsets = this.getOffsetFrom(anotherLocation);
        double sum = offsets[0] * offsets[0] + offsets[1] * offsets[1];
        return Math.sqrt(sum);
    }

    public double getXYAngle(LocationType anotherLocation) {
        double[] o2 = anotherLocation.getOffsetFrom(this);
        double ang = AngleCalc.calcAngle(0.0, 0.0, o2[1], o2[0]);
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public void setLocation(LocationType anotherPoint) {
        if (anotherPoint == null) {
            return;
        }
        this.setLatitudeRads(anotherPoint.getLatitudeRads());
        this.setLongitudeRads(anotherPoint.getLongitudeRads());
        this.setDepth(anotherPoint.getDepth());
        this.setAzimuth(anotherPoint.getAzimuth());
        this.setZenith(anotherPoint.getZenith());
        this.setOffsetDistance(anotherPoint.getOffsetDistance());
        this.setOffsetDown(anotherPoint.getOffsetDown());
        this.setOffsetEast(anotherPoint.getOffsetEast());
        this.setOffsetNorth(anotherPoint.getOffsetNorth());
        this.setOffsetEastUsed(anotherPoint.isOffsetEastUsed());
        this.setOffsetNorthUsed(anotherPoint.isOffsetNorthUsed());
        this.setOffsetUpUsed(anotherPoint.isOffsetUpUsed());
    }

    public LocationType translatePosition(double offsetNorth, double offsetEast, double offsetDown) {
        this.setOffsetNorth(this.getOffsetNorth() + offsetNorth);
        this.setOffsetEast(this.getOffsetEast() + offsetEast);
        this.setOffsetDown(this.getOffsetDown() + offsetDown);
        return this;
    }

    public LocationType translatePosition(double[] nedOffsets) {
        if (nedOffsets.length < 3) {
            NeptusLog.pub().error((Object)("Invalid offsets length: found " + nedOffsets.length + " values, expecting 3"));
            return this;
        }
        return this.translatePosition(nedOffsets[0], nedOffsets[1], nedOffsets[2]);
    }

    public double[] getAbsoluteLatLonDepth() {
        double[] totalLatLonDepth = new double[]{0.0, 0.0, 0.0};
        totalLatLonDepth[0] = this.getLatitudeDegs();
        totalLatLonDepth[1] = this.getLongitudeDegs();
        totalLatLonDepth[2] = this.getDepth();
        double[] tmpDouble = CoordinateUtil.sphericalToCartesianCoordinates(this.getOffsetDistance(), this.getAzimuth(), this.getZenith());
        double north = this.getOffsetNorth() + tmpDouble[0];
        double east = this.getOffsetEast() + tmpDouble[1];
        double down = this.getOffsetDown() + tmpDouble[2];
        if (north != 0.0 || east != 0.0 || down != 0.0) {
            return CoordinateUtil.WGS84displace(totalLatLonDepth[0], totalLatLonDepth[1], totalLatLonDepth[2], north, east, down);
        }
        return totalLatLonDepth;
    }

    public String getLatitudeAsPrettyString() {
        return CoordinateUtil.latitudeAsPrettyString(this.getLatitudeDegs(), true);
    }

    public String getLongitudeAsPrettyString() {
        return CoordinateUtil.longitudeAsPrettyString(this.getLongitudeDegs(), true);
    }

    public LocationType convertToAbsoluteLatLonDepth() {
        if (this.offsetNorth == 0.0 && this.offsetEast == 0.0 && this.offsetDown == 0.0 && this.offsetDistance == 0.0) {
            return this;
        }
        double[] latlondepth = this.getAbsoluteLatLonDepth();
        this.setLocation(new LocationType());
        this.setLatitudeDegs(latlondepth[0]);
        this.setLongitudeDegs(latlondepth[1]);
        this.setDepth(latlondepth[2]);
        return this;
    }

    public <L extends LocationType> L getNewAbsoluteLatLonDepth() {
        LocationType loc;
        double[] latlondepth = this.getAbsoluteLatLonDepth();
        try {
            loc = (LocationType)this.getClass().newInstance();
        }
        catch (Exception e) {
            loc = new LocationType();
        }
        loc.setLatitudeDegs(latlondepth[0]);
        loc.setLongitudeDegs(latlondepth[1]);
        loc.setDepth(latlondepth[2]);
        return (L)loc;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.getNewAbsoluteLatLonDepth();
    }

    public double[] getAbsoluteNEDInMeters() {
        double[] absoluteLatLonDepth = this.getAbsoluteLatLonDepth();
        if (absoluteLatLonDepth == null) {
            return null;
        }
        double[] tmpDouble = CoordinateUtil.latLonDiff(0.0, 0.0, absoluteLatLonDepth[0], absoluteLatLonDepth[1]);
        double[] result = new double[]{tmpDouble[0], tmpDouble[1], absoluteLatLonDepth[2]};
        return result;
    }

    public String getClipboardText() {
        return "[NeptusLocation] id=" + this.getId() + "\n" + this.getLatitudeStr() + " " + this.getLongitudeStr() + " " + this.getDepth() + "\n" + this.getOffsetNorth() + " " + this.getOffsetEast() + " " + this.getOffsetDown() + "\n" + this.getOffsetDistance() + " " + this.getAzimuth() + " " + this.getZenith() + "\n";
    }

    public boolean fromClipboardText(String text) {
        StringTokenizer st = new StringTokenizer(text);
        if (st.countTokens() < 11) {
            NeptusLog.pub().error((Object)("Invalid location found in the clipboard (" + st.countTokens() + " tokens)"));
            return false;
        }
        String val = st.nextToken();
        if (!val.equals("[NeptusLocation]")) {
            NeptusLog.pub().error((Object)("Invalid location found in the clipboard (first word: '" + val + "')"));
            return false;
        }
        try {
            st.nextToken();
            this.setLatitudeStr(st.nextToken());
            this.setLongitudeStr(st.nextToken());
            this.setDepth(Double.parseDouble(st.nextToken()));
            this.setOffsetNorth(Double.parseDouble(st.nextToken()));
            this.setOffsetEast(Double.parseDouble(st.nextToken()));
            this.setOffsetDown(Double.parseDouble(st.nextToken()));
            this.setOffsetDistance(Double.parseDouble(st.nextToken()));
            this.setAzimuth(Double.parseDouble(st.nextToken()));
            this.setZenith(Double.parseDouble(st.nextToken()));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
        return true;
    }

    public Element asGPXWaypointElement(String wptName) {
        Element wpt = DocumentHelper.createElement((String)"wpt");
        double[] absCoords = this.getAbsoluteLatLonDepth();
        wpt.addAttribute("lat", String.valueOf(absCoords[0]));
        wpt.addAttribute("lon", String.valueOf(absCoords[1]));
        wpt.addElement("ele").setText(String.valueOf(-absCoords[2]));
        wpt.addElement("name").setText(wptName);
        wpt.addElement("cmt").setText("Computer generated waypoint");
        wpt.addElement("desc").setText(wptName);
        wpt.addElement("sym").setText("City (Medium)");
        return wpt;
    }

    public Element asGPXWaypointElement(String wptName, String symbol, String desc) {
        Element wpt = DocumentHelper.createElement((String)"wpt");
        double[] absCoords = this.getAbsoluteLatLonDepth();
        wpt.addAttribute("lat", String.valueOf(absCoords[0]));
        wpt.addAttribute("lon", String.valueOf(absCoords[1]));
        wpt.addElement("ele").setText(String.valueOf(-absCoords[2]));
        wpt.addElement("name").setText(wptName);
        wpt.addElement("cmt").setText("Computer generated waypoint");
        wpt.addElement("desc").setText(desc);
        wpt.addElement("sym").setText(symbol);
        return wpt;
    }

    public Element asGPXRoutePoint() {
        Element trkpt = DocumentHelper.createElement((String)"rtept");
        double[] absCoords = this.getAbsoluteLatLonDepth();
        trkpt.addAttribute("lat", String.valueOf(absCoords[0]));
        trkpt.addAttribute("lon", String.valueOf(absCoords[1]));
        trkpt.addElement("ele").setText(String.valueOf(-absCoords[2]));
        trkpt.addElement("name").setText(this.getId());
        trkpt.addElement("desc").setText("Route Waypoint");
        return trkpt;
    }

    public double getAllZ() {
        double[] stc = CoordinateUtil.sphericalToCartesianCoordinates(this.getOffsetDistance(), this.getAzimuth(), this.getZenith());
        stc[2] = stc[2] + this.getOffsetDown();
        stc[2] = stc[2] + this.getDepth();
        return stc[2];
    }

    protected void makeTotalDepthZero() {
        this.setDepth(0.0);
        this.setOffsetDown(0.0);
        this.setOffsetDistance(0.0);
        this.setAzimuth(0.0);
        this.setZenith(90.0);
    }

    public void setAbsoluteDepth(double z) {
        this.makeTotalDepthZero();
        this.setDepth(z);
    }

    public double getXYDistanceToLine(LocationType pt1, LocationType pt2) {
        double[] p0 = this.getAbsoluteLatLonDepth();
        double[] p1 = pt1.getAbsoluteLatLonDepth();
        double[] p2 = pt2.getAbsoluteLatLonDepth();
        Line2D.Double l = new Line2D.Double(p1[0], p1[1], p2[0], p2[1]);
        return l.ptLineDist(p0[0], p0[1]);
    }

    public Point2D getPointInPixel(int levelOfDetail) {
        Object meWithOffset = this.getNewAbsoluteLatLonDepth();
        return MapTileUtil.degreesToXY(((LocationType)meWithOffset).getLatitudeDegs(), ((LocationType)meWithOffset).getLongitudeDegs(), levelOfDetail);
    }

    public double[] getDistanceInPixelTo(LocationType target, int levelOfDetail) {
        Object meWithOffset = this.getNewAbsoluteLatLonDepth();
        Object targetWithOffset = target.getNewAbsoluteLatLonDepth();
        return MapTileUtil.getOffsetInPixels(meWithOffset, targetWithOffset, levelOfDetail);
    }

    public double getPixelDistanceTo(LocationType target, int levelOfDetail) {
        double[] offsets = this.getDistanceInPixelTo(target, levelOfDetail);
        return Math.sqrt(offsets[0] * offsets[0] + offsets[1] * offsets[1]);
    }

    public void translateInPixel(double deltaX, double deltaY, int levelOfDetail) {
        Point2D pixs = this.getPointInPixel(levelOfDetail);
        double[] latlon = MapTileUtil.XYToDegrees(pixs.getX() + deltaX, pixs.getY() + deltaY, levelOfDetail);
        this.convertToAbsoluteLatLonDepth();
        this.setLatitudeDegs(latlon[0]);
        this.setLongitudeDegs(latlon[1]);
    }

    public void setLocationByPixel(double x, double y, int levelOfDetail) {
        double[] degrees = MapTileUtil.XYToDegrees(x, y, levelOfDetail);
        this.convertToAbsoluteLatLonDepth();
        this.latitudeRads = Math.toRadians(degrees[0]);
        this.longitudeRads = Math.toRadians(degrees[1]);
    }

    public boolean isLocationEqual(LocationType location) {
        if (location == null) {
            return false;
        }
        Object loc1 = this.getNewAbsoluteLatLonDepth();
        Object loc2 = location.getNewAbsoluteLatLonDepth();
        if (((LocationType)loc2).getLatitudeDegs() == 0.0) {
            return ((LocationType)loc1).getLatitudeDegs() == 0.0;
        }
        double loc1LatDouble = this.cropDecimalDigits(10, ((LocationType)loc1).getLatitudeDegs());
        double loc2LatDouble = this.cropDecimalDigits(10, ((LocationType)loc2).getLatitudeDegs());
        double loc1LonDouble = this.cropDecimalDigits(10, ((LocationType)loc1).getLongitudeDegs());
        double loc2LonDouble = this.cropDecimalDigits(10, ((LocationType)loc2).getLongitudeDegs());
        return Double.compare(loc1LatDouble, loc2LatDouble) == 0 && Double.compare(loc1LonDouble, loc2LonDouble) == 0 && ((LocationType)loc1).getDepth() == ((LocationType)loc2).getDepth();
    }

    private double cropDecimalDigits(int digit, double value) {
        String string = value + "";
        String[] tokens = string.split("\\.");
        StringBuilder res = new StringBuilder(tokens[0]);
        res.append(".");
        res.append(tokens[1].substring(0, tokens[1].length() > digit ? digit : tokens[1].length()));
        return new Double(res.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationType)) {
            return false;
        }
        LocationType otherLoc = (LocationType)obj;
        return this.isLocationEqual(otherLoc);
    }

    @Override
    public int compareTo(LocationType o) {
        return (int)this.getDistanceInMeters(o);
    }

    public String getDebugString() {
        double[] abs = this.getOffsetFrom(new LocationType());
        return "LOCATION/DEBUG:\nLatitude: " + this.getLatitudeStr() + ", Longitude: " + this.getLongitudeStr() + "\n" + "Depth: " + this.getDepth() + "\n" + "OffsetUp: " + this.getOffsetUp() + ", OffsetDown: " + this.getOffsetDown() + "\n" + "OffsetNorth: " + this.getOffsetNorth() + ", OffsetSouth: " + this.getOffsetSouth() + "\n" + "OffsetEast: " + this.getOffsetEast() + ", OffsetWest: " + this.getOffsetWest() + "\n" + "OffsetDistance: " + this.getOffsetDistance() + ", Azimuth: " + this.getAzimuth() + "\n" + "Zenith: " + this.getZenith() + ", Absolut XY: (" + abs[0] + ", " + abs[1] + ")";
    }

    public static void LocationTypeTest() {
        LocationType loc = new LocationType();
        loc.setLatitudeRads(0.7188013442408926);
        loc.setLongitudeRads(0.7188013442408926);
        loc.setHeight(3.0);
        loc.setOffsetNorth(95.97593750551583);
        loc.setOffsetEast(-274.7049781636526);
        loc.setOffsetDown(1.6755575514192749);
        NeptusLog.pub().info((Object)("<###> " + loc));
        loc.convertToAbsoluteLatLonDepth();
        NeptusLog.pub().info((Object)("<###> " + loc));
        LocationType loc2 = LocationType.valueOf(loc.toString());
        NeptusLog.pub().info((Object)("<###> " + loc2));
    }

    public static void main(String[] args) {
        LocationType.LocationTypeTest();
    }

    static {
        ABSOLUTE_ZERO.setId("ABSOLUTE_ZERO");
        LocationType lt = new LocationType();
        lt.setLatitudeDegs(1.0);
        ONE_LAT_DEGREE = lt.getDistanceInMeters(ABSOLUTE_ZERO);
        nf6 = GuiUtils.getNeptusDecimalFormat(6);
        nf2 = GuiUtils.getNeptusDecimalFormat(2);
    }
}

