/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.neptus.types.coord.LocationType;

public class LocationsHolder {
    private static LinkedHashMap<String, LocationType> locationsList = new LinkedHashMap();
    private static HashMap<String, Vector<String>> refsList = new HashMap();

    public static boolean putAbstractLocationPoint(LocationType point) {
        LocationType retO = locationsList.get(point.getId());
        if (retO != null) {
            return false;
        }
        locationsList.put(point.getId(), point);
        refsList.put(point.getId(), new Vector());
        return true;
    }

    public static boolean addRefToAbstractLocationPoint(String parentId, String childId) {
        LocationType retO = locationsList.get(parentId);
        if (retO == null) {
            return false;
        }
        retO = locationsList.get(childId);
        if (retO == null) {
            return false;
        }
        Vector<String> ret1 = refsList.get(parentId);
        if (ret1 == null) {
            refsList.put(parentId, new Vector());
            ret1 = refsList.get(parentId);
        }
        Vector<String> refs = ret1;
        refs.add(childId);
        return true;
    }

    public static boolean removeRefToAbstractLocationPoint(String parentId, String childId) {
        LocationType retO = locationsList.get(parentId);
        if (retO == null) {
            return false;
        }
        retO = locationsList.get(childId);
        if (retO == null) {
            return false;
        }
        Vector<String> ret1 = refsList.get(parentId);
        if (ret1 == null) {
            return false;
        }
        Vector<String> refs = ret1;
        refs.remove(childId);
        return true;
    }

    public static LocationType getAbstractLocationPointById(String id) {
        LocationType ret = locationsList.get(id);
        if (ret == null) {
            return null;
        }
        return ret;
    }

    public static boolean updateAbstractLocationPoint(LocationType point) {
        LocationType retO = locationsList.get(point.getId());
        if (retO == null) {
            return false;
        }
        locationsList.remove(point.getId());
        locationsList.put(point.getId(), point);
        return true;
    }

    public static boolean removeAbstractLocationPoint(LocationType point) {
        return LocationsHolder.removeAbstractLocationPoint(point.getId());
    }

    public static boolean removeAbstractLocationPoint(String id) {
        LocationType retO = locationsList.get(id);
        if (retO == null) {
            return false;
        }
        Vector<String> re = refsList.get(id);
        if (re == null) {
            locationsList.remove(id);
            return true;
        }
        Vector<String> refs = re;
        if (refs.size() == 0) {
            locationsList.remove(id);
            refsList.remove(id);
            return true;
        }
        return false;
    }

    public static String generateReport() {
        String report = "Abstract locations:\n";
        Iterator<String> it = locationsList.keySet().iterator();
        while (it.hasNext()) {
            LocationType point = locationsList.get(it.next());
            report = report + point.getName() + " (" + point.getId() + ")\n";
        }
        report = report + "\n\n";
        report = report + "References list:\n";
        for (String id : refsList.keySet()) {
            Vector<String> refs = refsList.get(id);
            report = report + "Id: " + id + "\n";
            for (String ref : refs) {
                report = report + "   " + ref + "\n";
            }
            report = report + "\n";
        }
        return report;
    }
}

