/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.coord;

import pt.lsts.neptus.NeptusLog;

public class UTMCoordinates {
    private final double wgs84Radius = 6378137.0;
    private final double wgs84EccSquared = 0.00669438;
    private double easting = 0.0;
    private double northing = 0.0;
    private double latitudeDegrees = 0.0;
    private double longitudeDegrees = 0.0;
    private int zoneNumber = 0;
    private char zoneLetter = (char)78;

    public UTMCoordinates(double easting, double northing, int zoneNumber, char zoneLetter) {
        this.northing = northing;
        this.easting = easting;
        this.zoneNumber = zoneNumber;
        this.zoneLetter = zoneLetter;
        this.UTMtoLL();
    }

    public UTMCoordinates(double latitudeDegrees, double longitudeDegrees) {
        this.latitudeDegrees = latitudeDegrees;
        this.longitudeDegrees = longitudeDegrees;
        this.LLtoUTM();
    }

    public void UTMtoLL() {
        if (this.zoneNumber < 0 || this.zoneNumber > 60) {
            return;
        }
        double k0 = 0.9996;
        double a = 6378137.0;
        double eccSquared = 0.00669438;
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        double x = this.easting - 500000.0;
        double y = this.northing;
        if (this.zoneLetter == 'S') {
            y -= 1.0E7;
        }
        double longOrigin = (this.zoneNumber - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double M = y / k0;
        double mu = M / (a * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double N1 = a / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = a * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        double lat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        this.latitudeDegrees = Math.toDegrees(lat);
        double lng = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        this.longitudeDegrees = longOrigin + Math.toDegrees(lng);
    }

    private void LLtoUTM() {
        double lat = this.latitudeDegrees;
        double lng = this.longitudeDegrees;
        lng = lng + 180.0 - (double)((int)((lng + 180.0) / 360.0) * 360) - 180.0;
        double a = 6378137.0;
        double eccSquared = 0.00669438;
        double k0 = 0.9996;
        double latRad = Math.toRadians(lat);
        double longRad = Math.toRadians(lng);
        int zoneNumberTmp = (int)((lng + 180.0) / 6.0) + 1;
        if (lng == 180.0) {
            zoneNumberTmp = 60;
        }
        if (lat >= 56.0 && lat < 64.0 && lng >= 3.0 && lng < 12.0) {
            zoneNumberTmp = 32;
        }
        if (lat >= 72.0 && lat < 84.0) {
            if (lng >= 0.0 && lng < 9.0) {
                zoneNumberTmp = 31;
            } else if (lng >= 9.0 && lng < 21.0) {
                zoneNumberTmp = 33;
            } else if (lng >= 21.0 && lng < 33.0) {
                zoneNumberTmp = 35;
            } else if (lng >= 33.0 && lng < 42.0) {
                zoneNumberTmp = 37;
            }
        }
        double longOrigin = (zoneNumberTmp - 1) * 6 - 180 + 3;
        double longOriginRad = Math.toRadians(longOrigin);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double N = a / Math.sqrt(1.0 - eccSquared * Math.sin(latRad) * Math.sin(latRad));
        double T = Math.tan(latRad) * Math.tan(latRad);
        double C = eccPrimeSquared * Math.cos(latRad) * Math.cos(latRad);
        double A = Math.cos(latRad) * (longRad - longOriginRad);
        double M = a * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * latRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * latRad) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * latRad) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * latRad));
        double utmEasting = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;
        double utmNorthing = k0 * (M + N * Math.tan(latRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0));
        if (lat < 0.0) {
            utmNorthing += 1.0E7;
        }
        this.northing = utmNorthing;
        this.easting = utmEasting;
        this.zoneNumber = zoneNumberTmp;
        this.zoneLetter = (char)78;
        if (lat < 0.0) {
            this.zoneLetter = (char)83;
        }
    }

    public static char utmLetterDesignator(double latitude) {
        int letterDesignator = 84.0 >= latitude && latitude >= 72.0 ? 88 : (72.0 > latitude && latitude >= 64.0 ? 87 : (64.0 > latitude && latitude >= 56.0 ? 86 : (56.0 > latitude && latitude >= 48.0 ? 85 : (48.0 > latitude && latitude >= 40.0 ? 84 : (40.0 > latitude && latitude >= 32.0 ? 83 : (32.0 > latitude && latitude >= 24.0 ? 82 : (24.0 > latitude && latitude >= 16.0 ? 81 : (16.0 > latitude && latitude >= 8.0 ? 80 : (8.0 > latitude && latitude >= 0.0 ? 78 : (0.0 > latitude && latitude >= -8.0 ? 77 : (-8.0 > latitude && latitude >= -16.0 ? 76 : (-16.0 > latitude && latitude >= -24.0 ? 75 : (-24.0 > latitude && latitude >= -32.0 ? 74 : (-32.0 > latitude && latitude >= -40.0 ? 72 : (-40.0 > latitude && latitude >= -48.0 ? 71 : (-48.0 > latitude && latitude >= -56.0 ? 70 : (-56.0 > latitude && latitude >= -64.0 ? 69 : (-64.0 > latitude && latitude >= -72.0 ? 68 : (-72.0 > latitude && latitude >= -80.0 ? 67 : 90)))))))))))))))))));
        return (char)letterDesignator;
    }

    public double getEasting() {
        return this.easting;
    }

    public void setEasting(double easting) {
        this.easting = easting;
        this.UTMtoLL();
    }

    public double getNorthing() {
        return this.northing;
    }

    public void setNorthing(double northing) {
        this.northing = northing;
        this.UTMtoLL();
    }

    public char getZoneLetter() {
        return this.zoneLetter;
    }

    public void setZoneLetter(char zoneLetter) {
        this.zoneLetter = zoneLetter;
        this.UTMtoLL();
    }

    public int getZoneNumber() {
        return this.zoneNumber;
    }

    public void setZoneNumber(int zoneNumber) {
        this.zoneNumber = zoneNumber;
        this.UTMtoLL();
    }

    public double getLatitudeDegrees() {
        return this.latitudeDegrees;
    }

    public void setLatitudeDegrees(double latitudeDegrees) {
        this.latitudeDegrees = latitudeDegrees;
        this.LLtoUTM();
    }

    public double getLongitudeDegrees() {
        return this.longitudeDegrees;
    }

    public void setLongitudeDegrees(double longitudeDegrees) {
        this.longitudeDegrees = longitudeDegrees;
        this.LLtoUTM();
    }

    public static void main(String[] args) {
        UTMCoordinates utmcadiz = new UTMCoordinates(745370.0, 4042995.0, 29, 'N');
        utmcadiz.UTMtoLL();
        double lat = utmcadiz.getLatitudeDegrees();
        double lon = utmcadiz.getLongitudeDegrees();
        NeptusLog.pub().info((Object)("Latitude: " + lat + " Longitude: " + lon));
        UTMCoordinates utm = new UTMCoordinates(41.0, -8.0);
        NeptusLog.pub().info((Object)"<###>\nUTM: northing:4539238.6   easthing:584102.1 zone:29 N");
        NeptusLog.pub().info((Object)("<###>northing: " + utm.getNorthing() + "   easting: " + utm.getEasting() + "  zone number: " + utm.getZoneNumber() + "  zone letter: " + utm.getZoneLetter()));
        UTMCoordinates utm2 = new UTMCoordinates(584102.1, 4539238.6, 29, 'N');
        NeptusLog.pub().info((Object)("<###>lat: " + utm2.getLatitudeDegrees() + "   lon: " + utm2.getLongitudeDegrees()));
        utm = new UTMCoordinates(40.5, -73.5);
        NeptusLog.pub().info((Object)"<###>\nUTM: northing:4484335.4   easthing:627103.1 zone:18 N");
        NeptusLog.pub().info((Object)("<###>northing: " + utm.getNorthing() + "   easting: " + utm.getEasting() + "  zone number: " + utm.getZoneNumber() + "  zone letter: " + utm.getZoneLetter()));
        utm = new UTMCoordinates(-26.0, 65.0);
        NeptusLog.pub().info((Object)"<###>\nUTM: northing:7122784.2   easthing:700180.5 zone:41 S");
        NeptusLog.pub().info((Object)("<###>northing: " + utm.getNorthing() + "   easting: " + utm.getEasting() + "  zone number: " + utm.getZoneNumber() + "  zone letter: " + utm.getZoneLetter()));
        utm = new UTMCoordinates(38.094097, -118.86528);
        NeptusLog.pub().info((Object)"<###>\nUTM: northing:4217898.3   easthing:336435.9 zone:11 N");
        NeptusLog.pub().info((Object)("<###>northing: " + utm.getNorthing() + "   easting: " + utm.getEasting() + "  zone number: " + utm.getZoneNumber() + "  zone letter: " + utm.getZoneLetter()));
    }
}

