/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.XmlInputMethods;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.conf.ConfigFetch;

public abstract class AbstractElement
implements ActionListener,
Comparable<AbstractElement>,
XmlOutputMethods,
XmlInputMethods {
    protected static final LocationType guinea = LocationType.ABSOLUTE_ZERO;
    protected boolean isLoadOk = true;
    protected static final String DEFAULT_ROOT_ELEMENT = "mark";
    private double phi = 0.0;
    private double theta = 0.0;
    private double psi = 0.0;
    private boolean filled = true;
    protected int transparency = 0;
    @NeptusProperty
    public LocationType centerLocation = new LocationType();
    @NeptusProperty
    public boolean obstacle;
    protected Document doc = null;
    protected String id = NameNormalizer.getRandomID(this.getTypeAbbrev());
    protected boolean selected = false;
    private MapGroup mapGroup = null;
    private MapType parentMap = null;
    private MissionType missionType = null;
    protected ParametersPanel paramsPanel;
    public boolean userCancel = false;
    public boolean copyChars = true;
    public String[] takenNames = new String[0];
    protected JDialog dialog;
    protected JCheckBox obstacleCheck;
    protected JCheckBox hiddenCheck;
    protected JTextField objName;
    protected JTextField transp;

    public abstract void paint(Graphics2D var1, StateRenderer2D var2, double var3);

    public abstract ParametersPanel getParametersPanel(boolean var1, MapType var2);

    public abstract void initialize(ParametersPanel var1);

    public abstract boolean containsPoint(LocationType var1, StateRenderer2D var2);

    public abstract ELEMENT_TYPE getElementType();

    public abstract int getLayerPriority();

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public AbstractElement() {
    }

    public AbstractElement(String xml) {
        this.load(xml);
    }

    public AbstractElement(MapGroup mg, MapType parentMap) {
        this.mapGroup = mg;
        this.parentMap = parentMap;
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
        return this.load(this.doc.getRootElement());
    }

    @Override
    public boolean load(Element elem) {
        block23: {
            this.doc = Dom4JUtil.elementToDocument(elem);
            if (this.doc == null) {
                this.isLoadOk = false;
                return false;
            }
            boolean bl = this.isLoadOk = !this.getCenterLocation().load(this.doc);
            if (this.isLoadOk()) {
                return false;
            }
            try {
                this.setObstacle(Boolean.parseBoolean(elem.attribute("obstacle").getText()));
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)"Loaded old mission with no obstacle information");
                this.setObstacle(false);
            }
            this.id = this.getCenterLocation().getId();
            try {
                double val;
                String text;
                Node nd = this.doc.selectSingleNode("//attitude");
                if (nd != null) {
                    double val2;
                    String text2;
                    Node ndTemp = nd.selectSingleNode("phi");
                    if (ndTemp != null) {
                        text2 = ndTemp.getText();
                        try {
                            val2 = Double.parseDouble(text2);
                        }
                        catch (NumberFormatException e) {
                            NeptusLog.pub().error((Object)e.getMessage());
                            val2 = 0.0;
                        }
                        this.setPhi(val2);
                    }
                    if ((ndTemp = nd.selectSingleNode("theta")) != null) {
                        text2 = ndTemp.getText();
                        try {
                            val2 = Double.parseDouble(text2);
                        }
                        catch (NumberFormatException e) {
                            NeptusLog.pub().error((Object)e.getMessage());
                            val2 = 0.0;
                        }
                        this.setTheta(val2);
                    }
                    if ((ndTemp = nd.selectSingleNode("psi")) != null) {
                        text2 = ndTemp.getText();
                        try {
                            val2 = Double.parseDouble(text2);
                        }
                        catch (NumberFormatException e) {
                            NeptusLog.pub().error((Object)e.getMessage());
                            val2 = 0.0;
                        }
                        this.setPsi(val2);
                    }
                }
                if ((nd = this.doc.selectSingleNode("//filled")) != null) {
                    text = nd.getText().toLowerCase().trim();
                    try {
                        this.filled = !(text.equals("false") || text.equals("no") || text.equals("0"));
                    }
                    catch (NumberFormatException e) {
                        NeptusLog.pub().error((Object)e.getMessage());
                        this.filled = true;
                    }
                }
                if ((nd = this.doc.selectSingleNode("//transparency")) == null) break block23;
                text = nd.getText();
                try {
                    val = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    NeptusLog.pub().error((Object)e.getMessage());
                    val = 0.0;
                }
                if (val < 0.0) {
                    val = 0.0;
                }
                if (val > 100.0) {
                    val = 100.0;
                }
                this.setTransparency((int)val);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)(this + ":XML not recognized!!!"));
                this.isLoadOk = false;
                return false;
            }
        }
        this.isLoadOk = true;
        return true;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        this.getCenterLocation().setId(this.getId());
        Element root = this.getCenterLocation().asElement(rootElementName);
        if (this.phi != 0.0 || this.theta != 0.0 || this.psi != 0.0) {
            Element att = root.addElement("attitude");
            if (this.phi != 0.0) {
                att.addElement("phi").addText(Double.toString(this.phi));
            }
            if (this.theta != 0.0) {
                att.addElement("theta").addText(Double.toString(this.theta));
            }
            if (this.psi != 0.0) {
                att.addElement("psi").addText(Double.toString(this.psi));
            }
        }
        if (this.transparency != 0) {
            root.addElement("transparency").addText(Double.toString(this.transparency));
        }
        root.addElement("filled").addText("" + this.filled);
        root.addAttribute("obstacle", "" + this.isObstacle());
        document.add(root);
        return document;
    }

    public String getTypeAbbrev() {
        return this.getType();
    }

    public abstract String getType();

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency < 0 ? 0 : (transparency > 100 ? 100 : transparency);
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double phi) {
        this.phi = phi;
    }

    public double getRoll() {
        return this.phi;
    }

    public void setRoll(double phi) {
        this.phi = phi;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public double getPitch() {
        return this.theta;
    }

    public void setPitch(double theta) {
        this.theta = theta;
    }

    public double getPsi() {
        return this.psi;
    }

    public void setPsi(double psi) {
        this.psi = psi;
    }

    public double getYaw() {
        return this.psi;
    }

    public void setYaw(double psi) {
        this.psi = psi;
    }

    public void setRollDeg(double roll) {
        this.phi = roll;
    }

    public void setPitchDeg(double pitch) {
        this.theta = pitch;
    }

    public void setYawDeg(double yaw) {
        this.psi = yaw;
    }

    public double getRollRad() {
        return Math.toRadians(this.phi);
    }

    public double getPitchRad() {
        return Math.toRadians(this.theta);
    }

    public double getYawRad() {
        return Math.toRadians(this.psi);
    }

    public double getRollDeg() {
        return this.phi % 360.0;
    }

    public double getPitchDeg() {
        return this.theta % 360.0;
    }

    public double getYawDeg() {
        return this.psi % 360.0;
    }

    public boolean isObstacle() {
        return this.obstacle;
    }

    public void setObstacle(boolean obstacle) {
        this.obstacle = obstacle;
    }

    public double getTopHeight() {
        return this.getCenterLocation().getHeight();
    }

    public MapGroup getMapGroup() {
        if (this.mapGroup == null) {
            this.mapGroup = MapGroup.getNewInstance(null);
        }
        return this.mapGroup;
    }

    public void setMapGroup(MapGroup mapGroup) {
        this.mapGroup = mapGroup;
    }

    public void setParentMap(MapType parentMap) {
        this.parentMap = parentMap;
    }

    public MapType getParentMap() {
        if (this.parentMap == null) {
            this.parentMap = new MapType();
        }
        return this.parentMap;
    }

    public MissionType getMissionType() {
        if (this.missionType == null) {
            NeptusLog.pub().debug((Object)"[MapObject] getMissionType() created a new mission instance!");
            this.missionType = new MissionType();
        }
        return this.missionType;
    }

    public void setMissionType(MissionType missionType) {
        this.missionType = missionType;
    }

    @Override
    public int compareTo(AbstractElement anotherMapObject) {
        AbstractElement tmp = anotherMapObject;
        int diff = this.getLayerPriority() - tmp.getLayerPriority();
        if (diff != 0) {
            return diff;
        }
        if (tmp.getTopHeight() > this.getTopHeight()) {
            return -1;
        }
        if (tmp.getTopHeight() < this.getTopHeight()) {
            return 1;
        }
        if (this instanceof ImageElement && anotherMapObject instanceof ImageElement) {
            if (((ImageElement)this).getImageScale() > ((ImageElement)anotherMapObject).getImageScale()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static Comparator getIDComparator() {
        Comparator cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof AbstractElement) || !(o2 instanceof AbstractElement)) {
                    return 0;
                }
                return ((AbstractElement)o1).getId().compareTo(((AbstractElement)o2).getId());
            }
        };
        return cmp;
    }

    public LocationType getCenterLocation() {
        return this.centerLocation;
    }

    public void setCenterLocation(LocationType centralLocation) {
        this.centerLocation = centralLocation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return this.getId();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if ("add".equals(action.getActionCommand())) {
            if (!NameNormalizer.isNeptusValidIdentifier(this.objName.getText())) {
                JOptionPane.showMessageDialog(this.paramsPanel, I18n.text("The object identifier is not valid"));
                return;
            }
            if (this.objName.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.paramsPanel, I18n.text("The object has to have a name"));
                return;
            }
            if (!this.objName.getText().equals(this.id) && this.takenNames != null) {
                for (int i = 0; i < this.takenNames.length; ++i) {
                    if (!this.takenNames[i].equals(this.objName.getText())) continue;
                    JOptionPane.showMessageDialog(this.paramsPanel, I18n.text("The entered identifier is already in use"));
                    return;
                }
            }
            if (this.paramsPanel.getErrors() != null) {
                JOptionPane.showMessageDialog(this.paramsPanel, this.paramsPanel.getErrors());
                return;
            }
            this.setId(this.objName.getText());
            this.setObstacle(this.obstacleCheck.isSelected());
            this.transparency = this.hiddenCheck.isSelected() ? 100 : 0;
            this.initialize(this.paramsPanel);
            this.dialog.setVisible(false);
            this.dialog.dispose();
            return;
        }
        if ("cancel".equals(action.getActionCommand())) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.userCancel = true;
            return;
        }
    }

    public void showParametersDialog(Component parentComp, String[] takenNames, MapType map, boolean editable) {
        this.showParametersDialog(parentComp, takenNames, map, editable, editable);
    }

    protected void showParametersDialog(Component parentComp, String[] takenNames, MapType map, boolean editable, boolean idEditable) {
        this.takenNames = takenNames;
        this.parentMap = map;
        this.objName = new JTextField(8);
        this.objName.setEditable(editable ? idEditable : editable);
        this.objName.setText(this.id);
        this.paramsPanel = this.getParametersPanel(editable, map);
        this.dialog = parentComp == null || SwingUtilities.getWindowAncestor(parentComp) == null ? new JDialog((Frame)ConfigFetch.getSuperParentFrame()) : new JDialog(SwingUtilities.getWindowAncestor(parentComp));
        JPanel idPanel = new JPanel();
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        idPanel.setLayout(flow);
        this.obstacleCheck = new JCheckBox(I18n.text("Obstacle"));
        this.obstacleCheck.setSelected(this.isObstacle());
        this.hiddenCheck = new JCheckBox(I18n.text("Hidden"));
        this.hiddenCheck.setSelected(this.transparency >= 100);
        idPanel.add(new JLabel(I18n.text("Object Name:")));
        idPanel.add(this.objName);
        idPanel.add(this.obstacleCheck);
        idPanel.add(this.hiddenCheck);
        if (takenNames == null) {
            this.objName.setEnabled(false);
            this.objName.setText(this.id);
        }
        JPanel buttonsPanel = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(2);
        buttonsPanel.setLayout(layout);
        JButton add = new JButton(I18n.text("OK"));
        add.setActionCommand("add");
        add.addActionListener(this);
        add.setPreferredSize(new Dimension(100, 25));
        buttonsPanel.add(add);
        JButton cancel = new JButton(I18n.text("Cancel"));
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        cancel.setPreferredSize(new Dimension(100, 25));
        buttonsPanel.add(cancel);
        GuiUtils.reactEnterKeyPress(add);
        GuiUtils.reactEscapeKeyPress(cancel);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.setTitle(I18n.textf("Parameters for %mapElementType", this.getType()));
        this.dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.dialog.getContentPane().add((Component)idPanel, "North");
        this.dialog.getContentPane().add((Component)this.paramsPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonsPanel, "South");
        Dimension pSize = this.paramsPanel.getPreferredSize();
        this.dialog.setSize(Math.max(pSize.width, 480), pSize.height + 24);
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractElement.this.userCancel = true;
                AbstractElement.this.dialog.setVisible(false);
                AbstractElement.this.dialog.dispose();
            }
        });
        this.dialog.setVisible(true);
    }

    public boolean isUserCancel() {
        return this.userCancel;
    }

    public void setTakenNames(String[] takenNames) {
        this.takenNames = takenNames;
    }

    public Color invertColor(Color original) {
        Color inverted = new Color(255 - original.getRed(), 255 - original.getGreen(), 255 - original.getBlue());
        return inverted;
    }

    public Vector<LocationType> getShapePoints() {
        return null;
    }

    public double[] getNEDPosition() {
        NeptusLog.pub().debug((Object)this.getCenterLocation().getDebugString());
        return this.getCenterLocation().getOffsetFrom(guinea);
    }

    public AbstractElement getClone() throws Exception {
        String xml = this.asXML();
        AbstractElement clone = (AbstractElement)this.getClass().newInstance();
        clone.load(xml);
        return clone;
    }

    public static enum ELEMENT_TYPE {
        MODEL_3D,
        TYPE_HOMEREFERENCE,
        TYPE_MARK,
        TYPE_PARALLELEPIPED,
        TYPE_ELLIPSOID,
        TYPE_TRANSPONDER,
        TYPE_PATH,
        TYPE_CYLINDER,
        TYPE_IMAGE,
        TYPE_OTHER;

    }
}

