/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.gui.ParametersSheetPanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.messages.TupleList;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.MapChangeListener;
import pt.lsts.neptus.renderer2d.MissionRenderer;
import pt.lsts.neptus.renderer2d.Renderer;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class DynamicElement
extends MarkElement
implements PropertiesProvider {
    protected String objectClass = "Drifter";
    protected double heading = 0.0;
    protected TupleList data = new TupleList("");
    protected Color innerColor = Color.gray;
    protected int idleTimeSecs = -1;
    protected int connectionTimeoutSecs = 120;
    protected double radius = 5.0;
    protected Ellipse2D circle = new Ellipse2D.Double(-this.radius, -this.radius, 2.0 * this.radius, 2.0 * this.radius);
    protected boolean showDetails = false;
    protected JLabel details = new JLabel(" ");
    private InterpolationColorMap colorMap = new InterpolationColorMap(new double[]{0.0, 0.5, 1.0}, new Color[]{Color.green, Color.yellow, Color.red});
    private long lastUpdateTime = -1L;

    @Override
    public String getType() {
        return "DynamicObject";
    }

    @Override
    public int getLayerPriority() {
        return 6;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        double zoom = renderer.getZoom();
        double[] offsets = this.getCenterLocation().getOffsetFrom(renderer.getCenter());
        AffineTransform oldTransform = g.getTransform();
        g.translate(offsets[1] * zoom, offsets[0] * zoom);
        g.setColor(Color.black);
        float rad = (float)this.radius;
        this.innerColor = this.idleTimeSecs == -1 ? Color.gray : (this.idleTimeSecs == 0 ? Color.white : this.colorMap.getColor((double)this.idleTimeSecs / (double)this.connectionTimeoutSecs));
        g.setPaint(new GradientPaint(-rad, rad, this.innerColor, rad, -rad, this.innerColor.darker()));
        g.fill(this.circle);
        if (!this.isSelected()) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.red);
        }
        g.draw(this.circle);
        String id = this.getId();
        Rectangle2D rect = g.getFontMetrics().getStringBounds(id, g);
        g.setColor(Color.YELLOW);
        g.scale(1.0, -1.0);
        g.drawString(id, (int)(-rect.getWidth()) / 2, (int)this.radius * 2 + 5);
        String txt = "(idle for " + this.idleTimeSecs + " s)";
        rect = g.getFontMetrics().getStringBounds(txt, g);
        g.drawString(txt, (int)(-rect.getWidth()) / 2, (int)this.radius * 2 + 15);
        g.scale(1.0, -1.0);
        if (this.isShowDetails()) {
            g.rotate(rotation);
            g.scale(1.0, -1.0);
            g.translate(this.radius + 3.0, -this.radius);
            this.details.setSize(this.details.getPreferredSize());
            this.details.paint(g);
        }
        g.setTransform(oldTransform);
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        return new ParametersSheetPanel((Property[])this.getProperties());
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        if (paramsPanel instanceof ParametersSheetPanel) {
            this.setProperties(((ParametersSheetPanel)paramsPanel).getProperties());
        }
    }

    @Override
    public DefaultProperty[] getProperties() {
        DefaultProperty sensorClass = PropertiesEditor.getPropertyInstance("Class", String.class, this.getObjectClass(), false);
        DefaultProperty centerLoc = PropertiesEditor.getPropertyInstance("Location", LocationType.class, this.getCenterLocation(), false);
        DefaultProperty heading = PropertiesEditor.getPropertyInstance("Heading", Double.class, this.getHeading(), false);
        DefaultProperty data = PropertiesEditor.getPropertyInstance("Data", String.class, this.getData().toString(), false);
        DefaultProperty idleTime = PropertiesEditor.getPropertyInstance("Idle Time", Integer.class, this.getIdleTimeSecs(), false);
        DefaultProperty timeout = PropertiesEditor.getPropertyInstance("Connection Timeout (secs)", Integer.class, this.getConnectionTimeoutSecs(), true);
        DefaultProperty showDetails = PropertiesEditor.getPropertyInstance("Show Data", Boolean.class, this.isShowDetails(), true);
        return new DefaultProperty[]{sensorClass, centerLoc, heading, data, idleTime, timeout, showDetails};
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            if (p.getName().equals("Class")) {
                this.setObjectClass(p.getValue().toString());
                continue;
            }
            if (p.getName().equals("Location")) {
                this.setCenterLocation((LocationType)p.getValue());
                continue;
            }
            if (p.getName().equals("Heading")) {
                this.setHeading((Double)p.getValue());
                continue;
            }
            if (p.getName().equals("Data")) {
                this.setData(new TupleList(p.getValue().toString()));
                continue;
            }
            if (p.getName().equals("Idle Time")) {
                this.setIdleTimeSecs((Integer)p.getValue());
                continue;
            }
            if (p.getName().equals("Connection Timeout (secs)")) {
                this.setConnectionTimeoutSecs((Integer)p.getValue());
                continue;
            }
            if (!p.getName().equals("Show Data")) continue;
            this.setShowDetails((Boolean)p.getValue());
        }
        this.colorMap = new InterpolationColorMap(new double[]{0.0, this.connectionTimeoutSecs / 2, this.connectionTimeoutSecs}, new Color[]{Color.green, Color.yellow, Color.red});
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "Dynamic Object Properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public TupleList getData() {
        return this.data;
    }

    public void setData(TupleList data) {
        this.data = data;
    }

    public int getIdleTimeSecs() {
        return this.idleTimeSecs;
    }

    public void setIdleTimeSecs(int idleTimeSecs) {
        this.idleTimeSecs = idleTimeSecs;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public int getConnectionTimeoutSecs() {
        return this.connectionTimeoutSecs;
    }

    public void setConnectionTimeoutSecs(int connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public InterpolationColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(InterpolationColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public Color getInnerColor() {
        return this.innerColor;
    }

    public void setInnerColor(Color innerColor) {
        this.innerColor = innerColor;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        MissionType mission = new MissionType("missions/Montemor/mission-20070919-tarde14h.nmisz");
        MapGroup mg = MapGroup.getMapGroupInstance(mission);
        MapType mt = new MapType();
        mg.addMap(mt);
        LocationType lt = new LocationType();
        lt.setLatitudeStr("41N12.4827");
        lt.setLongitudeStr("8W32.0861");
        final DynamicElement dynElem = new DynamicElement();
        dynElem.setCenterLocation(lt);
        dynElem.setIdleTimeSecs(0);
        dynElem.setLastUpdateTime(System.currentTimeMillis());
        mt.addObject(dynElem);
        final MissionRenderer renderer = new MissionRenderer(null, mg, 2);
        GuiUtils.testFrame(renderer);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                dynElem.setLastUpdateTime(System.currentTimeMillis());
                MapChangeEvent mce = new MapChangeEvent(0);
                mce.setMapGroup(dynElem.getMapGroup());
                mce.setSourceMap(dynElem.getParentMap());
                mce.setChangeType("UNKNOWN_CHANGE");
                for (Renderer r : renderer.getRenderers()) {
                    if (!(r instanceof MapChangeListener)) continue;
                    ((MapChangeListener)((Object)r)).mapChanged(mce);
                }
            }
        };
        Timer t = new Timer("Dynamic Element");
        t.schedule(task, 10000L, 10000L);
    }
}

