/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.gui.objparams.ParallelepipedParameters;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.GeometryElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

public class EllipsoidElement
extends GeometryElement {
    protected Ellipse2D.Double thisEllipse;

    @Override
    public String getType() {
        return "Ellipsoid";
    }

    public EllipsoidElement() {
    }

    public EllipsoidElement(MapGroup mg, MapType parentMap) {
        super(mg, parentMap);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        super.initialize(paramsPanel);
        if (paramsPanel instanceof ParallelepipedParameters) {
            double[] pos = this.centerLocation.getOffsetFrom(new LocationType());
            this.thisEllipse = new Ellipse2D.Double(pos[0] - this.width / 2.0, pos[1] - this.height / 2.0, this.width, this.length);
        }
    }

    @Override
    public boolean containsPoint(LocationType lt, StateRenderer2D renderer) {
        double[] offsets = lt.getOffsetFrom(this.getCenterLocation());
        Point2D.Double pt = new Point2D.Double(offsets[1], -offsets[0]);
        AffineTransform t = AffineTransform.getRotateInstance(this.getYawRad());
        Shape s = t.createTransformedShape(new Ellipse2D.Double(-this.getWidth() / 2.0, -this.getLength() / 2.0, this.getWidth(), this.getLength()));
        return s.contains(pt);
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_ELLIPSOID;
    }

    @Override
    public String getTypeAbbrev() {
        return "ellip";
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D pt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(pt.getX(), pt.getY());
        g.rotate(this.getYawRad() - renderer.getRotation());
        double widthScaled = this.width * (double)renderer.getZoom();
        double lengthScaled = this.length * (double)renderer.getZoom();
        Ellipse2D.Double tmp = new Ellipse2D.Double(-widthScaled / 2.0, -lengthScaled / 2.0, widthScaled, lengthScaled);
        if (this.isSelected()) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        } else {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (this.isFilled()) {
            g.fill(tmp);
        }
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        g.draw(tmp);
    }
}

