/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.Color;
import java.awt.Image;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.objparams.ParallelepipedParameters;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.RotatableElement;
import pt.lsts.neptus.types.map.ScalableElement;
import pt.lsts.neptus.types.texture.TextureType;
import pt.lsts.neptus.types.texture.TexturesHolder;

public abstract class GeometryElement
extends AbstractElement
implements RotatableElement,
ScalableElement {
    protected static final String DEFAULT_ROOT_ELEMENT = "geometry";
    public static final String PARALLELEPIPED = "Parallelepiped";
    public static final String ELLIPSOID = "Ellipsoid";
    public static final String CYLINDER = "Cylinder";
    private String geometryType = "Unknown";
    protected double width = 1.0;
    protected double length = 1.0;
    protected double height = 1.0;
    protected Color color = null;
    protected TextureType textureType = null;
    public Image texture = null;
    public float shininess = 0.3f;
    ParallelepipedParameters paramsPanel = new ParallelepipedParameters();

    public GeometryElement() {
    }

    public GeometryElement(String xml) {
        this.load(xml);
    }

    public GeometryElement(MapGroup mg, MapType parentMap) {
        super(mg, parentMap);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    @Override
    public boolean load(Element elem) {
        if (!super.load(elem)) {
            return false;
        }
        try {
            this.setType(this.doc.selectSingleNode("//type").getText());
            this.setDimensionX(Double.parseDouble(this.doc.selectSingleNode("//x-dim").getText()));
            this.setDimensionY(Double.parseDouble(this.doc.selectSingleNode("//y-dim").getText()));
            this.setDimensionZ(Double.parseDouble(this.doc.selectSingleNode("//z-dim").getText()));
            try {
                Node n = this.doc.selectSingleNode("//filled");
                this.setFilled(n.getText().equals("true"));
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
            Node nd = this.doc.selectSingleNode("//color");
            if (nd != null) {
                String rS = nd.selectSingleNode("r").getText();
                String gS = nd.selectSingleNode("g").getText();
                String bS = nd.selectSingleNode("b").getText();
                int rr = Integer.parseInt(rS);
                int gg = Integer.parseInt(gS);
                int bb = Integer.parseInt(bS);
                this.setMyColor(new Color(rr, gg, bb));
            }
            if ((nd = this.doc.selectSingleNode("//texture")) != null) {
                String textureName = nd.getText().toLowerCase();
                this.setTextureType(TexturesHolder.getTextureByName(textureName));
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(this + ":XML not recognized!!!"));
            this.isLoadOk = false;
            return false;
        }
        this.isLoadOk = true;
        return true;
    }

    @Override
    public String getType() {
        return this.geometryType;
    }

    public void setType(String geometryType) {
        this.geometryType = geometryType;
    }

    public double getDimensionX() {
        return this.width;
    }

    public void setDimensionX(double dimensionX) {
        this.width = dimensionX;
    }

    public double getDimensionY() {
        return this.length;
    }

    public void setDimensionY(double dimensionY) {
        this.length = dimensionY;
    }

    public double getDimensionZ() {
        return this.height;
    }

    public void setDimensionZ(double dimensionZ) {
        this.height = dimensionZ;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Color getMyColor() {
        return this.color;
    }

    public void setMyColor(Color myColor) {
        this.color = myColor;
        this.paramsPanel.setColor(myColor);
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public void setTextureType(TextureType texture) {
        this.textureType = texture;
        if (this.textureType != null) {
            this.texture = this.textureType.getTextureImage();
            this.shininess = this.textureType.getShininess();
        }
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = (Element)super.asDocument(DEFAULT_ROOT_ELEMENT).getRootElement().detach();
        document.add(root);
        root.addElement("type").addText(this.getType());
        root.addElement("filled").addText("" + this.isFilled());
        Element dim = root.addElement("dimensions");
        dim.addElement("x-dim").addText(Double.toString(this.getDimensionX()));
        dim.addElement("y-dim").addText(Double.toString(this.getDimensionY()));
        dim.addElement("z-dim").addText(Double.toString(this.getDimensionZ()));
        if (this.getMyColor() != null) {
            Element colorE = root.addElement("color");
            colorE.addElement("r").setText(Integer.toString(this.getMyColor().getRed()));
            colorE.addElement("g").setText(Integer.toString(this.getMyColor().getGreen()));
            colorE.addElement("b").setText(Integer.toString(this.getMyColor().getBlue()));
        }
        if (this.getTextureType() != null) {
            Element textureE = root.addElement("texture");
            textureE.setText(this.getTextureType().getName());
        }
        return document;
    }

    @Override
    public int getLayerPriority() {
        return 0;
    }

    @Override
    public boolean containsPoint(LocationType lt, StateRenderer2D renderer) {
        double[] diff;
        double dist = lt.getDistanceInMeters(this.getCenterLocation());
        double angle = this.getCenterLocation().getXYAngle(lt);
        if (this.getYawDeg() != 0.0) {
            diff = new double[3];
            diff[0] = dist * Math.cos(angle -= this.getYawRad());
            diff[1] = dist * Math.sin(angle);
        } else {
            diff = lt.getOffsetFrom(this.getCenterLocation());
        }
        double maxDiffX = this.width / 2.0;
        double maxDiffY = this.length / 2.0;
        return Math.abs(diff[1]) <= maxDiffX && Math.abs(diff[0]) <= maxDiffY;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        this.paramsPanel.setDimensions(this.width, this.length, this.height);
        this.paramsPanel.setRotation(this.getRollDeg(), this.getPitchDeg(), this.getYawDeg());
        if (this.getCenterLocation() == null) {
            this.setCenterLocation(new LocationType());
            this.getCenterLocation().setLocation(this.getMapGroup().getCoordinateSystem());
        }
        this.paramsPanel.setLocationType(this.getCenterLocation());
        this.paramsPanel.setFilled(this.isFilled());
        this.paramsPanel.setColor(this.color);
        this.paramsPanel.getTexturesCombo().setSelectedTexture(this.getTextureType());
        this.paramsPanel.setEditable(editable);
        return this.paramsPanel;
    }

    @Override
    public void initialize(ParametersPanel pPanel) {
        if (!(this.paramsPanel instanceof ParallelepipedParameters)) {
            System.err.println("Not my parameters!... Default parameters will be set.");
        } else {
            this.paramsPanel = (ParallelepipedParameters)pPanel;
            this.setCenterLocation(this.paramsPanel.getLocationType());
            double[] dim = this.paramsPanel.getDimension();
            this.width = dim[0];
            this.length = dim[1];
            this.height = dim[2];
            double[] rot = this.paramsPanel.getRotation();
            this.setRollDeg(rot[0]);
            this.setPitchDeg(rot[1]);
            this.setYawDeg(rot[2]);
            this.color = this.paramsPanel.getChosenColor();
            this.setTextureType(this.paramsPanel.getSelectedTexture());
            this.setFilled(this.paramsPanel.isFilled());
        }
    }

    @Override
    public void rotateLeft(double ammount) {
        this.setYawDeg(this.getYawDeg() - ammount);
    }

    @Override
    public void rotateRight(double ammount) {
        this.setYawDeg(this.getYawDeg() + ammount);
    }

    @Override
    public void grow(double ammount) {
        double maxDim = Math.max(this.width, this.height);
        maxDim = Math.max(maxDim, this.length);
        this.width += ammount * (this.width / maxDim);
        this.height += ammount * (this.height / maxDim);
        this.length += ammount * (this.length / maxDim);
    }

    @Override
    public void shrink(double ammount) {
        double minimum = 0.1;
        if (this.width - ammount < 0.1) {
            return;
        }
        if (this.length - ammount * (this.length / this.width) < 0.1) {
            return;
        }
        if (this.height - ammount * (this.height / this.width) < 0.1) {
            return;
        }
        double maxDim = Math.max(this.width, this.height);
        maxDim = Math.max(maxDim, this.length);
        this.width -= ammount * (this.width / maxDim);
        this.height -= ammount * (this.height / maxDim);
        this.length -= ammount * (this.length / maxDim);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double[] getDimension() {
        return new double[]{this.getWidth(), this.getLength(), this.getHeight()};
    }

    @Override
    public void setDimension(double[] newDimension) {
        if (newDimension.length != 3) {
            NeptusLog.pub().error((Object)new Exception("Tried to set the dimension with an invalid array (size=" + newDimension.length + ")"));
            return;
        }
        this.setWidth(newDimension[0]);
        this.setLength(newDimension[1]);
        this.setHeight(newDimension[2]);
    }

    @Override
    public double getTopHeight() {
        return this.getCenterLocation().getHeight() + this.getHeight() / 2.0;
    }
}

