/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.gui.CoordinateSystemPanel;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

public class HomeReferenceElement
extends AbstractElement {
    private CoordinateSystem coordinateSystem = new CoordinateSystem();
    private CoordinateSystemPanel params = null;

    public HomeReferenceElement(MapGroup mg, MapType map) {
        super(mg, map);
        if (mg != null && mg.getCoordinateSystem() != null) {
            this.setCoordinateSystem(mg.getCoordinateSystem());
        }
        this.setYawDeg(this.getCoordinateSystem().getYaw());
        this.setPitchDeg(this.getCoordinateSystem().getPitch());
        this.setRollDeg(this.getCoordinateSystem().getRoll());
    }

    public HomeReferenceElement() {
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(tt.getX(), tt.getY());
        g.rotate(this.getYawRad() - renderer.getRotation());
        if (!this.isSelected()) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.WHITE);
        }
        g.drawOval(-5, -5, 10, 10);
        if (!this.isSelected()) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(Color.RED);
        }
        g.drawLine(-8, 0, 8, 0);
        g.drawLine(0, -8, 0, 8);
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        this.params = new CoordinateSystemPanel(this.getCoordinateSystem());
        this.params.setEditable(false);
        return this.params;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
    }

    @Override
    public boolean containsPoint(LocationType lt, StateRenderer2D renderer) {
        double distance = this.getCenterLocation().getHorizontalDistanceInMeters(lt);
        if (renderer == null) {
            return distance < 5.0;
        }
        return distance * (double)renderer.getZoom() < 10.0;
    }

    @Override
    public LocationType getCenterLocation() {
        LocationType lt = new LocationType();
        lt.setLocation(this.getCoordinateSystem());
        return lt;
    }

    @Override
    public void setCenterLocation(LocationType l) {
        this.centerLocation = l;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem.setCoordinateSystem(coordinateSystem);
    }

    @Override
    public double getYawRad() {
        return Math.toRadians(this.coordinateSystem.getYaw());
    }

    @Override
    public double getYawDeg() {
        return this.coordinateSystem.getYaw();
    }

    @Override
    public int getLayerPriority() {
        return 8;
    }

    @Override
    public String getType() {
        return "Home Reference";
    }

    @Override
    public String getTypeAbbrev() {
        return "href";
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_HOMEREFERENCE;
    }
}

