/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.io.File;
import javax.swing.JPanel;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.objparams.ImageObjectParameters;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.RotatableElement;
import pt.lsts.neptus.types.map.ScalableElement;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ImageElement
extends AbstractElement
implements ScalableElement,
RotatableElement {
    protected static final String DEFAULT_ROOT_ELEMENT = "image";
    public static final int DEFAULT_RESOLUTION = 100;
    private String imageFileName = null;
    private double imageScale = 1.0;
    private String bathymetricImageFileName = null;
    private boolean isBathymetric = false;
    private double maxHeight = 0.0;
    private double maxDepth = 20.0;
    private int resolution = 100;
    protected String originalFilePath = "";
    boolean selected = false;
    private Image image = null;
    private Image heightImage = null;
    private ImageObjectParameters params = new ImageObjectParameters();

    public ImageElement() {
    }

    public ImageElement(File imgFile, File worldFile) throws Exception {
        this.originalFilePath = imgFile.getAbsolutePath();
        this.setId(imgFile.getName());
        String[] lines = FileUtil.getFileAsString(worldFile).split("\n");
        this.image = ImageUtils.getImage(imgFile.getAbsolutePath());
        if (lines.length != 6) {
            throw new Exception("World file not understood");
        }
        double scaleX = Double.parseDouble(lines[0]);
        double rotX = Double.parseDouble(lines[1]);
        double rotY = Double.parseDouble(lines[2]);
        double scaleY = Double.parseDouble(lines[3]);
        double coordX = Double.parseDouble(lines[4]);
        double coordY = Double.parseDouble(lines[5]);
        LocationType loc = new LocationType(coordY, coordX);
        LocationType loc2 = new LocationType(coordY, coordX + scaleX);
        double scale = loc2.getHorizontalDistanceInMeters(loc);
        if (rotX != rotY) {
            NeptusLog.pub().warn((Object)"loading an image file with different X and Y rotations may lead to errors...");
        }
        this.setImageFileName(imgFile.getAbsolutePath());
        this.setImageScale(scale);
        this.setYawDeg(rotX);
        double width = (double)this.image.getWidth(null) * scaleX;
        double height = (double)this.image.getHeight(null) * scaleY;
        this.setCenterLocation(new LocationType(coordY + height / 2.0, coordX + width / 2.0));
    }

    public ImageElement(String xml) {
        this.load(xml);
    }

    public ImageElement(String xml, String originalFilePath) {
        this.originalFilePath = originalFilePath;
        this.load(xml);
    }

    public ImageElement(MapGroup mg, MapType map) {
        super(mg, map);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    @Override
    public String getType() {
        return "Image";
    }

    @Override
    public boolean load(Element elem) {
        if (!super.load(elem)) {
            return false;
        }
        try {
            Node nd = this.doc.selectSingleNode("//href");
            if (nd != null) {
                this.imageFileName = "".equals(this.originalFilePath) ? nd.getText() : ConfigFetch.resolvePathWithParent(this.originalFilePath, nd.getText());
                this.image = ImageUtils.getImage(this.imageFileName);
            }
            this.imageScale = (nd = this.doc.selectSingleNode("//scale")) == null ? 1.0 : Double.parseDouble(nd.getText());
            nd = this.doc.selectSingleNode("//max-height");
            if (nd == null) {
                this.isBathymetric = false;
            } else {
                this.isBathymetric = true;
                this.maxHeight = Double.parseDouble(nd.getText());
                nd = this.doc.selectSingleNode("//max-depth");
                if (nd == null) {
                    this.isBathymetric = false;
                } else {
                    this.maxDepth = Double.parseDouble(nd.getText());
                }
                nd = this.doc.selectSingleNode("//resolution");
                this.resolution = nd == null ? 100 : Integer.parseInt(nd.getText());
                nd = this.doc.selectSingleNode("//bathymetryImage");
                if (nd != null) {
                    this.setBathymetricImageFileName(ConfigFetch.resolvePathWithParent(this.originalFilePath, nd.getText()));
                }
                if ((nd = this.doc.selectSingleNode("//href-altitude")) != null) {
                    this.setBathymetricImageFileName(ConfigFetch.resolvePathWithParent(this.originalFilePath, nd.getText()));
                }
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
        this.isLoadOk = true;
        return true;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
        this.image = ImageUtils.getImage(imageFileName);
        this.heightImage = ImageUtils.getImage(imageFileName);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getHeightImage() {
        return this.heightImage;
    }

    public void setHeightImage(Image heightImage) {
        this.heightImage = heightImage;
    }

    public double getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(double imageScale) {
        this.imageScale = imageScale;
    }

    public boolean isBathymetric() {
        return this.isBathymetric;
    }

    public void setBathymetric(boolean isBatimetric) {
        this.isBathymetric = isBatimetric;
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(double maxDepth) {
        this.maxDepth = maxDepth;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = (Element)super.asDocument(DEFAULT_ROOT_ELEMENT).getRootElement().detach();
        document.add(root);
        if ("".equals(this.originalFilePath)) {
            root.addElement("href").addText(this.getImageFileName());
            NeptusLog.pub().error((Object)(this + ": Original file path is empty!"));
        } else {
            root.addElement("href").addText(FileUtil.relativizeFilePathAsURI(this.getOriginalFilePath(), this.getImageFileName()));
        }
        root.addElement("scale").addText(Double.toString(this.getImageScale()));
        if (this.isBathymetric()) {
            root.addElement("max-height").addText(Double.toString(this.getMaxHeight()));
            root.addElement("max-depth").addText(Double.toString(this.getMaxDepth()));
            if (this.getResolution() != 100) {
                root.addElement("resolution").addText(Integer.toString(this.getResolution()));
            }
            if (this.getBathymetricImageFileName() != null) {
                root.addElement("href-altitude").addText(FileUtil.relativizeFilePathAsURI(this.getOriginalFilePath(), this.getBathymetricImageFileName()));
            }
        }
        return document;
    }

    @Override
    public boolean containsPoint(LocationType lt, StateRenderer2D renderer) {
        double[] diff = lt.getOffsetFrom(this.getCenterLocation());
        double width = (double)this.image.getWidth(null) * this.imageScale;
        double length = (double)this.image.getHeight(null) * this.imageScale;
        double maxDiffX = width / 2.0;
        double maxDiffY = length / 2.0;
        return Math.abs(diff[1]) <= maxDiffX && Math.abs(diff[0]) <= maxDiffY;
    }

    @Override
    public int getLayerPriority() {
        return -2;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        this.params.setCenter(this.getCenterLocation());
        this.params.setImageFileName(this.getImageFileName());
        this.params.setImageScale(this.getImageScale());
        this.params.setIsBathymetric(this.isBathymetric());
        this.params.setMaxHeight(this.getMaxHeight());
        this.params.setMaxDepth(this.getMaxDepth());
        this.params.setResolution(this.getResolution());
        this.params.setBathimFile(this.getBathymetricImageFileName());
        return this.params;
    }

    public boolean paramsOK(JPanel paramsPanel) {
        return this.params.getErrors() == null;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        this.setCenterLocation(this.params.getCenter());
        this.setImageFileName(this.params.getImageFileName());
        this.setImageScale(this.params.getImageScale());
        this.setBathymetric(this.params.getIsBathymetric());
        this.setMaxHeight(this.params.getMaxHeight());
        this.setMaxDepth(this.params.getMaxDepth());
        this.setResolution(this.params.getResolution());
        if (this.isBathymetric() && this.params.getBathimFile() != null) {
            this.setBathymetricImageFileName(this.params.getBathimFile().getAbsolutePath());
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        if (this.getImage() == null) {
            NeptusLog.pub().error((Object)(this + ": Tried to draw a null image: " + this.getImageFileName()));
            return;
        }
        Point2D center = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(center.getX(), center.getY());
        g.scale(this.getImageScale() * (double)renderer.getZoom(), this.getImageScale() * (double)renderer.getZoom());
        g.rotate(this.getYawRad() - renderer.getRotation());
        g.drawImage(this.getImage(), -this.getImage().getWidth(renderer) / 2, -this.getImage().getHeight(renderer) / 2, null);
    }

    @Override
    public void grow(double ammount) {
        this.imageScale *= 1.01;
    }

    @Override
    public void shrink(double ammount) {
        this.imageScale /= 1.01;
    }

    @Override
    public void rotateLeft(double ammount) {
        this.setYawDeg(this.getYawDeg() - ammount);
    }

    @Override
    public void rotateRight(double ammount) {
        this.setYawDeg(this.getYawDeg() + ammount);
    }

    @Override
    public double[] getDimension() {
        return new double[]{(double)this.getImage().getWidth(null) * this.imageScale, (double)this.getImage().getHeight(null) * this.imageScale, 0.0};
    }

    @Override
    public void setDimension(double[] newDimension) {
        if (newDimension.length != 3) {
            NeptusLog.pub().error((Object)new Exception("Tried to set the dimension with an invalid array (size=" + newDimension.length + ")"));
            return;
        }
        this.imageScale = newDimension[0] / (double)this.getImage().getWidth(null);
    }

    public String getBathymetricImageFileName() {
        return this.bathymetricImageFileName;
    }

    public void setBathymetricImageFileName(String bathymetricImageFileName) {
        this.bathymetricImageFileName = bathymetricImageFileName;
    }

    @Override
    public String getTypeAbbrev() {
        return "img";
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_IMAGE;
    }
}

