/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.SimpleMapElement;

public class LineSegmentElement
extends SimpleMapElement {
    @NeptusProperty
    public double length = 100.0;
    @NeptusProperty
    public Color color = Color.blue;

    public LineSegmentElement(MapGroup mg, MapType map) {
        super(mg, map);
    }

    public LineSegmentElement() {
    }

    @Override
    public String getTypeAbbrev() {
        return "line";
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D pt = renderer.getScreenPosition(this.getCenterLocation());
        double lengthScaled = this.length * (double)renderer.getZoom();
        g.translate(pt.getX(), pt.getY());
        g.rotate(Math.PI + this.getYawRad() - renderer.getRotation());
        g.fill(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        g.drawArc((int)(-lengthScaled), (int)(-lengthScaled), (int)lengthScaled * 2, (int)lengthScaled * 2, -92, 4);
        g.setStroke(new BasicStroke(3.0f));
        g.draw(new Line2D.Double(0.0, 0.0, 0.0, lengthScaled));
        g.setStroke(new BasicStroke(1.5f));
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        g.draw(new Line2D.Double(0.0, 0.0, 0.0, lengthScaled));
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        return (double)renderer.getZoom() * point.getDistanceInMeters(this.getCenterLocation()) <= 5.0;
    }
}

