/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.MapChangeListener;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.HomeReferenceElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;

public class MapGroup
implements MapChangeListener {
    public Hashtable<String, MapType> maps = new Hashtable();
    private static Hashtable<String, MapGroup> instances = new Hashtable();
    public Vector<MapChangeListener> listeners = new Vector();
    private CoordinateSystem cs = new CoordinateSystem();
    private HomeReferenceElement HomeRef = new HomeReferenceElement(this, null);
    protected MissionType mission = null;
    static final int LAYER_VIRTUAL = 0;
    static final int LAYER_REAL = 1;
    static final int LAYER_BACKGROUND = 2;

    public Vector<AbstractElement> getObstacles() {
        Vector<AbstractElement> ret = new Vector<AbstractElement>();
        for (AbstractElement a : this.getAllObjects()) {
            if (!a.isObstacle()) continue;
            ret.add(a);
        }
        return ret;
    }

    public <T> Vector<T> getAllObjectsOfType(Class<T> type) {
        Vector<AbstractElement> ret = new Vector<AbstractElement>();
        for (AbstractElement elem : this.getAllObjects()) {
            if (!elem.getClass().equals(type)) continue;
            ret.add(elem);
        }
        return ret;
    }

    public static MapGroup getNewInstance(CoordinateSystem cs) {
        NeptusLog.pub().debug((Object)"[MapGroup] getNewInstance() called. Not stored in the hashtable");
        if (cs == null) {
            cs = new CoordinateSystem();
        }
        MapGroup mg = new MapGroup();
        mg.setCoordinateSystem(cs);
        return mg;
    }

    public MapType getPivotMap() {
        MapType m = null;
        for (MapType mt : this.getMaps()) {
            if (mt.getHref() == null || mt.getHref().length() <= 0) continue;
            m = mt;
        }
        return m != null ? m : this.getMaps()[0];
    }

    public static MapGroup getMapGroupInstance(MissionType mt) {
        if (mt == null) {
            return MapGroup.getNewInstance(new CoordinateSystem());
        }
        NeptusLog.pub().debug((Object)("[MapGroup] getMapGroupInstance(" + mt.getId() + ") called."));
        if (!instances.containsKey(mt.getId())) {
            MapGroup mg = mt.generateMapGroup();
            mg.mission = mt;
            instances.put(mt.getId(), mg);
            NeptusLog.pub().debug((Object)("[MapGroup] new instance has been created. Stored map groups: " + instances.size()));
        } else {
            NeptusLog.pub().debug((Object)"[MapGroup] instance found in the hashtable.");
        }
        return instances.get(mt.getId());
    }

    public static boolean containsInstance(String id) {
        return instances.containsKey(id);
    }

    public static void resetMissionInstance(MissionType newMission) {
        String id = newMission.getId();
        MapGroup mg = instances.get(id);
        if (mg == null) {
            mg = newMission.generateMapGroup();
            return;
        }
        mg.mission = newMission;
        mg.setCoordinateSystem(newMission.getHomeRef());
        Object[] maps = newMission.getMapsList().values().toArray();
        Hashtable<String, MapType> oldMaps = mg.maps;
        mg.maps = new Hashtable();
        for (int i = 0; i < maps.length; ++i) {
            MapMission mm = (MapMission)maps[i];
            MapType mt = mm.getMap();
            mt.setHref(mm.getHref());
            mt.setChanged(false);
            mt.setMission(newMission);
            mt.setMapGroup(mg);
            if (oldMaps.containsKey(mt.getId())) {
                for (MapChangeListener mcl : oldMaps.get((Object)mt.getId()).changeListeners) {
                    mt.addChangeListener(mcl);
                }
                oldMaps.remove(mt.getId());
            }
            mg.addMap(mt);
        }
        mg.warnListeners(new MapChangeEvent(-1));
        NeptusLog.pub().debug((Object)("[MapGroup] resetMissionInstance(\"" + id + "\") called."));
    }

    public static MapGroup setMissionInstance(String id, MapGroup mg) {
        NeptusLog.pub().debug((Object)("[MapGroup] setMissionInstance(\"" + id + "\",\"" + mg + "\") called."));
        if (instances.containsKey(id)) {
            NeptusLog.pub().debug((Object)"[MapGroup] instance found in the hashtable, changing the existing instance.");
            MapGroup existingMapGroup = instances.get(id);
            if (existingMapGroup == mg) {
                return mg;
            }
            Object[] oldMaps = existingMapGroup.maps.values().toArray();
            for (int i = 0; i < oldMaps.length; ++i) {
                existingMapGroup.removeMap(((MapType)oldMaps[i]).getId());
            }
            Object[] newMaps = mg.maps.values().toArray();
            for (int i = 0; i < newMaps.length; ++i) {
                existingMapGroup.addMap((MapType)newMaps[i]);
            }
            existingMapGroup.setCoordinateSystem(mg.getCoordinateSystem());
            existingMapGroup.setHomeRef(mg.getHomeRef());
            if (mg.listeners.size() > 0) {
                NeptusLog.pub().debug((Object)"New MapGroup listeners size should be 0");
            }
        } else {
            NeptusLog.pub().debug((Object)"[MapGroup] instance not found, added to the hashtable.");
            instances.put(id, mg);
        }
        return instances.get(id);
    }

    private MapGroup() {
    }

    public void addMap(MapType map) {
        if (this.maps.contains(map.getId())) {
            this.maps.get(map.getId()).removeChangeListener(this);
        }
        this.maps.put(map.getId(), map);
        map.addChangeListener(this);
        String[] objNames = map.getObjectIds();
        for (int i = 0; i < objNames.length; ++i) {
            AbstractElement mo = map.getObject(objNames[i]);
            mo.setMapGroup(this);
            mo.setParentMap(map);
            MapChangeEvent mce = new MapChangeEvent(2);
            mce.setChangedObject(mo);
            mce.setSourceMap(map);
            this.warnListeners(mce);
        }
    }

    public void removeMap(String mapID) {
        MapType tmp = this.maps.get(mapID);
        if (tmp == null) {
            return;
        }
        this.maps.remove(mapID);
        String[] objNames = tmp.getObjectIds();
        for (int i = 0; i < objNames.length; ++i) {
            MapChangeEvent mce = new MapChangeEvent(1);
            mce.setMapGroup(this);
            mce.setChangedObject(tmp.getObject(objNames[i]));
            this.warnListeners(mce);
        }
        tmp.removeChangeListener(this);
    }

    @Deprecated
    public void setMap(MapType map) {
        this.removeMap(map.getId());
        this.addMap(map);
        map.addChangeListener(this);
    }

    public MapType getMapByID(String mapID) {
        return this.maps.get(mapID);
    }

    @Override
    public void mapChanged(MapChangeEvent changeEvent) {
        this.warnListeners(changeEvent);
    }

    public AbstractElement getMapObject(String objID) {
        StringTokenizer st = new StringTokenizer(objID, ":");
        if (st.countTokens() < 2) {
            NeptusLog.pub().warn((Object)("Tried to get an object without its map id (" + objID + ")"));
            return null;
        }
        String mapStr = st.nextToken();
        String objStr = st.nextToken();
        MapType tmp = this.maps.get(mapStr);
        return tmp.getObject(objStr);
    }

    public void updateObjectIds() {
        for (MapType m : this.maps.values()) {
            m.updateObjectIds();
        }
    }

    public AbstractElement[] getMapObjectsByID(String objID) {
        Vector<AbstractElement> vec = new Vector<AbstractElement>();
        for (MapType map : this.getMaps()) {
            AbstractElement mo = map.getObject(objID);
            if (mo == null) continue;
            vec.add(mo);
        }
        return vec.toArray(new AbstractElement[0]);
    }

    public MapType[] getMaps() {
        return this.maps.values().toArray(new MapType[0]);
    }

    public void addChangeListener(MapChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(MapChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void warnListeners(MapChangeEvent changeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MapChangeListener tmp = this.listeners.get(i);
            tmp.mapChanged(changeEvent);
        }
    }

    public AbstractElement[] getObjectsFromOtherMaps(String mapID) {
        Vector<AbstractElement> objs = new Vector<AbstractElement>();
        Enumeration<MapType> e = this.maps.elements();
        while (e.hasMoreElements()) {
            MapType curMap = e.nextElement();
            if (curMap.getId().equals(mapID)) continue;
            objs.addAll(curMap.getObjects());
        }
        objs.add(this.getHomeRef());
        Object[] mo = objs.toArray(new AbstractElement[0]);
        Arrays.sort(mo);
        return mo;
    }

    public AbstractElement[] getObjectsFromMap(String mapID) {
        Vector<AbstractElement> objs = new Vector<AbstractElement>();
        Enumeration<MapType> e = this.maps.elements();
        while (e.hasMoreElements()) {
            MapType curMap = e.nextElement();
            if (!curMap.getId().equals(mapID)) continue;
            objs.addAll(curMap.getObjects());
        }
        objs.add(this.getHomeRef());
        Object[] mo = objs.toArray(new AbstractElement[0]);
        Arrays.sort(mo);
        return mo;
    }

    public AbstractElement[] getAllObjects() {
        Vector<AbstractElement> objs = new Vector<AbstractElement>();
        Enumeration<MapType> e = this.maps.elements();
        while (e.hasMoreElements()) {
            MapType curMap = e.nextElement();
            objs.addAll(curMap.getObjects());
        }
        objs.add(this.getHomeRef());
        Object[] mo = objs.toArray(new AbstractElement[0]);
        Arrays.sort(mo);
        return mo;
    }

    public AbstractElement[][] getObjectsByLayers() {
        int i;
        AbstractElement[] allObjs = this.getAllObjects();
        Vector[] vLayer = new Vector[3];
        for (i = 0; i < vLayer.length; ++i) {
            vLayer[i] = new Vector();
        }
        for (i = 0; i < allObjs.length; ++i) {
            if (allObjs[i] instanceof ImageElement) {
                vLayer[2].add(allObjs[i]);
                continue;
            }
            if (allObjs[i] instanceof ImageElement) {
                vLayer[0].add(allObjs[i]);
                continue;
            }
            vLayer[1].add(allObjs[i]);
        }
        AbstractElement[] lBackground = new AbstractElement[vLayer[2].size()];
        for (int i2 = 0; i2 < lBackground.length; ++i2) {
            AbstractElement tmp;
            lBackground[i2] = tmp = (AbstractElement)vLayer[2].get(i2);
        }
        AbstractElement[] lVirtual = new AbstractElement[vLayer[0].size()];
        for (int i3 = 0; i3 < lVirtual.length; ++i3) {
            AbstractElement tmp;
            lVirtual[i3] = tmp = (AbstractElement)vLayer[0].get(i3);
        }
        AbstractElement[] lReal = new AbstractElement[vLayer[1].size()];
        for (int i4 = 0; i4 < lReal.length; ++i4) {
            AbstractElement tmp;
            lReal[i4] = tmp = (AbstractElement)vLayer[1].get(i4);
        }
        return new AbstractElement[][]{lVirtual, lReal, lBackground};
    }

    public int numObjects() {
        int sum = 1;
        Enumeration<MapType> e = this.maps.elements();
        while (e.hasMoreElements()) {
            MapType curMap = e.nextElement();
            sum += curMap.numObjects();
        }
        return sum;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public void setCoordinateSystem(CoordinateSystem cs) {
        this.cs = cs;
        this.getHomeRef().setCoordinateSystem(cs);
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setSourceMap(null);
        mce.setChangedObject(this.getHomeRef());
        this.warnListeners(mce);
    }

    public HomeReferenceElement getHomeRef() {
        if (this.HomeRef == null) {
            this.HomeRef = new HomeReferenceElement(this, null);
        }
        return this.HomeRef;
    }

    public void setHomeRef(HomeReferenceElement homeRef) {
        this.getHomeRef().setCoordinateSystem(homeRef.getCoordinateSystem());
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setChangedObject(homeRef);
        this.warnListeners(mce);
    }

    private IMCMessage createShape(AbstractElement elem) {
        Vector<LocationType> pts = elem.getShapePoints();
        if (pts == null) {
            return null;
        }
        IMCMessage nextPoint = null;
        for (int i = pts.size() - 1; i >= 0; --i) {
            IMCMessage ptMsg = IMCDefinition.getInstance().create("MapPoint", new Object[0]);
            double[] lld = pts.get(i).getAbsoluteLatLonDepth();
            ptMsg.setValue("lat", (Object)Math.toRadians(lld[0]));
            ptMsg.setValue("lon", (Object)Math.toRadians(lld[1]));
            ptMsg.setValue("alt", (Object)(-1.0 * lld[2]));
            if (nextPoint == null) {
                ptMsg.setValue("nextpt", null);
            } else {
                ptMsg.setValue("nextpt", nextPoint);
            }
            nextPoint = ptMsg;
        }
        return IMCDefinition.getInstance().create("MapShape", new Object[]{"shapetype", 0, "points", nextPoint});
    }

    public IMCMessage getIMCSerialization(String mapId) {
        IMCMessage msg = IMCDefinition.getInstance().create("Map", new Object[]{"id", mapId});
        AbstractElement[] elems = this.getAllObjects();
        IMCMessage nextShape = null;
        for (int i = elems.length - 1; i >= 0; --i) {
            IMCMessage shpMsg = this.createShape(elems[i]);
            if (shpMsg == null) continue;
            if (nextShape != null) {
                shpMsg.setValue("nextshape", nextShape);
            } else {
                shpMsg.setValue("nextshape", null);
            }
            nextShape = shpMsg;
        }
        if (nextShape != null) {
            msg.setValue("features", nextShape);
        } else {
            msg.setValue("features", null);
        }
        try {
            LsfMessageLogger.log((IMCMessage)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public MissionType getMission() {
        return this.mission;
    }
}

