/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.mp.Dimension;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.MapChangeListener;
import pt.lsts.neptus.types.XmlInputMethods;
import pt.lsts.neptus.types.XmlInputMethodsFromFile;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.coord.LocationsHolder;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.CylinderElement;
import pt.lsts.neptus.types.map.EllipsoidElement;
import pt.lsts.neptus.types.map.GeometryElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.LineSegmentElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.MineDangerAreaElement;
import pt.lsts.neptus.types.map.Model3DElement;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.map.QRouteElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.XMLValidator;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MapType
implements XmlOutputMethods,
XmlInputMethods,
XmlInputMethodsFromFile {
    protected static final String DEFAULT_ROOT_ELEMENT = "map";
    private String href = "";
    private final LinkedList<String> notesList = new LinkedList();
    private Document doc;
    protected boolean isLoadOk = true;
    private String originalFilePath = "";
    private boolean changed = false;
    private LinkedHashMap<String, AbstractElement> elements = new LinkedHashMap();
    private Dimension defaultDimension;
    LinkedList<MapChangeListener> changeListeners = new LinkedList();
    private LocationType centerLocation = new LocationType();
    private String name = "Unnamed Map";
    private String id = "id_" + System.currentTimeMillis();
    private String type = "Other";
    private MissionType mission = null;
    private MapGroup mapGroup = null;
    private String description = "All aditional information should go here. Enter things like surrounding locations, previous missions in the local, etc...";
    protected static Vector<AbstractElement> elems = null;

    public static final Vector<AbstractElement> getMapElements() {
        if (elems == null) {
            elems = new Vector();
            elems.add(new MarkElement());
            elems.add(new TransponderElement());
            elems.add(new ParallelepipedElement());
            elems.add(new CylinderElement());
            elems.add(new EllipsoidElement());
            elems.add(new Model3DElement());
            elems.add(new ImageElement());
            elems.add(new MineDangerAreaElement(null, null));
            elems.add(new QRouteElement(null, null));
            elems.add(new LineSegmentElement(null, null));
        }
        return elems;
    }

    public void updateObjectIds() {
        Vector<AbstractElement> objs = new Vector<AbstractElement>();
        objs.addAll(this.getObjects());
        this.elements.clear();
        for (AbstractElement o : objs) {
            this.elements.put(o.getId(), o);
        }
    }

    public MapType(String url) {
        this.loadFile(url);
    }

    public MapType(Dimension defaultDimension) {
        this.defaultDimension = defaultDimension;
        this.centerLocation = new LocationType();
    }

    public MapType(LocationType center) {
        this.defaultDimension = new Dimension(30.0f, 30.0f, 30.0f);
        this.centerLocation = center;
    }

    public MapType() {
        this.defaultDimension = new Dimension(30.0f, 30.0f, 30.0f);
        this.centerLocation = new LocationType();
    }

    public void addChangeListener(MapChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(MapChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void clearChangeListeners() {
        NeptusLog.pub().warn((Object)("Removing " + this.changeListeners.size() + " dead listeners"));
        this.changeListeners.clear();
    }

    public void warnChangeListeners(MapChangeEvent changeEvent) {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            MapChangeListener tmp = this.changeListeners.get(i);
            tmp.mapChanged(changeEvent);
        }
    }

    public Dimension getDimension() {
        return this.defaultDimension;
    }

    public void addObject(AbstractElement newObject) {
        this.elements.put(newObject.getId(), newObject);
        MapChangeEvent event = new MapChangeEvent(2);
        event.setChangedObject(newObject);
        event.setSourceMap(this);
        this.warnChangeListeners(event);
    }

    public AbstractElement getObject(String id) {
        return this.elements.get(id);
    }

    public String[] getObjectIds() {
        return this.elements.keySet().toArray(new String[0]);
    }

    public void remove(String objId) {
        MapChangeEvent changeEvent = new MapChangeEvent(1);
        AbstractElement changedObject = this.elements.get(objId);
        changeEvent.setChangedObject(changedObject);
        changeEvent.setSourceMap(this);
        this.elements.remove(objId);
        this.warnChangeListeners(changeEvent);
    }

    public Collection<AbstractElement> getObjects() {
        return this.elements.values();
    }

    public int numObjects() {
        return this.elements.size();
    }

    public LocationType getCenterLocation() {
        return this.centerLocation;
    }

    public void setCenterLocation(LocationType centerLocation) {
        this.centerLocation.setLocation(centerLocation);
    }

    public Dimension getDefaultDimension() {
        return this.defaultDimension;
    }

    public void setDefaultDimension(Dimension defaultDimension) {
        this.defaultDimension = defaultDimension;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String mapDescription) {
        this.description = mapDescription;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String mapID) {
        this.id = mapID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String mapName) {
        this.name = mapName;
    }

    public void getReferentialPoints() {
        Object[] objs = this.getObjects().toArray();
        for (int i = 0; i < objs.length; ++i) {
            AbstractElement mo = (AbstractElement)objs[i];
            if (objs[i] instanceof MarkElement) {
                LocationsHolder.putAbstractLocationPoint(mo.getCenterLocation());
            }
            if (!(objs[i] instanceof HomeReference)) continue;
            LocationsHolder.putAbstractLocationPoint(mo.getCenterLocation());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean load(Element elem) {
        this.doc = Dom4JUtil.elementToDocument(elem);
        if (this.doc == null) {
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    private boolean load() {
        this.elements = new LinkedHashMap();
        long initTime = System.currentTimeMillis();
        try {
            AbstractElement im;
            AbstractElement mm;
            Element elem;
            this.isLoadOk = true;
            this.setId(this.doc.selectSingleNode("/map/header/id").getText());
            this.setName(this.doc.selectSingleNode("/map/header/name").getText());
            Node nd = this.doc.selectSingleNode("/map/header/type");
            if (nd != null) {
                this.setType(nd.getText());
            }
            if ((nd = this.doc.selectSingleNode("/map/header/description")) != null) {
                this.setDescription(nd.getText());
            }
            if ((nd = this.doc.selectSingleNode("/map/header/type")) != null) {
                this.setType(nd.getText());
            }
            List lst = this.doc.selectNodes("/map/header/notes/note");
            ListIterator lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                this.notesList.add(elem.getText());
            }
            lst = this.doc.selectNodes("/map/features/mark");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new MarkElement();
                mm.load(elem);
                this.elements.put(mm.getId(), mm);
            }
            lst = this.doc.selectNodes("/map/features/transponder");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new TransponderElement(elem);
                this.elements.put(mm.getId(), mm);
            }
            lst = this.doc.selectNodes("/map/features/geometry[type='Parallelepiped']");
            lst.addAll(this.doc.selectNodes("/map/features/geometry[type='Parallel Piped']"));
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new ParallelepipedElement();
                ((GeometryElement)mm).load(elem);
                this.elements.put(mm.getId(), mm);
            }
            lst = this.doc.selectNodes("/map/features/geometry[type='Cylinder']");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new CylinderElement();
                ((GeometryElement)mm).load(elem);
                this.elements.put(mm.getId(), mm);
            }
            lst = this.doc.selectNodes("/map/features/geometry[type='Ellipsoid']");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new EllipsoidElement();
                ((GeometryElement)mm).load(elem);
                this.elements.put(mm.getId(), mm);
            }
            lst = this.doc.selectNodes("/map/features/path");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new PathElement();
                ((PathElement)mm).load(elem);
                this.elements.put(mm.getId(), mm);
            }
            lst = this.doc.selectNodes("/map/features/image");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                im = new ImageElement();
                ((ImageElement)im).setOriginalFilePath(this.originalFilePath);
                ((ImageElement)im).load(elem);
                this.elements.put(im.getId(), im);
            }
            lst = this.doc.selectNodes("/map/features/model3d");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                im = new Model3DElement();
                ((Model3DElement)im).setOriginalFilePath(this.originalFilePath);
                ((Model3DElement)im).load(elem);
                this.elements.put(im.getId(), im);
            }
            LinkedHashMap<String, Class<LineSegmentElement>> elementClasses = new LinkedHashMap<String, Class<LineSegmentElement>>();
            elementClasses.put("MineDangerAreaElement", MineDangerAreaElement.class);
            elementClasses.put("QRouteElement", QRouteElement.class);
            elementClasses.put("LineSegmentElement", LineSegmentElement.class);
            for (String name : elementClasses.keySet()) {
                lst = this.doc.selectNodes("/map/features/" + name);
                lstIt = lst.listIterator();
                while (lstIt.hasNext()) {
                    Element elem2 = (Element)lstIt.next();
                    AbstractElement el = (AbstractElement)((Class)elementClasses.get(name)).getConstructor(MapGroup.class, MapType.class).newInstance(null, null);
                    el.load(elem2);
                    this.elements.put(el.getId(), el);
                }
            }
            for (AbstractElement elem3 : this.elements.values()) {
                elem3.setMissionType(this.getMission());
                elem3.setMapGroup(this.getMapGroup());
                elem3.setParentMap(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isLoadOk = false;
            long totalTime = System.currentTimeMillis() - initTime;
            NeptusLog.pub().info((Object)(this + ": Total map load time: " + totalTime + " ms."));
            return false;
        }
        this.isLoadOk = true;
        this.setChanged(false);
        long totalTime = System.currentTimeMillis() - initTime;
        NeptusLog.pub().debug((Object)(this + ": Total map load time: " + totalTime + " ms."));
        return true;
    }

    @Override
    public boolean loadFile(String url) {
        this.setHref(url);
        this.originalFilePath = new File(url).getAbsolutePath();
        SAXReader reader = new SAXReader();
        try {
            this.doc = reader.read(url);
        }
        catch (DocumentException e) {
            NeptusLog.pub().error((Object)("loading map " + url), (Throwable)e);
        }
        return this.load();
    }

    @Override
    public boolean loadFile(File file) {
        return this.loadFile(file.getAbsolutePath());
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    public static boolean validate(Document doc) {
        NeptusLog.pub().info((Object)("<###>validating map: " + doc.toString()));
        NeptusLog.pub().info((Object)("<###>schema: " + ConfigFetch.getMapSchemaLocation()));
        try {
            String sLoc = new File(ConfigFetch.getMapSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(doc, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"Map:validate", (Throwable)e);
            return false;
        }
    }

    public static boolean validate(String xml) {
        try {
            String sLoc = new File(ConfigFetch.getMapSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(xml, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"Map:validate", (Throwable)e);
            return false;
        }
    }

    public static boolean validate(File file) {
        try {
            String xml = FileUtil.getFileAsString(file);
            return MapType.validate(xml);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"Map:validate", (Throwable)e);
            return false;
        }
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addComment(ConfigFetch.getSaveAsCommentForXML());
        Element header = root.addElement("header");
        header.addElement("id").addText(this.getId());
        header.addElement("name").addText(this.getName());
        header.addElement("type").addText(this.getType());
        if (!this.description.equalsIgnoreCase("")) {
            header.addElement("description").addText(this.getDescription());
        }
        if (this.notesList.size() != 0) {
            Element notes = header.addElement("notes");
            Iterator iter = this.notesList.iterator();
            while (iter.hasNext()) {
                notes.addElement("note").addText((String)iter.next());
            }
        }
        Element features = root.addElement("features");
        for (AbstractElement elem : this.elements.values()) {
            if (elem instanceof ImageElement) {
                ((ImageElement)elem).setOriginalFilePath(this.getHref());
            } else if (elem instanceof Model3DElement) {
                ((Model3DElement)elem).setOriginalFilePath(this.getHref());
            }
            features.add(elem.asElement());
        }
        return document;
    }

    public boolean showSaveDialog() {
        JFrame tmp = new JFrame();
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(ConfigFetch.getConfigFile()));
        fc.setFileView(new NeptusFileView());
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                try {
                    if (!f.exists() || !f.canRead()) {
                        return false;
                    }
                    if (f.getCanonicalPath().toLowerCase().endsWith("xml") || f.getCanonicalPath().toLowerCase().endsWith("nmap")) {
                        return true;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Neptus Mission Map files";
            }
        });
        fc.setDialogTitle("Choose file to save the map '" + this.getId() + "'...");
        int response = fc.showSaveDialog(tmp);
        if (response == 1) {
            return false;
        }
        String filename = fc.getSelectedFile().getAbsolutePath();
        String filenameNoCase = filename.toLowerCase();
        if (filenameNoCase.endsWith(".xml") || filenameNoCase.endsWith(".nmap")) {
            return this.saveFile(filename);
        }
        return this.saveFile(filename + ".nmap");
    }

    public boolean saveFile(String filename) {
        this.setHref(filename);
        boolean ret = FileUtil.saveToFile(filename, FileUtil.getAsPrettyPrintFormatedXMLString(this.asDocument()));
        if (!ret) {
            this.setHref(null);
            return false;
        }
        this.setChanged(false);
        NeptusLog.pub().info((Object)("The map '" + this.getId() + "' was saved to '" + this.getHref() + "'"));
        return true;
    }

    public LinkedHashMap<String, AbstractElement> getElements() {
        return this.elements;
    }

    public void setElements(LinkedHashMap<String, AbstractElement> elements) {
        this.elements = elements;
    }

    public LinkedList<AbstractElement> getAllElements() {
        LinkedList<AbstractElement> elems = new LinkedList<AbstractElement>();
        elems.addAll(this.elements.values());
        return elems;
    }

    public LinkedHashMap<String, TransponderElement> getTranspondersList() {
        LinkedHashMap<String, TransponderElement> transList = new LinkedHashMap<String, TransponderElement>();
        for (AbstractElement elem : this.elements.values()) {
            if (!elem.getType().equals("Transponder")) continue;
            transList.put(elem.getId(), (TransponderElement)elem);
        }
        return transList;
    }

    public LinkedHashMap<String, MarkElement> getMarksList() {
        LinkedHashMap<String, MarkElement> markList = new LinkedHashMap<String, MarkElement>();
        for (AbstractElement elem : this.elements.values()) {
            if (!elem.getType().equals("Mark")) continue;
            markList.put(elem.getId(), (MarkElement)elem);
        }
        return markList;
    }

    public String toString() {
        return this.getId();
    }

    public MapGroup getMapGroup() {
        return this.mapGroup;
    }

    public void setMapGroup(MapGroup mapGroup) {
        this.mapGroup = mapGroup;
    }

    public MissionType getMission() {
        return this.mission;
    }

    public void setMission(MissionType mission) {
        this.mission = mission;
    }
}

