/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.gui.objparams.MarkParameters;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

public class MarkElement
extends AbstractElement {
    MarkParameters params = null;

    public MarkElement() {
    }

    public MarkElement(String xml) {
        super(xml);
    }

    public MarkElement(MapGroup mg, MapType map) {
        super(mg, map);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    @Override
    public String getType() {
        return "Mark";
    }

    @Override
    public int getLayerPriority() {
        return 10;
    }

    public LocationType getPosition() {
        return this.getCenterLocation();
    }

    public void translate(double offsetNorth, double offsetEast, double offsetDown) {
        this.getCenterLocation().translatePosition(offsetNorth, offsetEast, offsetDown);
    }

    @Override
    public boolean containsPoint(LocationType lt, StateRenderer2D renderer) {
        double distance = this.getCenterLocation().getHorizontalDistanceInMeters(lt);
        if (renderer == null) {
            return distance < 5.0;
        }
        return distance * (double)renderer.getZoom() < 10.0;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        if (this.params == null) {
            this.params = new MarkParameters();
        }
        this.params.setLocation(this.getCenterLocation());
        this.params.setEditable(editable);
        return this.params;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        if (this.params == null) {
            this.params = new MarkParameters();
        }
        this.setCenterLocation(this.params.getLocationPanel().getLocationType());
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_MARK;
    }

    @Override
    public String getTypeAbbrev() {
        return "mark";
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(tt.getX(), tt.getY());
        if (!this.isSelected()) {
            g.setColor(new Color(255, 0, 0, 100));
        } else {
            g.setColor(Color.WHITE);
        }
        g.drawOval(-5, -5, 10, 10);
        if (!this.isSelected()) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.RED);
        }
        g.drawLine(-3, -3, 3, 3);
        g.drawLine(-3, 3, 3, -3);
        g.drawString(this.getId(), 6, 6);
    }
}

