/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.SimpleMapElement;

public class MineDangerAreaElement
extends SimpleMapElement {
    @NeptusProperty
    public double radius = 50.0;
    @NeptusProperty
    public Color color = Color.red;
    public boolean filled = true;

    public MineDangerAreaElement(MapGroup mg, MapType map) {
        super(mg, map);
    }

    public MineDangerAreaElement() {
    }

    @Override
    public String getTypeAbbrev() {
        return "mda";
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D pt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(pt.getX(), pt.getY());
        g.rotate(this.getYawRad() - renderer.getRotation());
        double widthScaled = this.radius * 2.0 * (double)renderer.getZoom();
        double lengthScaled = this.radius * 2.0 * (double)renderer.getZoom();
        Ellipse2D.Double tmp = new Ellipse2D.Double(-widthScaled / 2.0, -lengthScaled / 2.0, widthScaled, lengthScaled);
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        if (this.filled) {
            g.fill(tmp);
        }
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        g.setStroke(new BasicStroke(2.0f));
        g.draw(tmp);
        g.draw(new Line2D.Double(-6.0, 0.0, 6.0, 0.0));
        g.draw(new Line2D.Double(0.0, -6.0, 0.0, 6.0));
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        return point.getDistanceInMeters(this.getCenterLocation()) <= this.radius;
    }
}

