/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyEditor;
import java.io.File;
import javax.swing.JFileChooser;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ParametersSheetPanel;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.RotatableElement;
import pt.lsts.neptus.types.map.ScalableElement;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class Model3DElement
extends AbstractElement
implements ScalableElement,
RotatableElement,
PropertiesProvider {
    protected static final String DEFAULT_ROOT_ELEMENT = "model3d";
    private static final Image DEFAULT_MODEL3D_MARKER = ImageUtils.getImage("images/buttons/model3d.png");
    String image2DFilename = null;
    double image2DScale = 1.0;
    boolean image2DFixedSize = false;
    boolean has2DImage = false;
    String model3DFilename = null;
    double model3DScale = 1.0;
    protected String originalFilePath = "";
    private Image image2D = null;

    public Model3DElement() {
    }

    public Model3DElement(String xml) {
        this.load(xml);
    }

    public Model3DElement(String xml, String originalFilePath) {
        this.originalFilePath = originalFilePath;
        this.load(xml);
    }

    public Model3DElement(MapGroup mg, MapType map) {
        super(mg, map);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        if (this.image2DFilename == null) {
            double distance = this.getCenterLocation().getDistanceInMeters(point);
            return distance * (double)renderer.getZoom() < 10.0;
        }
        double[] diff = this.centerLocation.getOffsetFrom(point);
        double width = (double)this.image2D.getWidth(null) * this.image2DScale;
        double length = (double)this.image2D.getHeight(null) * this.image2DScale;
        double maxDiffX = width / 2.0;
        double maxDiffY = length / 2.0;
        return Math.abs(diff[1]) <= maxDiffX && Math.abs(diff[0]) <= maxDiffY;
    }

    @Override
    public int getLayerPriority() {
        return 0;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        return new ParametersSheetPanel((Property[])this.getProperties());
    }

    @Override
    public String getType() {
        return "Model3D";
    }

    public boolean isHas2DImage() {
        return this.has2DImage;
    }

    public void setHas2DImage(boolean has2DImage) {
        this.has2DImage = has2DImage;
    }

    public Image getImage2D() {
        return this.image2D;
    }

    public void setImage2D(Image image2D) {
        this.image2D = image2D;
    }

    public String getImage2DFilename() {
        return this.image2DFilename;
    }

    public void setImage2DFilename(String image2DFilename) {
        this.image2DFilename = image2DFilename;
    }

    public boolean isImage2DFixedSize() {
        return this.image2DFixedSize;
    }

    public void setImage2DFixedSize(boolean image2DFixedSize) {
        this.image2DFixedSize = image2DFixedSize;
    }

    public double getImage2DScale() {
        return this.image2DScale;
    }

    public void setImage2DScale(double image2DScale) {
        this.image2DScale = image2DScale;
    }

    public String getModel3DFilename() {
        return this.model3DFilename;
    }

    public void setModel3DFilename(String model3DFilename) {
        this.model3DFilename = model3DFilename;
    }

    public double getModel3DScale() {
        return this.model3DScale;
    }

    public void setModel3DScale(double model3DScale) {
        this.model3DScale = model3DScale;
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        this.setProperties(((ParametersSheetPanel)paramsPanel).getProperties());
    }

    @Override
    public void paint(Graphics2D g2, StateRenderer2D renderer, double rotation) {
        Graphics2D g = (Graphics2D)g2.create();
        if (this.image2DFilename == null) {
            this.image2D = null;
        }
        if (this.image2D == null && this.image2DFilename != null) {
            this.image2D = ImageUtils.getImage(this.image2DFilename);
        }
        if (this.image2D != null) {
            if (this.image2DFixedSize || this.image2DScale == 0.0) {
                Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
                double tx = tt.getX();
                double ty = tt.getY();
                g.translate(tx, ty);
                g.rotate(-rotation);
                g.drawImage(this.image2D, -this.image2D.getWidth(null) / 2, -this.image2D.getHeight(null) / 2, null);
            } else {
                double zoom = renderer.getZoom();
                AffineTransform oldTransform = g.getTransform();
                Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
                double tx = tt.getX();
                double ty = tt.getY();
                g.translate(tx, ty);
                g.rotate(-this.getYawRad());
                g.translate(-this.image2DScale * (double)this.image2D.getWidth(null) / 2.0 * zoom, this.image2DScale * (double)this.image2D.getHeight(null) / 2.0 * zoom);
                g.scale(this.image2DScale * zoom, -this.image2DScale * zoom);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g.drawImage(this.image2D, 0, 0, null);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setTransform(oldTransform);
            }
        } else {
            Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
            double tx = tt.getX() - (double)(renderer.getWidth() / 2);
            double ty = -tt.getY() + (double)(renderer.getHeight() / 2);
            g.translate(tx, ty);
            g.scale(1.0, -1.0);
            g.rotate(-rotation);
            g.setColor(new Color(255, 255, 255, 100));
            g.fillOval(-5, -5, 10, 10);
            if (!this.isSelected()) {
                g.setColor(new Color(255, 0, 0, 100));
            } else {
                g.setColor(Color.WHITE);
            }
            g.drawOval(-5, -5, 10, 10);
            g.setColor(Color.RED);
            g.drawString("3D", -6, 6);
            g.setColor(Color.BLACK);
            g.drawString(this.getId(), 6, 6);
            g.rotate(rotation);
            g.scale(1.0, -1.0);
            g.translate(-tx, -ty);
        }
        g.dispose();
    }

    @Override
    public boolean load(Element elem) {
        if (!super.load(elem)) {
            return false;
        }
        try {
            Node nd = this.doc.selectSingleNode("//href");
            if (nd != null) {
                this.model3DFilename = "".equals(this.originalFilePath) ? nd.getText() : ConfigFetch.resolvePathWithParent(this.originalFilePath, nd.getText());
            }
            this.model3DScale = (nd = this.doc.selectSingleNode("//scale")) == null ? 1.0 : Double.parseDouble(nd.getText());
            nd = this.doc.selectSingleNode("//href-2d");
            if (nd != null && !nd.equals("")) {
                this.image2DFilename = "".equals(this.originalFilePath) ? nd.getText() : ConfigFetch.resolvePathWithParent(this.originalFilePath, nd.getText());
                this.image2D = ImageUtils.getImage(this.image2DFilename);
                this.setHas2DImage(true);
            } else {
                this.image2DFilename = null;
                this.image2D = DEFAULT_MODEL3D_MARKER;
                this.image2DFixedSize = true;
                this.setHas2DImage(false);
            }
            nd = this.doc.selectSingleNode("//scale-2d");
            this.image2DScale = nd == null ? 1.0 : Double.parseDouble(nd.getText());
            nd = this.doc.selectSingleNode("//fixed-size");
            this.image2DFixedSize = nd == null ? false : Boolean.parseBoolean(nd.getText());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
        this.isLoadOk = true;
        return true;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = (Element)super.asDocument(DEFAULT_ROOT_ELEMENT).getRootElement().detach();
        document.add(root);
        if ("".equals(this.originalFilePath)) {
            root.addElement("href").addText(this.getModel3DFilename());
            NeptusLog.pub().error((Object)(this + ": Original file path is empty!"));
        } else {
            root.addElement("href").addText(FileUtil.relativizeFilePathAsURI(this.getOriginalFilePath(), this.getModel3DFilename()));
        }
        root.addElement("scale").addText(Double.toString(this.getModel3DScale()));
        if (this.isHas2DImage()) {
            if ("".equals(this.originalFilePath)) {
                if (this.getImage2DFilename() != null) {
                    root.addElement("href-2d").addText(this.getImage2DFilename());
                } else {
                    root.addElement("href-2d").addText("");
                }
                NeptusLog.pub().error((Object)(this + ": Original file path is empty!"));
            } else {
                root.addElement("href-2d").addText(FileUtil.relativizeFilePathAsURI(this.getOriginalFilePath(), this.getImage2DFilename()));
            }
            root.addElement("scale-2d").addText(Double.toString(this.getImage2DScale()));
            root.addElement("fixed-size").addText(Boolean.toString(this.isImage2DFixedSize()));
        }
        return document;
    }

    @Override
    public DefaultProperty[] getProperties() {
        DefaultProperty center = PropertiesEditor.getPropertyInstance("Position", "Map", LocationType.class, this.getCenterLocation(), true);
        DefaultProperty model3d = this.getModel3DFilename() != null ? PropertiesEditor.getPropertyInstance("3D Model file", "3D", File.class, new File(this.getModel3DFilename()), true) : PropertiesEditor.getPropertyInstance("3D Model file", "3D", File.class, null, true);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)model3d, (PropertyEditor)new FilePropertyEditor(){

            protected void customizeFileChooser(JFileChooser jfc) {
                File fx;
                if (Model3DElement.this.getModel3DFilename() != null && new File(Model3DElement.this.getModel3DFilename()).exists()) {
                    fx = new File(Model3DElement.this.getModel3DFilename());
                } else if (Model3DElement.this.getImage2DFilename() != null && new File(Model3DElement.this.getImage2DFilename()).exists()) {
                    fx = new File(Model3DElement.this.getImage2DFilename());
                } else {
                    fx = new File(ConfigFetch.getConfigFile());
                    if (!fx.exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                        fx = new File(".");
                    }
                }
                jfc.setCurrentDirectory(fx);
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("3DS Models", "3ds"));
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("X3D Models", "x3d"));
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("WRL Models", "wrl"));
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("All Models", "3ds", "x3d", "wrl"));
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setFileView(new NeptusFileView());
            }
        });
        DefaultProperty scale = PropertiesEditor.getPropertyInstance("3D Model Scale", "3D", Double.class, this.model3DScale, true);
        DefaultProperty image2d = this.getImage2DFilename() != null ? PropertiesEditor.getPropertyInstance("2D Image file", "2D", File.class, new File(this.getImage2DFilename()), true) : PropertiesEditor.getPropertyInstance("2D Image file", "2D", File.class, null, true);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)image2d, (PropertyEditor)new FilePropertyEditor(){

            protected void customizeFileChooser(JFileChooser jfc) {
                File fx;
                if (Model3DElement.this.getImage2DFilename() != null && new File(Model3DElement.this.getImage2DFilename()).exists()) {
                    fx = new File(Model3DElement.this.getImage2DFilename());
                } else if (Model3DElement.this.getModel3DFilename() != null && new File(Model3DElement.this.getModel3DFilename()).exists()) {
                    fx = new File(Model3DElement.this.getModel3DFilename());
                } else {
                    fx = new File(ConfigFetch.getConfigFile());
                    if (!fx.exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                        fx = new File(".");
                    }
                }
                jfc.setCurrentDirectory(fx);
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("PNG Images", "png"));
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("JPG Images", "jpg"));
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("GIF Images", "gif"));
                jfc.addChoosableFileFilter(GuiUtils.getCustomFileFilter("All Images", "png", "jpg", "gif"));
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setFileView(new NeptusFileView());
            }
        });
        DefaultProperty scale2D = PropertiesEditor.getPropertyInstance("2D Image scale", "2D", Double.class, this.image2DScale, true);
        DefaultProperty roll = PropertiesEditor.getPropertyInstance("Roll", "Attitude", Double.class, this.getRollDeg(), true);
        DefaultProperty pitch = PropertiesEditor.getPropertyInstance("Pitch", "Attitude", Double.class, this.getPitchDeg(), true);
        DefaultProperty yaw = PropertiesEditor.getPropertyInstance("Yaw", "Attitude", Double.class, this.getYawDeg(), true);
        return new DefaultProperty[]{center, model3d, scale, image2d, scale2D, roll, pitch, yaw};
    }

    @Override
    public String getPropertiesDialogTitle() {
        return "3D Model Properties";
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            if (p.getName().equals("Position")) {
                this.setCenterLocation((LocationType)p.getValue());
            }
            if (p.getName().equals("3D Model file")) {
                if (p.getValue() != null) {
                    this.setModel3DFilename(((File)p.getValue()).getAbsolutePath());
                } else {
                    this.setModel3DFilename(new File("models/transp.3sd").getAbsolutePath());
                }
            }
            if (p.getName().equals("2D Image file")) {
                if (p.getValue() != null) {
                    this.setImage2DFilename(((File)p.getValue()).getAbsolutePath());
                    this.setHas2DImage(true);
                } else {
                    this.setImage2DFilename(null);
                    this.setHas2DImage(true);
                }
            }
            if (p.getName().equals("2D Image scale")) {
                this.image2DScale = (Double)p.getValue();
            }
            if (p.getName().equals("3D Model Scale")) {
                this.model3DScale = (Double)p.getValue();
            }
            if (p.getName().equals("Roll")) {
                this.setRollDeg((Double)p.getValue());
            }
            if (p.getName().equals("Pitch")) {
                this.setPitchDeg((Double)p.getValue());
            }
            if (!p.getName().equals("Yaw")) continue;
            this.setYawDeg((Double)p.getValue());
        }
    }

    @Override
    public double getYaw() {
        return super.getYaw();
    }

    @Override
    public void rotateLeft(double ammount) {
        this.setYawDeg(this.getYawDeg() - ammount);
    }

    @Override
    public void rotateRight(double ammount) {
        this.setYawDeg(this.getYawDeg() + ammount);
    }

    @Override
    public double[] getDimension() {
        return new double[]{this.model3DScale, this.model3DScale, this.model3DScale};
    }

    @Override
    public void grow(double ammount) {
        this.model3DScale *= 1.1;
        this.image2DScale *= 1.1;
    }

    @Override
    public void setDimension(double[] newDimension) {
        this.model3DScale = newDimension[0];
        this.image2DScale = newDimension[0];
    }

    @Override
    public void shrink(double ammount) {
        this.model3DScale *= 0.9090909090909091;
        this.image2DScale *= 0.9090909090909091;
        this.model3DScale = Math.max(0.001, this.model3DScale);
        this.image2DScale = Math.max(0.001, this.image2DScale);
    }

    @Override
    public String getTypeAbbrev() {
        return "m3d";
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.MODEL_3D;
    }
}

