/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.swing.JFrame;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.GeometryElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

public class ParallelepipedElement
extends GeometryElement {
    @Override
    public String getType() {
        return "Parallelepiped";
    }

    public ParallelepipedElement(MapGroup mg, MapType parentMap) {
        super(mg, parentMap);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    public ParallelepipedElement() {
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_PARALLELEPIPED;
    }

    @Override
    public String getTypeAbbrev() {
        return "pp";
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D pt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(pt.getX(), pt.getY());
        g.rotate(this.getYawRad() - renderer.getRotation());
        double widthScaled = this.width * (double)renderer.getZoom();
        double lengthScaled = this.length * (double)renderer.getZoom();
        Rectangle2D.Double tmp = new Rectangle2D.Double(-widthScaled / 2.0, -lengthScaled / 2.0, widthScaled, lengthScaled);
        if (this.isSelected()) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        } else {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (this.isFilled()) {
            g.fill(tmp);
        }
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        g.draw(tmp);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Box and Sphere");
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(config);
        canvas.setSize(400, 400);
        SimpleUniverse universe = new SimpleUniverse(canvas);
        universe.getViewingPlatform().setNominalViewingTransform();
        BranchGroup group = new BranchGroup();
        group.setCapability(14);
        universe.addBranchGraph(group);
        frame.setSize(500, 400);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)canvas, "Center");
        frame.setVisible(true);
        Sphere sphere = new Sphere(1.1f, 3, null);
        BranchGroup b = new BranchGroup();
        b.addChild((Node)sphere);
        group.addChild((Node)b);
        Sphere sphere2 = new Sphere(1.0f, 3, null);
        b = new BranchGroup();
        b.addChild((Node)sphere2);
        Util3D.enablePicking((Node)b);
        group.addChild((Node)b);
    }
}

