/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.objparams.DrawingParameters;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ReflectionUtil;

public class PathElement
extends AbstractElement {
    protected static final String DEFAULT_ROOT_ELEMENT = "path";
    protected Vector<Point3d> offsets3D = new Vector();
    private final GeneralPath myPath;
    private GeneralPath scaledPath = null;
    private final DrawingParameters params = new DrawingParameters();
    private boolean finished = false;
    protected Color myColor = this.params.getColor();
    private final LocationType tmp = new LocationType();
    private Point2D nextPoint = null;
    private double[] bounds3d = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
    public static final int SOUTH_COORD = 0;
    public static final int NORTH_COORD = 1;
    public static final int DOWN_COORD = 2;
    public static final int UP_COORD = 3;
    public static final int WEST_COORD = 4;
    public static final int EAST_COORD = 5;
    private Stroke stroke = new BasicStroke(1.0f);
    private boolean isShape = false;
    private boolean fill = true;
    boolean firstPoint = true;

    public PathElement() {
        this.myPath = new GeneralPath();
    }

    public PathElement(String xml) {
        this.myPath = new GeneralPath();
        this.load(xml);
    }

    public PathElement(MapGroup mg, MapType parentMap, double realX, double realY) {
        super(mg, parentMap);
        LocationType lt = new LocationType();
        lt.setOffsetEast(realX);
        lt.setOffsetNorth(realY);
        this.setCenterLocation(lt);
        this.myPath = new GeneralPath();
    }

    public PathElement(MapGroup mg, MapType parentMap, LocationType firstPoint) {
        super(mg, parentMap);
        this.setCenterLocation(firstPoint);
        this.myPath = new GeneralPath();
        this.myPath.moveTo(0.0f, 0.0f);
    }

    @Override
    public boolean load(Element elem) {
        this.offsets3D.clear();
        super.load(elem);
        this.addPoint(0.0, 0.0, 0.0, false);
        boolean lastPointIsZero = true;
        try {
            Node nd2;
            List lst = this.doc.selectNodes("//translation");
            for (Node nd2 : lst) {
                String vlx = nd2.selectSingleNode("n").getText();
                double x = Double.parseDouble(vlx);
                String vly = nd2.selectSingleNode("e").getText();
                double y = Double.parseDouble(vly);
                String vlz = nd2.selectSingleNode("d").getText();
                double z = Double.parseDouble(vlz);
                if (lastPointIsZero) {
                    if (x == 0.0 && y == 0.0 && z == 0.0) continue;
                    lastPointIsZero = false;
                }
                this.addPoint(y, x, z, false);
            }
            nd2 = this.doc.selectSingleNode("//color");
            if (nd2 != null) {
                String rS = nd2.selectSingleNode("r").getText();
                String gS = nd2.selectSingleNode("g").getText();
                String bS = nd2.selectSingleNode("b").getText();
                int rr = Integer.parseInt(rS);
                int gg = Integer.parseInt(gS);
                int bb = Integer.parseInt(bS);
                this.setMyColor(new Color(rr, gg, bb));
            } else {
                NeptusLog.pub().info((Object)"<###>Didn't found color!!");
            }
            nd2 = this.doc.selectSingleNode("//filled");
            if (nd2 != null) {
                this.isShape = nd2.getText().equalsIgnoreCase("true");
            } else {
                NeptusLog.pub().info((Object)"<###>Unable to find filled tag (defaulting to false)!!");
            }
            this.setFinished(true);
        }
        catch (Exception e) {
            GuiUtils.errorMessage(null, e);
            NeptusLog.pub().error((Object)(this + ":XML not recognized!!!"));
            this.isLoadOk = false;
            return false;
        }
        this.isLoadOk = true;
        return true;
    }

    @Override
    public String getType() {
        return "Path";
    }

    public Vector<Point3d> getPoints() {
        return this.offsets3D;
    }

    public void setPoints(Vector<Point3d> newPoints) {
        this.offsets3D.clear();
        for (Point3d pt : newPoints) {
            LocationType lt = new LocationType();
            lt.setLocation(this.getCenterLocation());
            this.addPoint(pt.y, pt.x, pt.z, false);
        }
    }

    public Color getMyColor() {
        return this.myColor;
    }

    public void setMyColor(Color myColor) {
        this.myColor = myColor;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = (Element)super.asDocument(DEFAULT_ROOT_ELEMENT).getRootElement().detach();
        document.add(root);
        Element typeE = root.addElement("filled");
        typeE.setText(this.isShape ? "true" : "false");
        if (this.getMyColor() != null) {
            Element colorE = root.addElement("color");
            colorE.addElement("r").setText(Integer.toString(this.getMyColor().getRed()));
            colorE.addElement("g").setText(Integer.toString(this.getMyColor().getGreen()));
            colorE.addElement("b").setText(Integer.toString(this.getMyColor().getBlue()));
        } else {
            NeptusLog.pub().info((Object)("<###>Getmycolor = null (" + this.getId() + ")"));
        }
        if (this.offsets3D.size() == 0) {
            this.offsets3D.add(new Point3d(0.0, 0.0, 0.0));
        }
        for (Point3d pt : this.offsets3D) {
            Element transl = root.addElement("translation");
            transl.addElement("n").addText(Double.toString(pt.x));
            transl.addElement("e").addText(Double.toString(pt.y));
            transl.addElement("d").addText(Double.toString(pt.z));
        }
        return document;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
        if (finished && this.nextPoint != null) {
            this.tmp.setOffsetEast(this.nextPoint.getX());
            this.tmp.setOffsetNorth(this.nextPoint.getY());
            this.nextPoint = null;
        }
    }

    public Point2D getNextPoint() {
        return this.nextPoint;
    }

    public void setNextPoint(Point2D nextPoint) {
        this.nextPoint = nextPoint;
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        double[] offsets = point.getOffsetFrom(this.getCenterLocation());
        Point2D.Double pt = new Point2D.Double(offsets[1], -offsets[0]);
        return this.myPath.contains(pt);
    }

    @Override
    public int getLayerPriority() {
        return 5;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        this.params.getShapeCheck().setSelected(this.isShape);
        this.params.getColorField().setBackground(this.getMyColor());
        this.params.setEditable(editable);
        return this.params;
    }

    public boolean paramsOK(JPanel paramsPanel) {
        return true;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        this.myColor = this.params.getColor();
        this.isShape = this.params.getShapeCheck().isSelected();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        double zoom = renderer.getZoom();
        Color c = this.myColor;
        if (!this.isFinished() || this.isSelected()) {
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        } else {
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 175));
        }
        Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
        g.drawLine((int)tt.getX(), (int)tt.getY(), (int)tt.getX(), (int)tt.getY());
        if (this.nextPoint != null) {
            this.scaledPath = (GeneralPath)this.myPath.clone();
            this.tmp.setOffsetEast(this.nextPoint.getX());
            this.tmp.setOffsetNorth(this.nextPoint.getY());
        } else {
            this.scaledPath = (GeneralPath)this.myPath.clone();
            if (this.isShape) {
                this.scaledPath.lineTo(0.0f, 0.0f);
            }
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(tt.getX(), tt.getY());
        transform.scale(zoom, zoom);
        transform.rotate(-renderer.getRotation());
        this.scaledPath.transform(transform);
        g.setStroke(this.stroke);
        g.draw(this.scaledPath);
        if (this.isShape && this.isFill()) {
            g.setColor(new Color(this.myColor.getRed(), this.myColor.getGreen(), this.myColor.getBlue(), 100));
            g.fill(this.scaledPath);
        }
    }

    public void addPoint(double eastOffset, double northOffset, double depthOffset, boolean absolute) {
        if (eastOffset < this.bounds3d[4]) {
            this.bounds3d[4] = eastOffset;
        }
        if (eastOffset > this.bounds3d[5]) {
            this.bounds3d[5] = eastOffset;
        }
        if (northOffset < this.bounds3d[0]) {
            this.bounds3d[0] = northOffset;
        }
        if (northOffset > this.bounds3d[1]) {
            this.bounds3d[1] = northOffset;
        }
        if (depthOffset < this.bounds3d[2]) {
            this.bounds3d[2] = depthOffset;
        }
        if (depthOffset > this.bounds3d[3]) {
            this.bounds3d[3] = depthOffset;
        }
        if (!absolute) {
            if (!this.firstPoint) {
                this.myPath.lineTo((float)eastOffset, -((float)northOffset));
            } else {
                this.firstPoint = false;
                this.myPath.moveTo((float)eastOffset, -((float)northOffset));
            }
            this.offsets3D.add(new Point3d(northOffset, eastOffset, depthOffset));
        } else {
            NeptusLog.pub().info((Object)("<###>add point absolute!: " + ReflectionUtil.getCallerStamp()));
            this.tmp.setOffsetEast(eastOffset);
            this.tmp.setOffsetNorth(northOffset);
            double[] offsets = this.tmp.getOffsetFrom(this.getCenterLocation());
            if (!this.firstPoint) {
                this.myPath.lineTo((float)offsets[1], (float)offsets[0]);
            } else {
                this.firstPoint = false;
                this.myPath.moveTo((float)offsets[1], (float)offsets[0]);
            }
            this.offsets3D.add(new Point3d(offsets[0], offsets[1], offsets[2]));
        }
    }

    public Point3d[] getPath() {
        Vector<Point3d> points = this.offsets3D;
        if (points == null || points.size() <= 1) {
            return new Point3d[0];
        }
        Point3d[] pts = new Point3d[points.size() * 2 - 2];
        int i = 1;
        int x = 1;
        pts[0] = points.firstElement();
        while (i < points.size() - 1) {
            pts[x] = points.get(i);
            pts[++x] = points.get(i);
            ++i;
            ++x;
        }
        pts[pts.length - 1] = points.get(points.size() - 1);
        return pts;
    }

    public double[] getBounds3d() {
        return this.bounds3d;
    }

    public void setBounds3d(double[] bounds3d) {
        this.bounds3d = bounds3d;
    }

    public LocationType getCenterPoint() {
        LocationType lt = new LocationType(this.getCenterLocation());
        lt.translatePosition((this.bounds3d[1] + this.bounds3d[0]) / 2.0, (this.bounds3d[5] + this.bounds3d[4]) / 2.0, (this.bounds3d[3] + this.bounds3d[2]) / 2.0);
        return lt;
    }

    @Override
    public Vector<LocationType> getShapePoints() {
        if (!this.isShape) {
            return super.getShapePoints();
        }
        Vector<LocationType> ret = new Vector<LocationType>();
        LocationType lt = new LocationType(this.getCenterLocation());
        ret.add(lt);
        Vector<Point3d> myPts = this.getPoints();
        for (Point3d pt : myPts) {
            LocationType tmp = new LocationType(lt);
            tmp.translatePosition(pt.x, pt.y, pt.z);
            ret.add(tmp);
        }
        return ret;
    }

    public boolean isShape() {
        return this.isShape;
    }

    public void setShape(boolean isShape) {
        this.isShape = isShape;
    }

    public boolean isFill() {
        return this.fill;
    }

    @Override
    public String getTypeAbbrev() {
        return DEFAULT_ROOT_ELEMENT;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_PATH;
    }
}

