/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.vecmath.Point3d;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

@LayerPriority(priority=50)
public class PlanElement
extends AbstractElement
implements Renderer2DPainter,
PreferencesListener {
    private PlanType plan = null;
    private static GeneralPath arrow1 = new GeneralPath();
    private static GeneralPath arrow2 = new GeneralPath();
    private StateRenderer2D renderer = null;
    private boolean showDistances = true;
    private boolean showManNames = true;
    private boolean showVelocities = false;
    private boolean saveAsTrajectory = false;
    private double lastRendererZoom = 1.0;
    private double lastRotationAngle = 0.0;
    private double transp2d = 0.7;
    private Point2D lastRendererCenter = new Point2D.Double();
    private LinkedHashMap<String, Point2D> maneuverLocations = new LinkedHashMap();
    private LinkedHashMap<String, Point2D> startManeuverLocations = new LinkedHashMap();
    private LinkedHashMap<String, Point2D> endManeuverLocations = new LinkedHashMap();
    private Color color = GeneralPreferences.rendererPlanColor;
    private String selectedManeuver = null;
    private String activeManeuver = null;
    private int snapPixels = 5;
    private JLabel lbl = new JLabel();
    private boolean beingEdited = false;
    protected LinkedHashMap<String, DefaultProperty> lastSetProperties = new LinkedHashMap();
    private LocationType center = new LocationType();

    public PlanElement() {
    }

    public PlanElement(MapGroup mg, MapType map) {
        super(mg, map);
        this.lbl.setBackground(new Color(255, 200, 200, 75));
        this.lbl.setBorder(BorderFactory.createLineBorder(new Color(255, 100, 100, 150)));
        this.lbl.setOpaque(true);
        this.lbl.setBounds(0, 0, 0, 0);
        GeneralPreferences.addPreferencesListener(this);
    }

    protected void finalize() throws Throwable {
        GeneralPreferences.removePreferencesListener(this);
        super.finalize();
    }

    @Override
    public String getType() {
        return "Plan";
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.transp2d < 1.0) {
            g.setComposite(AlphaComposite.getInstance(3, (float)this.transp2d));
            this.paint(g, renderer, renderer.getRotation());
            g.setComposite(AlphaComposite.SrcOver);
        } else {
            this.paint(g, renderer, renderer.getRotation());
        }
    }

    public Point2D translateManeuverPosition(String maneuverID, double transX, double transY) {
        Point2D loc = this.maneuverLocations.get(maneuverID);
        loc.setLocation(loc.getX() + transX, loc.getY() + transY);
        Point2D locS = this.startManeuverLocations.get(maneuverID);
        locS.setLocation(locS.getX() + transX, locS.getY() + transY);
        Point2D locE = this.endManeuverLocations.get(maneuverID);
        locE.setLocation(locE.getX() + transX, locE.getY() + transY);
        Point2D nearerX = new Point2D.Double(0.0, 0.0);
        Point2D nearerY = new Point2D.Double(0.0, 0.0);
        double distX = 2.147483647E9;
        double distY = 2.147483647E9;
        Point2D homePt = this.renderer.getScreenPosition(this.renderer.getMapGroup().getHomeRef().getCenterLocation());
        double dx = Math.abs(homePt.getX() - loc.getX());
        double dy = Math.abs(homePt.getY() - loc.getY());
        double dxS = locS.getX() - loc.getX();
        double dyS = locS.getY() - loc.getY();
        double dxE = locE.getX() - loc.getX();
        double dyE = locE.getY() - loc.getY();
        if (dx < distX) {
            distX = dx;
            nearerX = homePt;
        }
        if (dy < distY) {
            distY = dy;
            nearerY = homePt;
        }
        for (String s : this.maneuverLocations.keySet()) {
            Point2D otherP = this.maneuverLocations.get(s);
            if (s.equals(maneuverID) || !(this.plan.getGraph().getManeuver(s) instanceof LocatedManeuver)) continue;
            dx = Math.abs(otherP.getX() - loc.getX());
            dy = Math.abs(otherP.getY() - loc.getY());
            if (dx < distX) {
                distX = dx;
                nearerX = otherP;
            }
            if (!(dy < distY)) continue;
            distY = dy;
            nearerY = otherP;
        }
        if (distX <= 5.0) {
            loc.setLocation(nearerX.getX(), loc.getY());
        }
        if (distY <= 5.0) {
            loc.setLocation(loc.getX(), nearerY.getY());
        }
        this.maneuverLocations.put(maneuverID, loc);
        Point2D.Double ls = new Point2D.Double(loc.getX() + dxS, loc.getY() + dyS);
        this.startManeuverLocations.put(maneuverID, ls);
        ls = new Point2D.Double(loc.getX() + dxE, loc.getY() + dyE);
        this.endManeuverLocations.put(maneuverID, ls);
        return loc;
    }

    public void recalculateManeuverPositions(StateRenderer2D renderer) {
        this.maneuverLocations.clear();
        this.startManeuverLocations.clear();
        this.endManeuverLocations.clear();
        if (this.plan == null) {
            return;
        }
        LinkedList<Maneuver> unknownLocs = new LinkedList<Maneuver>();
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            if (m instanceof LocatedManeuver) {
                LocationType lt = new LocationType(((LocatedManeuver)((Object)m)).getManeuverLocation());
                this.maneuverLocations.put(m.getId(), renderer.getScreenPosition(lt));
                lt = new LocationType(((LocatedManeuver)((Object)m)).getStartLocation());
                this.startManeuverLocations.put(m.getId(), renderer.getScreenPosition(lt));
                lt = new LocationType(((LocatedManeuver)((Object)m)).getEndLocation());
                this.endManeuverLocations.put(m.getId(), renderer.getScreenPosition(lt));
                continue;
            }
            this.maneuverLocations.remove(m.getId());
            this.startManeuverLocations.remove(m.getId());
            this.endManeuverLocations.remove(m.getId());
            unknownLocs.add(m);
        }
        for (Maneuver m : unknownLocs) {
            Point2D vpoint = this.calculateManeuverPositionWorker(m, renderer);
            Point2D.Double ptM = new Point2D.Double();
            ptM.setLocation(vpoint);
            this.maneuverLocations.put(m.getId(), ptM);
            Point2D.Double ptS = new Point2D.Double();
            ptS.setLocation(vpoint);
            this.startManeuverLocations.put(m.getId(), ptS);
            Point2D.Double ptE = new Point2D.Double();
            ptE.setLocation(vpoint);
            this.endManeuverLocations.put(m.getId(), ptE);
        }
    }

    private Point2D calculateManeuverPositionWorker(Maneuver m, StateRenderer2D renderer) {
        Maneuver previousMan;
        if (this.maneuverLocations.containsKey(m.getId())) {
            return this.maneuverLocations.get(m.getId());
        }
        Maneuver[] previousMans = this.plan.getGraph().getPreviousManeuvers(m.getId());
        Maneuver maneuver = previousMan = previousMans.length > 0 ? previousMans[0] : null;
        if (previousMan == null) {
            Point2D pt = renderer.getScreenPosition(new LocationType(this.plan.getMissionType().getHomeRef()));
            this.maneuverLocations.put(m.getId(), pt);
            return pt;
        }
        Point2D.Double pt = new Point2D.Double();
        pt.setLocation(this.calculateManeuverPositionWorker(previousMan, renderer));
        double angle = 0.0;
        Maneuver tmp = m;
        while (tmp != null && !(tmp instanceof LocatedManeuver)) {
            tmp = this.plan.getGraph().getFollowingManeuver(tmp.getId());
        }
        if (tmp != null) {
            Point2D otherPoint = this.maneuverLocations.get(tmp.getId());
            angle = Math.atan2(otherPoint.getY() - ((Point2D)pt).getY(), otherPoint.getX() - ((Point2D)pt).getX());
        }
        ((Point2D)pt).setLocation(((Point2D)pt).getX() + Math.cos(angle) * 50.0, ((Point2D)pt).getY() + Math.sin(angle) * 50.0);
        this.maneuverLocations.put(m.getId(), pt);
        return pt;
    }

    public Maneuver[] getAllInterceptedManeuvers(Point2D pt) {
        Vector<Maneuver> mans = new Vector<Maneuver>();
        double rad = 10.0;
        for (String manId : this.maneuverLocations.keySet()) {
            if (!(this.maneuverLocations.get(manId).distance(pt) < rad)) continue;
            mans.add(this.plan.getGraph().getManeuver(manId));
        }
        return mans.toArray(new Maneuver[0]);
    }

    public Maneuver iterateManeuverBack(Point2D pt) {
        double rad = 10.0;
        Vector<String> interceptedManeuvers = new Vector<String>();
        for (String manId : this.maneuverLocations.keySet()) {
            if (!(this.maneuverLocations.get(manId).distance(pt) < rad)) continue;
            interceptedManeuvers.add(manId);
        }
        if (interceptedManeuvers.size() == 0) {
            this.selectedManeuver = null;
            return null;
        }
        if (!interceptedManeuvers.contains(this.selectedManeuver)) {
            this.selectedManeuver = (String)interceptedManeuvers.firstElement();
            return this.plan.getGraph().getManeuver(this.selectedManeuver);
        }
        int index = interceptedManeuvers.indexOf(this.selectedManeuver);
        if (--index < 0) {
            index = interceptedManeuvers.size() - 1;
        }
        this.selectedManeuver = (String)interceptedManeuvers.get(index);
        return this.plan.getGraph().getManeuver(this.selectedManeuver);
    }

    public String[] getManeuversUnder(Point2D pt) {
        double rad = 10.0;
        Vector<String> interceptedManeuvers = new Vector<String>();
        for (String manId : this.maneuverLocations.keySet()) {
            if (!(this.maneuverLocations.get(manId).distance(pt) < rad) || this.plan.getGraph().getManeuver(manId) == null) continue;
            interceptedManeuvers.add(manId);
        }
        return interceptedManeuvers.toArray(new String[0]);
    }

    public Maneuver iterateManeuverUnder(Point2D pt) {
        double rad = 10.0;
        Vector<String> interceptedManeuvers = new Vector<String>();
        for (String manId : this.maneuverLocations.keySet()) {
            if (!(this.maneuverLocations.get(manId).distance(pt) < rad)) continue;
            interceptedManeuvers.add(manId);
        }
        if (interceptedManeuvers.size() == 0) {
            this.selectedManeuver = null;
            return null;
        }
        if (!interceptedManeuvers.contains(this.selectedManeuver)) {
            this.selectedManeuver = (String)interceptedManeuvers.firstElement();
            return this.plan.getGraph().getManeuver(this.selectedManeuver);
        }
        int index = interceptedManeuvers.indexOf(this.selectedManeuver);
        if (++index >= interceptedManeuvers.size()) {
            index = 0;
        }
        this.selectedManeuver = (String)interceptedManeuvers.get(index);
        return this.plan.getGraph().getManeuver(this.selectedManeuver);
    }

    public Maneuver getFirstInterceptedManeuver(Point2D pt) {
        double rad = 10.0;
        for (String manId : this.maneuverLocations.keySet()) {
            if (!(this.maneuverLocations.get(manId).distance(pt) < rad)) continue;
            return this.plan.getGraph().getManeuver(manId);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        if (this.getPlan() == null) {
            return;
        }
        boolean recalculatePositions = true;
        if ((double)renderer.getZoom() == this.lastRendererZoom && this.lastRendererCenter != null && renderer.getRotation() == 0.0) {
            Point2D curCenter = renderer.getScreenPosition(new LocationType(this.plan.getMissionType().getHomeRef()));
            if (!curCenter.equals(this.lastRendererCenter)) {
                Point2D pt;
                double diffX = curCenter.getX() - this.lastRendererCenter.getX();
                double diffY = curCenter.getY() - this.lastRendererCenter.getY();
                for (String key : this.maneuverLocations.keySet()) {
                    pt = this.maneuverLocations.get(key);
                    pt.setLocation(pt.getX() + diffX, pt.getY() + diffY);
                }
                for (String key : this.startManeuverLocations.keySet()) {
                    pt = this.startManeuverLocations.get(key);
                    pt.setLocation(pt.getX() + diffX, pt.getY() + diffY);
                }
                for (String key : this.endManeuverLocations.keySet()) {
                    pt = this.endManeuverLocations.get(key);
                    pt.setLocation(pt.getX() + diffX, pt.getY() + diffY);
                }
            }
            recalculatePositions = false;
        }
        if (recalculatePositions || renderer.getRotation() != this.lastRotationAngle) {
            this.recalculateManeuverPositions(renderer);
        }
        if (renderer == null || this.plan.getMissionType() == null) {
            return;
        }
        this.lastRendererCenter = renderer.getScreenPosition(new LocationType(this.plan.getMissionType().getHomeRef()));
        this.lastRendererZoom = renderer.getZoom();
        this.lastRotationAngle = renderer.getRotation();
        Maneuver[] maneuvers = this.getPlan().getGraph().getAllManeuvers();
        LocationType start = null;
        if (this.getPlan().getStartMode() == 0) {
            start = new LocationType(this.getMapGroup().getCoordinateSystem());
        }
        if (this.getPlan().getStartMode() == 1) {
            start = this.getPlan().getMapGroup().getMapObjectsByID("start").length > 0 ? new LocationType(this.getPlan().getMapGroup().getMapObjectsByID("start")[0].getCenterLocation()) : new LocationType(this.getPlan().getMapGroup().getCoordinateSystem());
        }
        if (new LocationType().getDistanceInMeters(start) == 0.0) {
            start = null;
        }
        AffineTransform oldTransform = g.getTransform();
        AffineTransform identity = g.getTransform();
        Color c = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        Vector<String> drawnLocations = new Vector<String>();
        Vector<String> drawnTransitions = new Vector<String>();
        for (Maneuver man : maneuvers) {
            for (Maneuver previousMan : this.plan.getGraph().getPreviousManeuvers(man.getId())) {
                String trans;
                g.setColor(c);
                g.setTransform(identity);
                Point2D previousPoint = null;
                boolean isTrajectoryKnown = false;
                if (previousMan == null) {
                    previousPoint = null;
                } else {
                    previousPoint = this.endManeuverLocations.get(previousMan.getId());
                    if (man instanceof LocatedManeuver && previousMan instanceof LocatedManeuver) {
                        isTrajectoryKnown = true;
                    }
                }
                if (isTrajectoryKnown) {
                    g.setStroke(new BasicStroke());
                } else {
                    g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 5.0f, 2.0f, 5.0f}, 0.0f));
                }
                Point2D loc = this.maneuverLocations.get(man.getId());
                Point2D sLoc = this.startManeuverLocations.get(man.getId());
                if (loc == null || previousPoint == null || drawnTransitions.contains(trans = previousPoint.toString() + "->" + loc.toString())) continue;
                drawnTransitions.add(trans);
                if (this.beingEdited) {
                    g.setColor(Color.black);
                    g.setStroke(new BasicStroke(4.0f));
                    g.draw(new Line2D.Double(previousPoint, sLoc));
                } else {
                    g.setColor(Color.gray.darker());
                    g.setStroke(new BasicStroke(2.0f));
                    g.draw(new Line2D.Double(previousPoint, sLoc));
                }
                if (this.beingEdited) {
                    g.setColor(Color.yellow);
                    g.setStroke(new BasicStroke(2.0f));
                    g.draw(new Line2D.Double(previousPoint, sLoc));
                } else {
                    g.setColor(Color.white);
                    g.setStroke(new BasicStroke(1.0f));
                    g.draw(new Line2D.Double(previousPoint, sLoc));
                }
                g.setStroke(new BasicStroke());
                g.translate(sLoc.getX(), sLoc.getY());
                double angle = Math.atan2(sLoc.getY() - previousPoint.getY(), sLoc.getX() - previousPoint.getX());
                g.rotate(angle - 1.5707963267948966);
                if (this.isBeingEdited()) {
                    g.scale(1.5, 1.5);
                    g.setColor(Color.black);
                    g.fill(arrow2);
                    g.setColor(Color.yellow);
                    g.fill(arrow1);
                    g.scale(0.6666666666666666, 0.6666666666666666);
                } else {
                    g.setColor(Color.gray);
                    g.fill(arrow2);
                    g.setColor(Color.white);
                    g.fill(arrow1);
                }
                if (!this.showDistances || !isTrajectoryKnown) continue;
                String txt = "";
                double dist = loc.distance(previousPoint);
                g.translate(0.0, -dist / 2.0);
                g.rotate(1.5707963267948966);
                LocationType sPos = renderer.getRealWorldLocation(sLoc);
                LocationType pPos = renderer.getRealWorldLocation(previousPoint);
                txt = txt + GuiUtils.getNeptusDecimalFormat(0).format(sPos.getDistanceInMeters(pPos)) + " m";
                if (Math.abs(angle) > 1.5707963267948966) {
                    g.rotate(Math.PI);
                }
                Font oldFont = g.getFont();
                g.setFont(new Font("Arial", 0, 10));
                Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(txt, g);
                g.setColor(Color.BLACK);
                g.drawString(txt, -((int)stringBounds.getWidth()) / 2 + 1, -2);
                g.setColor(Color.WHITE);
                g.drawString(txt, -((int)stringBounds.getWidth()) / 2, -3);
                g.setFont(oldFont);
            }
        }
        g.setStroke(new BasicStroke());
        for (Maneuver man : maneuvers) {
            Point2D loc = this.maneuverLocations.get(man.getId());
            if (loc == null) {
                this.recalculateManeuverPositions(renderer);
                loc = this.maneuverLocations.get(man.getId());
            }
            if (drawnLocations.contains(loc.toString()) && man instanceof Goto && (this.getActiveManeuver() == null || !this.getActiveManeuver().equals(man.getId()))) continue;
            drawnLocations.add(loc.toString());
            g.setTransform(identity);
            loc = this.maneuverLocations.get(man.getId());
            if (loc == null) continue;
            g.translate(loc.getX(), loc.getY());
            man.paintOnMap(g, this, renderer);
        }
        g.setTransform(oldTransform);
    }

    public void setPlanZ(double z, ManeuverLocation.Z_UNITS units) {
        for (String key : this.maneuverLocations.keySet()) {
            Maneuver man = this.plan.getGraph().getManeuver(key);
            if (man == null || !(man instanceof LocatedManeuver)) continue;
            ManeuverLocation lt = ((LocatedManeuver)((Object)man)).getManeuverLocation();
            lt.setZ(z);
            lt.setZUnits(units);
            ((LocatedManeuver)((Object)man)).setManeuverLocation(lt);
        }
    }

    public void setPlanProperty(DefaultProperty property) {
        this.lastSetProperties.put(property.getName(), property);
        for (Maneuver man : this.plan.getGraph().getAllManeuvers()) {
            man.setProperties(new Property[]{property});
        }
    }

    public void translatePlan(double offsetNorth, double offsetEast, double offsetDown) {
        for (String key : this.maneuverLocations.keySet()) {
            Maneuver man = this.plan.getGraph().getManeuver(key);
            if (man == null || !(man instanceof LocatedManeuver)) continue;
            ((LocatedManeuver)((Object)man)).translate(offsetNorth, offsetEast, offsetDown);
        }
        this.recalculateManeuverPositions(this.renderer);
    }

    public void rotatePlan(LocatedManeuver center, double ammount) {
        for (Maneuver m : this.plan.getGraph().getAllManeuvers()) {
            if (m == center || !(m instanceof LocatedManeuver)) continue;
            LocatedManeuver satellite = (LocatedManeuver)((Object)m);
            double[] top = center.getManeuverLocation().getDistanceInPixelTo(satellite.getManeuverLocation(), 22);
            double[] topR = AngleCalc.rotate(2.0 * ammount, top[0], top[1], false);
            double deltaX = topR[0];
            double deltaY = topR[1];
            ManeuverLocation lt = new ManeuverLocation(center.getManeuverLocation());
            lt.translateInPixel(deltaX, deltaY, 22);
            lt.setAbsoluteDepth(satellite.getManeuverLocation().getAllZ());
            lt.setZ(satellite.getManeuverLocation().getZ());
            lt.setZUnits(satellite.getManeuverLocation().getZUnits());
            satellite.setManeuverLocation(lt);
        }
        this.recalculateManeuverPositions(this.renderer);
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        return null;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        return false;
    }

    @Override
    public LocationType getCenterLocation() {
        return this.center;
    }

    @Override
    public void setCenterLocation(LocationType l) {
        this.center.setLocation(l);
    }

    public Point3d[] getPath() {
        Vector offsets3D = new Vector();
        Vector points = offsets3D;
        if (points == null || points.size() <= 1) {
            return new Point3d[0];
        }
        Point3d[] pts = new Point3d[points.size() * 2 - 2];
        int i = 1;
        int x = 1;
        pts[0] = (Point3d)points.firstElement();
        while (i < points.size() - 1) {
            pts[x] = (Point3d)points.get(i);
            pts[++x] = (Point3d)points.get(i);
            ++i;
            ++x;
        }
        pts[pts.length - 1] = (Point3d)points.get(points.size() - 1);
        return pts;
    }

    @Override
    public int getLayerPriority() {
        return 127;
    }

    public PlanType getPlan() {
        return this.plan;
    }

    public void setPlan(PlanType plan) {
        this.plan = plan;
        if (plan == null) {
            return;
        }
        if (this.renderer != null) {
            this.recalculateManeuverPositions(this.renderer);
        }
    }

    public StateRenderer2D getRenderer() {
        return this.renderer;
    }

    public void setRenderer(StateRenderer2D renderer) {
        this.renderer = renderer;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.renderer != null) {
            this.renderer.repaint();
        }
    }

    public boolean isShowDistances() {
        return this.showDistances;
    }

    public void setShowDistances(boolean showDistances) {
        this.showDistances = showDistances;
        if (this.renderer != null) {
            this.renderer.repaint();
        }
    }

    public boolean isShowManNames() {
        return this.showManNames;
    }

    public void setShowManNames(boolean showManNames) {
        this.showManNames = showManNames;
    }

    public boolean isShowVelocities() {
        return this.showVelocities;
    }

    public void setShowVelocities(boolean showVelocities) {
        this.showVelocities = showVelocities;
    }

    public boolean isSaveAsTrajectory() {
        return this.saveAsTrajectory;
    }

    public void setSaveAsTrajectory(boolean saveAsTrajectory) {
        this.saveAsTrajectory = saveAsTrajectory;
        this.plan.setSaveGotoSequenceAsTrajectory(saveAsTrajectory);
    }

    @Override
    public void preferencesUpdated() {
        this.setColor(GeneralPreferences.rendererPlanColor);
        this.renderer.repaint();
    }

    public String getSelectedManeuver() {
        return this.selectedManeuver;
    }

    public void setSelectedManeuver(String selectedManeuver) {
        this.selectedManeuver = selectedManeuver;
    }

    public int getSnapPixels() {
        return this.snapPixels;
    }

    public void setSnapPixels(int snapPixels) {
        this.snapPixels = snapPixels;
    }

    public String getActiveManeuver() {
        return this.activeManeuver;
    }

    public void setActiveManeuver(String activeManeuver) {
        this.activeManeuver = activeManeuver;
    }

    public void setTransp2d(double transp2d) {
        this.transp2d = transp2d;
    }

    public double getTransp2d() {
        return this.transp2d;
    }

    public VehicleType getVehicleType() {
        return this.plan.getVehicleType();
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_OTHER;
    }

    public boolean isBeingEdited() {
        return this.beingEdited;
    }

    public void setBeingEdited(boolean beingEdited) {
        this.beingEdited = beingEdited;
    }

    public LinkedHashMap<String, DefaultProperty> getLastSetProperties() {
        return this.lastSetProperties;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        MissionType mt = new MissionType("c:/APDL/missao-apdl.xml");
        MapGroup mg = MapGroup.getMapGroupInstance(mt);
        StateRenderer2D r2d = new StateRenderer2D(mg);
        MapType map = new MapType(new LocationType(mg.getCoordinateSystem()));
        mg.addMap(map);
        PlanElement po = new PlanElement(mg, map);
        PlanType plan = mt.getIndividualPlansList().values().iterator().next();
        po.setPlan(plan);
        map.addObject(po);
        GuiUtils.testFrame(r2d, "dsafs");
    }

    static {
        arrow1.moveTo(0.0f, -5.0f);
        arrow1.lineTo(-3.5, -11.0);
        arrow1.lineTo(3.5, -11.0);
        arrow1.closePath();
        arrow2.moveTo(0.0f, -6.0f);
        arrow2.lineTo(-4.5, -12.0);
        arrow2.lineTo(4.5, -12.0);
        arrow2.closePath();
    }
}

