/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.mp.maneuvers.StatisticsProvider;
import pt.lsts.neptus.mp.preview.PlanSimulator;
import pt.lsts.neptus.mp.preview.SpeedConversion;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.StringUtils;

public class PlanUtil {
    private static NumberFormat format = GuiUtils.getNeptusDecimalFormat(0);
    public static double speedRpmRatioSpeed = 1.3;
    public static double speedRpmRatioRpms = 1000.0;

    private PlanUtil() {
    }

    public static Vector<LocatedManeuver> getLocationsAsSequence(PlanType plan) {
        Vector<LocatedManeuver> mans = new Vector<LocatedManeuver>();
        for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            if (!(m instanceof LocatedManeuver)) continue;
            mans.add((LocatedManeuver)((Object)m));
        }
        return mans;
    }

    public static void setPlanSpeed(PlanType plan, double speedMps) {
        DefaultProperty units = PropertiesEditor.getPropertyInstance("Speed units", String.class, "m/s", true);
        units.setDisplayName(I18n.text("Speed units"));
        units.setShortDescription(I18n.text("The speed units"));
        DefaultProperty propertySpeed = PropertiesEditor.getPropertyInstance("Speed", Double.class, speedMps, true);
        propertySpeed.setDisplayName(I18n.text("Speed"));
        Property[] props = new Property[]{units, propertySpeed};
        for (Maneuver man : plan.getGraph().getAllManeuvers()) {
            man.setProperties(props);
        }
    }

    public static void setPlanDepth(PlanType plan, double depth) {
        PlanUtil.setPlanZ(plan, depth, ManeuverLocation.Z_UNITS.DEPTH);
    }

    public static void setPlanAltitude(PlanType plan, double altitude) {
        PlanUtil.setPlanZ(plan, altitude, ManeuverLocation.Z_UNITS.ALTITUDE);
    }

    public static void setPlanZ(PlanType plan, double z, ManeuverLocation.Z_UNITS units) {
        for (LocatedManeuver man : PlanUtil.getLocationsAsSequence(plan)) {
            ManeuverLocation lt = man.getManeuverLocation();
            lt.setZ(z);
            lt.setZUnits(units);
            man.setManeuverLocation(lt);
        }
    }

    public static LocationType getFirstLocation(PlanType plan) throws Exception {
        for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            if (!(m instanceof LocatedManeuver)) continue;
            return ((LocatedManeuver)((Object)m)).getStartLocation();
        }
        throw new Exception("The plan doesn't have any located maneuvers");
    }

    public static LocationType getEndLocation(PlanType plan) throws Exception {
        Maneuver[] mans = plan.getGraph().getManeuversSequence();
        for (int i = mans.length - 1; i >= 0; --i) {
            if (!(mans[i] instanceof LocatedManeuver)) continue;
            return ((LocatedManeuver)((Object)mans[i])).getEndLocation();
        }
        throw new Exception("The plan doesn't have any located maneuvers");
    }

    public Vector<SystemPositionAndAttitude> simulatePlan(PlanType plan) throws Exception {
        PlanSimulator ps = new PlanSimulator(plan, new SystemPositionAndAttitude(PlanUtil.getFirstLocation(plan), 0.0, 0.0, 0.0));
        while (!ps.getSimulationOverlay().simulationFinished) {
            Thread.sleep(100L);
        }
        return ps.getSimulationOverlay().getStates();
    }

    public Vector<SystemPositionAndAttitude> simulatePlan(LocationType loc, PlanType plan) throws Exception {
        PlanSimulator ps = new PlanSimulator(plan, new SystemPositionAndAttitude(loc, 0.0, 0.0, 0.0));
        while (!ps.getSimulationOverlay().simulationFinished) {
            Thread.sleep(100L);
        }
        return ps.getSimulationOverlay().getStates();
    }

    public static Collection<ManeuverLocation> getPlanWaypoints(PlanType plan) {
        Vector<ManeuverLocation> locs = new Vector<ManeuverLocation>();
        for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            if (!(m instanceof LocatedManeuver)) continue;
            locs.addAll(((LocatedManeuver)((Object)m)).getWaypoints());
        }
        for (ManeuverLocation l : locs) {
            l.convertToAbsoluteLatLonDepth();
        }
        return locs;
    }

    public static double getPlanLength(PlanType plan) {
        return PlanUtil.getPlanLength(PlanUtil.getLocationsAsSequence(plan));
    }

    public static double getPlanLength(Vector<LocatedManeuver> mans) {
        double length = 0.0;
        if (mans.size() == 0) {
            return 0.0;
        }
        if (mans.get(0) instanceof StatisticsProvider) {
            length += ((StatisticsProvider)((Object)mans.get(0))).getDistanceTravelled(mans.get(0).getStartLocation());
        }
        for (int i = 1; i < mans.size(); ++i) {
            if (mans.get(i) instanceof StatisticsProvider) {
                length += ((StatisticsProvider)((Object)mans.get(i))).getDistanceTravelled(mans.get(i - 1).getEndLocation());
                continue;
            }
            length += mans.get(i).getManeuverLocation().getDistanceInMeters(mans.get(i - 1).getManeuverLocation());
        }
        return length;
    }

    public static double getEstimatedDelay(LocationType previousPos, PlanType plan) throws Exception {
        double time;
        block17: {
            time = 0.0;
            try {
                if (previousPos == null) {
                    previousPos = PlanUtil.getFirstLocation(plan);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)e);
                if (previousPos != null) break block17;
                return 0.0;
            }
        }
        for (Maneuver m : plan.getGraph().getManeuversSequence()) {
            if (m instanceof StatisticsProvider) {
                time += ((StatisticsProvider)((Object)m)).getCompletionTime(previousPos);
            } else {
                try {
                    double speed = (Double)m.getClass().getMethod("getSpeed", new Class[0]).invoke((Object)m, new Object[0]);
                    String units = (String)m.getClass().getMethod("getUnits", new Class[0]).invoke((Object)m, new Object[0]);
                    switch (units.toLowerCase()) {
                        case "%": {
                            speed = SpeedConversion.convertPercentageToMps(speed);
                            break;
                        }
                        case "rpm": {
                            speed = SpeedConversion.convertRpmtoMps(speed);
                        }
                    }
                    if (m instanceof LocatedManeuver) {
                        ManeuverLocation start = ((LocatedManeuver)((Object)m)).getStartLocation();
                        ManeuverLocation end = ((LocatedManeuver)((Object)m)).getEndLocation();
                        time += start.getDistanceInMeters(previousPos) / speed;
                        time += end.getDistanceInMeters(start) / speed;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!(m instanceof LocatedManeuver)) continue;
            previousPos = ((LocatedManeuver)((Object)m)).getEndLocation();
        }
        return time;
    }

    public static String getDelayStr(LocationType previousPos, PlanType plan) throws Exception {
        return DateTimeUtil.milliSecondsToFormatedString((long)(PlanUtil.getEstimatedDelay(previousPos, plan) * 1000.0));
    }

    public static String estimatedTime(Vector<LocatedManeuver> mans, double speedRpmRatioSpeed, double speedRpmRatioRpms) {
        double timeSecs = 0.0;
        for (int i = 0; i < mans.size(); ++i) {
            LocatedManeuver m = mans.get(i);
            LocationType previousPos = i > 0 ? new LocationType(mans.get(i - 1).getManeuverLocation()) : new LocationType(m.getManeuverLocation());
            double speed = speedRpmRatioSpeed;
            if (m instanceof StatisticsProvider) {
                timeSecs += ((StatisticsProvider)((Object)m)).getCompletionTime(previousPos);
                continue;
            }
            try {
                speed = (Double)m.getClass().getMethod("getSpeed", new Class[0]).invoke((Object)m, new Object[0]);
                String units = (String)m.getClass().getMethod("getUnits", new Class[0]).invoke((Object)m, new Object[0]);
                if (units.equalsIgnoreCase("%")) {
                    speed = speed / 100.0 * speedRpmRatioSpeed;
                } else if (units.equalsIgnoreCase("rpm")) {
                    speed = speed / speedRpmRatioRpms * speedRpmRatioSpeed;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            double dist = mans.get(i).getManeuverLocation().getDistanceInMeters(previousPos);
            timeSecs += dist / speed;
        }
        return DateTimeUtil.milliSecondsToFormatedString((long)(timeSecs * 1000.0));
    }

    public static double getMaxPlannedDepth(Vector<LocatedManeuver> mans) {
        double depth = 0.0;
        if (!mans.isEmpty()) {
            depth = mans.get(0).getManeuverLocation().getAllZ();
        }
        for (int i = 1; i < mans.size(); ++i) {
            double d = mans.get(i).getManeuverLocation().getAllZ();
            if (!(d > depth)) continue;
            depth = d;
        }
        return depth;
    }

    public static double getMinPlannedDepth(Vector<LocatedManeuver> mans) {
        double depth = 0.0;
        if (!mans.isEmpty()) {
            depth = mans.get(0).getManeuverLocation().getAllZ();
        }
        for (int i = 1; i < mans.size(); ++i) {
            double d = mans.get(i).getManeuverLocation().getAllZ();
            if (!(d < depth)) continue;
            depth = d;
        }
        return depth;
    }

    public static int numManeuvers(PlanType plan) {
        return plan.getGraph().getAllManeuvers().length;
    }

    public static JMenu getPlanStatisticsAsJMenu(PlanType plan, String title) {
        return PlanUtil.getPlanStatisticsAsJMenu(plan, title, speedRpmRatioSpeed, speedRpmRatioRpms);
    }

    public static JMenu getPlanStatisticsAsJMenu(PlanType plan, double speedRpmRatioSpeed, double speedRpmRatioRpms) {
        return PlanUtil.getPlanStatisticsAsJMenu(plan, null, speedRpmRatioSpeed, speedRpmRatioRpms);
    }

    public static JMenu getPlanStatisticsAsJMenu(PlanType plan, String title, double speedRpmRatioSpeed, double speedRpmRatioRpms) {
        if (title == null || title.length() == 0) {
            title = I18n.text("Plan Statistics");
        }
        JMenu menu = new JMenu(title);
        String txt = PlanUtil.getPlanStatisticsAsText(plan, title, speedRpmRatioSpeed, speedRpmRatioRpms, true, false);
        boolean titleBool = true;
        for (String str : txt.split("\n")) {
            if (titleBool) {
                titleBool = false;
                continue;
            }
            if (str.equalsIgnoreCase("")) {
                menu.addSeparator();
                continue;
            }
            menu.add(new JLabel(str));
        }
        return menu;
    }

    public static String getPlanStatisticsAsText(PlanType plan, String title, boolean simpleTextOrHTML, boolean asHTMLFragment) {
        return PlanUtil.getPlanStatisticsAsText(plan, title, speedRpmRatioSpeed, speedRpmRatioRpms, simpleTextOrHTML, asHTMLFragment);
    }

    public static String getPlanStatisticsAsText(PlanType plan, String title, double speedRpmRatioSpeed, double speedRpmRatioRpms, boolean simpleTextOrHTML, boolean asHTMLFragment) {
        if (title == null || title.length() == 0) {
            title = I18n.text("Plan Statistics");
        }
        Vector<LocatedManeuver> mans = PlanUtil.getLocationsAsSequence(plan);
        String ret = "";
        String estDelay = PlanUtil.estimatedTime(mans, speedRpmRatioSpeed, speedRpmRatioRpms);
        try {
            estDelay = PlanUtil.getDelayStr(null, plan);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        ret = ret + (simpleTextOrHTML ? "" : (asHTMLFragment ? "" : "<html>") + "<h1>") + title + (simpleTextOrHTML ? "\n" : "</h1><ul>");
        ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + I18n.text("ID") + ":" + (simpleTextOrHTML ? " " : "</b> ") + plan.getId() + (simpleTextOrHTML ? "\n" : "</li>");
        ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + I18n.text("Length") + ":" + (simpleTextOrHTML ? " " : "</b> ") + MathMiscUtils.parseToEngineeringNotation(PlanUtil.getPlanLength(mans), 2) + "m" + (simpleTextOrHTML ? "\n" : "</li>");
        ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + I18n.text("Est. Time") + ":" + (simpleTextOrHTML ? " " : "</b> ") + estDelay + "" + (simpleTextOrHTML ? "\n" : "</li>");
        ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + I18n.text("Max. Depth") + ":" + (simpleTextOrHTML ? " " : "</b> ") + format.format(PlanUtil.getMaxPlannedDepth(mans)) + "m" + (simpleTextOrHTML ? "\n" : "</li>");
        ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + I18n.text("Min. Depth") + ":" + (simpleTextOrHTML ? " " : "</b> ") + format.format(PlanUtil.getMinPlannedDepth(mans)) + "m" + (simpleTextOrHTML ? "\n" : "</li>");
        ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + I18n.text("# Maneuvers") + ":" + (simpleTextOrHTML ? " " : "</b> ") + PlanUtil.numManeuvers(plan) + "" + (simpleTextOrHTML ? "\n" : "</li>");
        ret = ret + (simpleTextOrHTML ? "\n" : "");
        Vector<VehicleType> vehs = plan.getVehicles();
        String vehiclesListStr = "";
        if (vehs.size() > 0) {
            for (VehicleType vehicleType : vehs) {
                vehiclesListStr = vehiclesListStr + vehicleType.getName();
            }
            vehiclesListStr = StringUtils.wrapEveryNChars(vehiclesListStr, (short)40, -1, true);
            String vehicleTitle = I18n.text("Vehicle") + (vehs.size() > 1 ? "s" : "");
            ret = ret + (simpleTextOrHTML ? "\n" : "");
            ret = ret + (simpleTextOrHTML ? "" : "<li><b>") + vehicleTitle + ":" + (simpleTextOrHTML ? " " : "</b> ") + vehiclesListStr + (simpleTextOrHTML ? "\n" : "</li>");
        }
        ret = ret + (simpleTextOrHTML ? "" : "</ul>" + (asHTMLFragment ? "" : "</html>"));
        return ret;
    }
}

