/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.SimpleMapElement;
import pt.lsts.neptus.util.MathMiscUtils;

public class QRouteElement
extends SimpleMapElement
implements ConfigurationListener {
    @NeptusProperty
    public double width = 10.0;
    @NeptusProperty
    public Color color = Color.cyan;
    @NeptusProperty
    public String path = "";
    public Vector<Point2D.Double> otherPoints = new Vector();

    public String validatePath(String path) {
        try {
            String[] parts;
            for (String part : parts = path.split(";")) {
                String[] p = part.split(",");
                Double.parseDouble(p[0]);
                Double.parseDouble(p[1]);
            }
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        return null;
    }

    public QRouteElement() {
    }

    public QRouteElement(MapGroup mg, MapType map) {
        super(mg, map);
    }

    public void finish() {
        this.path = "";
        for (Point2D.Double pt : this.otherPoints) {
            this.path = this.path + pt.getX() + "," + pt.getY() + ";";
        }
        this.path = this.path.substring(0, this.path.length() - 1);
    }

    @Override
    public void propertiesChanged() {
        String[] points;
        this.otherPoints.clear();
        for (String p : points = this.path.split(";")) {
            String[] p2 = p.split(",");
            this.otherPoints.add(new Point2D.Double(Double.parseDouble(p2[0]), Double.parseDouble(p2[1])));
        }
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        Point2D clicked = renderer.getScreenPosition(point);
        Point2D prevPoint = renderer.getScreenPosition(this.getCenterLocation());
        for (int i = 0; i < this.otherPoints.size(); ++i) {
            Point2D curPoint = renderer.getScreenPosition(new LocationType(this.otherPoints.get((int)i).x, this.otherPoints.get((int)i).y));
            Line2D.Double l = new Line2D.Double(prevPoint, curPoint);
            if (MathMiscUtils.pointLineDistance(clicked, l) < this.width / 2.0 * (double)renderer.getZoom()) {
                return true;
            }
            prevPoint = curPoint;
        }
        return false;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        float w = (float)(this.width * (double)renderer.getZoom());
        g.setStroke(new BasicStroke(w, 2, 1));
        g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        GeneralPath gp = new GeneralPath();
        Point2D first = renderer.getScreenPosition(this.getCenterLocation());
        gp.moveTo(first.getX(), first.getY());
        for (Point2D point2D : this.otherPoints) {
            Point2D screenCoords = renderer.getScreenPosition(new LocationType(point2D.getX(), point2D.getY()));
            gp.lineTo(screenCoords.getX(), screenCoords.getY());
        }
        g.draw(gp);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.red);
        g.draw(gp);
    }

    @Override
    public String getTypeAbbrev() {
        return "qr";
    }

    @Override
    public void setCenterLocation(LocationType centralLocation) {
        NeptusLog.pub().info((Object)"<###>Set center location");
        LocationType prevLocation = new LocationType(this.getCenterLocation());
        super.setCenterLocation(centralLocation);
        double[] offsets = this.getCenterLocation().getOffsetFrom(prevLocation);
        for (Point2D point2D : this.otherPoints) {
            LocationType l = new LocationType(point2D.getX(), point2D.getY());
            l.translatePosition(offsets);
            l.convertToAbsoluteLatLonDepth();
            point2D.setLocation(l.getLatitudeDegs(), l.getLongitudeDegs());
        }
    }
}

