/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer3d.Obj3D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

public class ScatterPointsElement
extends AbstractElement {
    private LocationType lt = new LocationType();
    private List<Point3d> points = Collections.synchronizedList(new Vector());
    public static final int INFINITE_NUMBER_OF_POINTS = Integer.MAX_VALUE;
    private int numberOfPoints = Integer.MAX_VALUE;
    private ColorMap cmap = ColorMapFactory.createGrayScaleColorMap();
    protected Point3d lastAdded = null;
    protected Point3d lastRemoved = null;
    private int gradientcolor = 0;

    public ScatterPointsElement() {
    }

    public ScatterPointsElement(Color baseColor) {
        if (baseColor == Color.BLACK) {
            baseColor = Color.LIGHT_GRAY;
        }
        this.cmap = new InterpolationColorMap(new double[]{0.0, 1.0}, new Color[]{Color.BLACK, baseColor});
    }

    public ScatterPointsElement(MapGroup mg, MapType map) {
        super(mg, map);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
    }

    public ScatterPointsElement(MapGroup mg, MapType map, Color baseColor) {
        super(mg, map);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
        this.setColor(baseColor, Color.gray.darker().darker());
    }

    public void setColor(Color tail, Color head) {
        this.cmap = new InterpolationColorMap(new double[]{0.0, 1.0}, new Color[]{new Color(tail.getRed(), tail.getGreen(), tail.getBlue()), new Color(head.getRed(), head.getGreen(), head.getBlue())});
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        return false;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        return null;
    }

    @Override
    public String getType() {
        return "Scatter points";
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Graphics2D g2 = (Graphics2D)g.create();
        Point2D ofs = renderer.getScreenPosition(this.getCenterLocation());
        g2.translate(ofs.getX(), ofs.getY());
        g2.setColor(new Color(255, 255, 255, 200));
        g2.setStroke(new BasicStroke(3.0f, 1, 1));
        int curPoint = 0;
        List<Point3d> list = this.points;
        synchronized (list) {
            for (Point3d pt : this.points) {
                LocationType locT = new LocationType(this.getCenterLocation());
                locT.translatePosition(pt.x, pt.y, pt.z);
                locT.convertToAbsoluteLatLonDepth();
                Point2D ofsT = renderer.getScreenPosition(locT);
                if (!renderer.contains((int)ofsT.getX(), (int)ofsT.getY())) continue;
                double transX = ofsT.getX() - ofs.getX();
                double transY = ofsT.getY() - ofs.getY();
                g2.setColor(this.cmap.getColor(1.0 - (double)curPoint++ / (double)this.points.size()));
                g2.draw(new Line2D.Double(transX, transY, transX, transY));
            }
        }
        g2.dispose();
    }

    @Override
    public int getLayerPriority() {
        return 0;
    }

    @Override
    public LocationType getCenterLocation() {
        return this.lt;
    }

    @Override
    public void setCenterLocation(LocationType l) {
        this.lt.setLocation(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        List<Point3d> list = this.points;
        synchronized (list) {
            this.points.clear();
        }
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setSourceMap(this.getParentMap());
        mce.setMapGroup(this.getMapGroup());
        mce.setChangedObject(this);
        this.getParentMap().warnChangeListeners(mce);
    }

    public void addPoint(LocationType loc) {
        if (loc.getDistanceInMeters(this.getCenterLocation()) > 3000.0) {
            this.setCenterLocation(loc);
            this.addPoint(0.0, 0.0, 0.0);
            this.clearPoints();
        } else {
            double[] offsets = loc.getOffsetFrom(this.getCenterLocation());
            this.addPoint(offsets[0], offsets[1], offsets[2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double offsetNorth, double offsetEast, double offsetDown) {
        List<Point3d> list = this.points;
        synchronized (list) {
            if (this.numberOfPoints != Integer.MAX_VALUE && this.points.size() >= this.numberOfPoints) {
                this.points.remove(0);
            }
            this.points.add(new Point3d(offsetNorth, offsetEast, offsetDown));
        }
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setSourceMap(this.getParentMap());
        mce.setMapGroup(this.getMapGroup());
        mce.setChangedObject(this);
        this.setLastAdded(new Point3d(offsetNorth, offsetEast, offsetDown));
        this.getParentMap().warnChangeListeners(mce);
        this.setLastAdded(null);
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumberOfPoints(int numberOfPoints) {
        this.numberOfPoints = numberOfPoints < 0 ? Integer.MAX_VALUE : numberOfPoints;
        List<Point3d> list = this.points;
        synchronized (list) {
            while (this.points.size() > numberOfPoints) {
                this.points.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformGroup getModel3D() {
        TransformGroup model = new TransformGroup();
        Appearance appearance = new Appearance();
        Material mat = new Material();
        ++this.gradientcolor;
        NeptusLog.pub().info((Object)("<###> " + this.gradientcolor));
        Color color = new Color(this.gradientcolor);
        Color3f c = new Color3f(1.0f, 0.0f, 0.0f);
        c.set(color);
        mat.setEmissiveColor(c);
        mat.setAmbientColor(c);
        mat.setDiffuseColor(c);
        appearance.setMaterial(mat);
        Point3d[] myCoords = null;
        List<Point3d> list = this.points;
        synchronized (list) {
            myCoords = new Point3d[this.points.size() * 4];
            int i = 0;
            for (Point3d j : this.points) {
                myCoords[i++] = new Point3d(j.x - 0.5, j.y, j.z);
                myCoords[i++] = new Point3d(j.x + 0.5, j.y, j.z);
                myCoords[i++] = new Point3d(j.x, j.y - 0.5, j.z);
                myCoords[i++] = new Point3d(j.x, j.y + 0.5, j.z);
            }
        }
        LineArray myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        model.addChild((Node)shape3D);
        System.err.println("O objecto est\u00e1 foi criado e est\u00e1 pronto para adicionar");
        return model;
    }

    public Point3d getLastAdded() {
        return this.lastAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj3D getFullObj3D(LocationType location) {
        Obj3D obj = new Obj3D();
        obj.setPos(this.getCenterLocation().getOffsetFrom(location));
        obj.setRoll(this.getRollRad());
        obj.setPitch(this.getPitchRad());
        obj.setYaw(this.getYawRad());
        List<Point3d> list = this.points;
        synchronized (list) {
            for (Point3d j : this.points) {
                this.setLastAdded(j);
                obj.addObj3D(this.getLastAddedModel3D()[0]);
            }
        }
        this.setLastAdded(null);
        return obj;
    }

    public Obj3D[] getLastAddedModel3D() {
        Obj3D mark = new Obj3D();
        Obj3D mark5 = new Obj3D();
        TransformGroup model = new TransformGroup();
        Appearance appearance = new Appearance();
        Material mat = new Material();
        Color3f c = new Color3f(1.0f, 0.0f, 0.0f);
        ++this.gradientcolor;
        Color color = this.invertColor(new Color(this.gradientcolor));
        c.set(color);
        mat.setEmissiveColor(c);
        mat.setAmbientColor(c);
        mat.setDiffuseColor(c);
        appearance.setMaterial(mat);
        Point3d[] myCoords = new Point3d[]{new Point3d(-0.5, 0.0, 0.0), new Point3d(0.5, 0.0, 0.0), new Point3d(0.0, -0.5, 0.0), new Point3d(0.0, 0.5, 0.0)};
        LineArray myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        RenderingAttributes renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        ColoringAttributes coloringAttributes = new ColoringAttributes(c, 3);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setColoringAttributes(coloringAttributes);
        Shape3D shape3D = new Shape3D((Geometry)myLines, appearance);
        model.addChild((Node)shape3D);
        mark.setModel3D(model);
        mark.setPos(this.getLastAdded());
        Point3d ptn5 = new Point3d();
        if (this.points.size() >= 20) {
            ptn5 = this.points.get(this.points.size() - 20);
        }
        TransformGroup model2 = new TransformGroup();
        Appearance appearance2 = new Appearance();
        Material mat2 = new Material();
        Color3f c2 = new Color3f(1.0f, 0.0f, 0.0f);
        c2.set(Color.BLACK);
        mat2.setEmissiveColor(c2);
        mat2.setAmbientColor(c2);
        mat2.setDiffuseColor(c2);
        appearance2.setMaterial(mat2);
        myCoords = new Point3d[]{new Point3d(-0.5, 0.0, 0.0), new Point3d(0.5, 0.0, 0.0), new Point3d(0.0, -0.5, 0.0), new Point3d(0.0, 0.5, 0.0)};
        myLines = new LineArray(myCoords.length, 1);
        myLines.setCoordinates(0, myCoords);
        renderingAttributes = new RenderingAttributes(true, true, 0.5f, 0, true, true, false, 3);
        coloringAttributes = new ColoringAttributes(c2, 3);
        appearance2.setRenderingAttributes(renderingAttributes);
        appearance2.setColoringAttributes(coloringAttributes);
        Shape3D shape3D2 = new Shape3D((Geometry)myLines, appearance2);
        model2.addChild((Node)shape3D2);
        mark5.setModel3D(model2);
        mark5.setPos(ptn5);
        return new Obj3D[]{mark, mark5};
    }

    public Point3d getLastAdded(int ptn) {
        if (this.points.size() >= ptn) {
            return this.points.get(this.points.size() - ptn);
        }
        return null;
    }

    public void setLastAdded(Point3d lastAdded) {
        this.lastAdded = lastAdded;
    }

    public Point3d getLastRemoved() {
        return this.lastRemoved;
    }

    public void setLastremoved(Point3d lastRemoved) {
        this.lastRemoved = lastRemoved;
    }

    public List<Point3d> getPoints() {
        return this.points;
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_OTHER;
    }
}

