/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.gui.objparams.CustomParametersPanel;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;

public class SimpleMapElement
extends AbstractElement {
    public SimpleMapElement(MapGroup mg, MapType map) {
        super(mg, map);
    }

    public SimpleMapElement() {
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(tt.getX(), tt.getY());
        g.setColor(Color.BLACK);
        g.drawLine(-3, 0, 3, 0);
        g.drawLine(0, -3, 0, 3);
        g.drawString(this.getId(), 6, 6);
    }

    @Override
    public boolean load(Element elem) {
        if (!super.load(elem)) {
            return false;
        }
        PluginProperty[] props = PluginUtils.getPluginProperties(this);
        for (int i = 0; i < props.length; ++i) {
            String name = "//" + props[i].getName().replaceAll(" ", "");
            Node nd = this.doc.selectSingleNode(name);
            if (nd == null) continue;
            String pValue = nd.getText();
            try {
                props[i].unserialize(pValue);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PluginUtils.setPluginProperties((Object)this, (Property[])props);
        return true;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        return new CustomParametersPanel((Property[])PluginUtils.getPluginProperties(this)){
            private static final long serialVersionUID = 1L;

            @Override
            public String getErrors() {
                String[] errors = PluginUtils.validatePluginProperties((Object)SimpleMapElement.this, this.psp.getProperties());
                if (errors == null || errors.length == 0) {
                    return null;
                }
                String ret = "";
                for (String err : errors) {
                    ret = ret + err + "\n";
                }
                return ret;
            }
        };
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        Property[] props = ((CustomParametersPanel)paramsPanel).getProperties();
        PluginUtils.setPluginProperties((Object)this, props);
    }

    @Override
    public boolean containsPoint(LocationType point, StateRenderer2D renderer) {
        return false;
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_OTHER;
    }

    @Override
    public int getLayerPriority() {
        return 0;
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String asXML() {
        String rootElementName = this.getType();
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = this.getType();
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = this.getType();
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = (Element)super.asDocument(this.getType()).getRootElement().detach();
        document.add(root);
        PluginProperty[] props = PluginUtils.getPluginProperties(this);
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getName().replaceAll(" ", "");
            root.addElement(name).addText(props[i].serialize());
        }
        return document;
    }
}

