/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.LblBeacon;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.gui.objparams.TransponderParameters;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.NameId;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.TransponderUtils;
import pt.lsts.neptus.types.misc.FileType;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.PropertiesLoader;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class TransponderElement
extends AbstractElement
implements NameId {
    protected static final String DEFAULT_ROOT_ELEMENT = "transponder";
    private static Image transponderImg = ImageUtils.getImage("images/transponder.png");
    public short duneId;
    protected FileType file = null;
    protected boolean buoyAttached = true;
    private TransponderParameters params = null;
    private PropertiesLoader propConf = null;

    public TransponderElement() {
        this.duneId = (short)-1;
    }

    public TransponderElement(String xml) {
        this.load(xml);
        this.duneId = (short)-1;
    }

    public TransponderElement(Element elem) {
        this.load(elem);
        this.duneId = (short)-1;
    }

    public TransponderElement(MapGroup mg, MapType parentMap) {
        super(mg, parentMap);
        if (mg != null) {
            this.setCenterLocation(new LocationType(mg.getHomeRef().getCenterLocation()));
        }
        this.duneId = (short)-1;
    }

    public TransponderElement(LblBeacon lblBeacon, short duneId, MapGroup mg, MapType parentMap) {
        super(mg, parentMap);
        String beacon = lblBeacon.getBeacon();
        double lat = Math.toDegrees(lblBeacon.getLat());
        double lon = Math.toDegrees(lblBeacon.getLon());
        double depth = lblBeacon.getDepth();
        LocationType lt = new LocationType();
        lt.setLatitudeDegs(lat);
        lt.setLongitudeDegs(lon);
        lt.setDepth(depth);
        this.id = beacon;
        this.setCenterLocation(lt);
        this.propConf = TransponderUtils.getMatchingConf(lblBeacon);
        this.file = new FileType();
        String workingFile = this.propConf.getWorkingFile();
        String[] tokens = workingFile.split("/");
        NeptusLog.pub().error((Object)("Beacon conf file:" + tokens[tokens.length - 1]));
        this.file.setHref(tokens[tokens.length - 1]);
        this.duneId = duneId;
    }

    private TransponderElement(short duneId, MapGroup mg, MapType parentMap, LocationType centerLocation, String identification, PropertiesLoader propConf) {
        super(mg, parentMap);
        this.centerLocation = centerLocation;
        this.id = identification;
        this.id = identification;
        this.propConf = propConf;
        this.file = new FileType();
        this.file.setHref(propConf.getWorkingFile());
        this.duneId = duneId;
    }

    @Override
    public void showParametersDialog(Component parentComp, String[] takenNames, MapType map, boolean editable) {
        super.showParametersDialog(parentComp, takenNames, map, editable, false);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransponderElement externalTrans = (TransponderElement)obj;
        if (!this.getCenterLocation().equals(externalTrans.getCenterLocation())) {
            return false;
        }
        if (!this.getId().equals(externalTrans.getId())) {
            return false;
        }
        short thisInterrogationChannel = Short.parseShort(this.propConf.getProperty("interrogation channel"));
        short thisReplyChannel = Short.parseShort(this.propConf.getProperty("reply channel"));
        short thisTransponderDelay = Short.parseShort(this.propConf.getProperty("transponder delay (msecs.)"));
        PropertiesLoader externalPropConf = externalTrans.getPropConf();
        short externalInterrogationChannel = Short.parseShort(externalPropConf.getProperty("interrogation channel"));
        short externalReplyChannel = Short.parseShort(externalPropConf.getProperty("reply channel"));
        short externalTransponderDelay = Short.parseShort(externalPropConf.getProperty("transponder delay (msecs.)"));
        if (thisReplyChannel != externalReplyChannel || thisTransponderDelay != externalTransponderDelay || thisInterrogationChannel != externalInterrogationChannel) {
            return false;
        }
        return this.duneId == externalTrans.duneId;
    }

    public boolean equals(LblBeacon lblBeacon) {
        LocationType lt = new LocationType();
        lt.setLatitudeDegs(Math.toDegrees(lblBeacon.getDouble("lat")));
        lt.setLongitudeDegs(Math.toDegrees(lblBeacon.getDouble("lon")));
        lt.setDepth(lblBeacon.getDouble("depth"));
        if (!this.getCenterLocation().equals(lt)) {
            return false;
        }
        String beaconName = lblBeacon.getString("beacon");
        if (!this.getId().equals(beaconName)) {
            return false;
        }
        short interrogationChannel = Short.parseShort(this.propConf.getProperty("interrogation channel"));
        short replyChannel = Short.parseShort(this.propConf.getProperty("reply channel"));
        short transponderDelay = Short.parseShort(this.propConf.getProperty("transponder delay (msecs.)"));
        if (replyChannel != lblBeacon.getReplyChannel()) {
            return false;
        }
        if (transponderDelay != lblBeacon.getTransponderDelay()) {
            return false;
        }
        return interrogationChannel == lblBeacon.getQueryChannel();
    }

    @Override
    public String getType() {
        return "Transponder";
    }

    @Override
    public boolean load(Element elem) {
        if (!super.load(elem)) {
            return false;
        }
        try {
            Node nd = this.doc.selectSingleNode("//file");
            if (nd != null) {
                this.setFile(new FileType(nd.asXML()));
            }
            if ((nd = this.doc.selectSingleNode("//buoy-attached")) != null) {
                this.setBuoyAttached(new Boolean(nd.getText()));
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            return false;
        }
        this.isLoadOk = true;
        return true;
    }

    public FileType getFile() {
        return this.file;
    }

    public void setFile(FileType file) {
        this.file = file;
        try {
            this.propConf = new PropertiesLoader(ConfigFetch.resolvePath("maps/" + file.getHref()), 0);
            this.fixPropertiesConfFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fixPropertiesConfFormat() {
        Hashtable<String, String> fixedValues = new Hashtable<String, String>();
        for (Object keyO : this.propConf.keySet()) {
            String key = (String)keyO;
            String value = this.propConf.getProperty(key);
            String[] vs = value.split("=");
            if (vs.length > 1) {
                key = key + " " + vs[0];
                value = vs[1];
            }
            fixedValues.put(key, value);
        }
        this.propConf.clear();
        this.propConf.putAll((Map<?, ?>)fixedValues);
    }

    public String getConfiguration() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getHref();
    }

    public void setConfiguration(String configuration) {
        if (this.getFile() == null) {
            this.setFile(new FileType());
        }
        this.getFile().setHref(configuration);
        this.setFile(this.getFile());
    }

    public PropertiesLoader getPropConf() {
        return this.propConf;
    }

    public boolean isBuoyAttached() {
        return this.buoyAttached;
    }

    public void setBuoyAttached(boolean buoyAttached) {
        this.buoyAttached = buoyAttached;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = (Element)super.asDocument(DEFAULT_ROOT_ELEMENT).getRootElement().detach();
        document.add(root);
        root.add(this.getFile().asElement());
        root.addElement("buoy-attached").addText(new Boolean(this.isBuoyAttached()).toString());
        return document;
    }

    @Override
    public boolean containsPoint(LocationType lt, StateRenderer2D renderer) {
        double distance = this.getCenterLocation().getHorizontalDistanceInMeters(lt);
        if (renderer == null) {
            return distance < 5.0;
        }
        return distance * (double)renderer.getZoom() < 10.0;
    }

    @Override
    public int getLayerPriority() {
        return 9;
    }

    @Override
    public ParametersPanel getParametersPanel(boolean editable, MapType map) {
        if (this.params == null) {
            this.params = new TransponderParameters(new CoordinateSystem(), this.objName);
        }
        this.params.setIdEditor(this.objName);
        this.params.setMap(map != null ? map : this.getParentMap());
        this.params.setLocation(this.getCenterLocation());
        this.params.setConfiguration(this.getConfiguration());
        this.params.setHomeRef(this.getMapGroup().getCoordinateSystem());
        this.params.setEditable(editable);
        return this.params;
    }

    @Override
    public void initialize(ParametersPanel paramsPanel) {
        this.setCenterLocation(this.params.getLocationPanel().getLocationType());
        this.setConfiguration(this.params.getConfiguration());
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer, double rotation) {
        Point2D tt = renderer.getScreenPosition(this.getCenterLocation());
        g.translate(tt.getX(), tt.getY());
        if (this.isSelected()) {
            g.setColor(Color.YELLOW);
            g.draw(new Rectangle2D.Double(-transponderImg.getWidth(renderer) / 2, -transponderImg.getHeight(renderer) / 2, transponderImg.getWidth(null), transponderImg.getHeight(null)));
        }
        g.drawImage(transponderImg, -transponderImg.getWidth(renderer) / 2, -transponderImg.getHeight(renderer) / 2, transponderImg.getWidth(null), transponderImg.getHeight(null), null);
        g.setColor(Color.WHITE);
        g.drawString(this.getId(), 7, 16);
    }

    @Override
    public AbstractElement.ELEMENT_TYPE getElementType() {
        return AbstractElement.ELEMENT_TYPE.TYPE_TRANSPONDER;
    }

    @Override
    public String getDisplayName() {
        return this.id;
    }

    @Override
    public String getIdentification() {
        return this.id;
    }

    public byte[] getMd5() {
        LblBeacon beacon = TransponderUtils.getTransponderAsLblBeaconMessage(this);
        return beacon.payloadMD5();
    }

    @Override
    public String toString() {
        String queryCh = this.propConf != null ? this.propConf.getProperty("interrogation channel") : "";
        String replyCh = this.propConf != null ? this.propConf.getProperty("reply channel") : "";
        String delay = this.propConf != null ? this.propConf.getProperty("transponder delay (msecs.)") : "";
        StringBuilder string = new StringBuilder();
        string.append(this.getDisplayName());
        string.append("[");
        string.append(this.getIdentification());
        string.append("]");
        string.append(this.getDisplayName());
        string.append(" ( query: ");
        string.append(queryCh);
        string.append(", reply: ");
        string.append(replyCh);
        string.append(", delay:");
        string.append(delay);
        string.append(")");
        return string.toString();
    }

    public void setDuneId(short id) {
        this.duneId = id;
    }

    @Override
    public String getTypeAbbrev() {
        return "trans";
    }

    public TransponderElement clone() {
        return new TransponderElement(this.duneId, this.getMapGroup(), this.getParentMap(), new LocationType(this.centerLocation), this.getIdentification(), this.propConf);
    }
}

