/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.map;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.imc.LblBeacon;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.util.PropertiesLoader;

public class TransponderUtils {
    private static LinkedHashMap<String, PropertiesLoader> transpondersConfList = new LinkedHashMap();

    public static String[] getTranspondersConfsNamesList() {
        return transpondersConfList.keySet().toArray(new String[transpondersConfList.size()]);
    }

    public static PropertiesLoader getMatchingConf(LblBeacon beacon) {
        for (PropertiesLoader propConf : transpondersConfList.values().toArray(new PropertiesLoader[transpondersConfList.size()])) {
            int countMatching = 0;
            short prop = Short.parseShort(propConf.getProperty("interrogation channel"));
            if (prop == beacon.getQueryChannel()) {
                ++countMatching;
            }
            if ((prop = Short.parseShort(propConf.getProperty("reply channel"))) == beacon.getReplyChannel()) {
                ++countMatching;
            }
            if ((prop = Short.parseShort(propConf.getProperty("transponder delay (msecs.)"))) == beacon.getTransponderDelay()) {
                ++countMatching;
            }
            if (countMatching != 3) continue;
            return propConf;
        }
        return null;
    }

    public static LblBeacon getTransponderAsLblBeaconMessage(TransponderElement transp) {
        LocationType tPos = transp.getCenterLocation();
        Object absLoc = tPos.getNewAbsoluteLatLonDepth();
        LblBeacon msgLBLBeaconSetup = new LblBeacon();
        msgLBLBeaconSetup.setBeacon(transp.getId());
        msgLBLBeaconSetup.setLat(((LocationType)absLoc).getLatitudeRads());
        msgLBLBeaconSetup.setLon(((LocationType)absLoc).getLongitudeRads());
        msgLBLBeaconSetup.setDepth(((LocationType)absLoc).getDepth());
        short queryChannel = 0;
        short replyChannel = 0;
        short transponderDelay = 0;
        PropertiesLoader propCong = transp.getPropConf();
        if (propCong == null) {
            return null;
        }
        String prop1 = propCong.getProperty("interrogation channel");
        String prop2 = propCong.getProperty("reply channel");
        String prop3 = propCong.getProperty("transponder delay (msecs.)");
        try {
            queryChannel = (short)Double.parseDouble(prop1);
            replyChannel = (short)Double.parseDouble(prop2);
            transponderDelay = (short)Double.parseDouble(prop3);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        msgLBLBeaconSetup.setQueryChannel(queryChannel);
        msgLBLBeaconSetup.setReplyChannel(replyChannel);
        msgLBLBeaconSetup.setTransponderDelay(transponderDelay);
        return msgLBLBeaconSetup;
    }

    public static ArrayList<TransponderElement> orderTransponders(ArrayList<TransponderElement> transponders) {
        Collections.sort(transponders, new Comparator<TransponderElement>(){

            @Override
            public int compare(TransponderElement o1, TransponderElement o2) {
                return o1.getId().compareToIgnoreCase(o2.getId());
            }
        });
        return transponders;
    }

    static {
        ArrayList<String> aTranspondersFiles = new ArrayList<String>();
        ArrayList<PropertiesLoader> aConfsInFile = new ArrayList<PropertiesLoader>();
        File dir = new File("maps/");
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.matches("^(lsts[0-9]+\\.conf)|([A-Za-z][A-Za-z0-9\\-\\_]*\\.conf)$");
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.getName().startsWith("lsts") && !o2.getName().startsWith("lsts")) {
                    return -1;
                }
                if (!o1.getName().startsWith("lsts") && o2.getName().startsWith("lsts")) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        for (File file : files) {
            PropertiesLoader propConf = new PropertiesLoader(file.getAbsolutePath(), 0);
            Hashtable<String, String> fixedValues = new Hashtable<String, String>();
            for (Object keyO : propConf.keySet()) {
                String key = (String)keyO;
                String value = propConf.getProperty(key);
                String[] vs = value.split("=");
                if (vs.length > 1) {
                    key = key + " " + vs[0];
                    value = vs[1];
                }
                fixedValues.put(key, value);
            }
            propConf.clear();
            propConf.putAll((Map<?, ?>)fixedValues);
            aTranspondersFiles.add(file.getName());
            aConfsInFile.add(propConf);
        }
        for (int i = 0; i < aTranspondersFiles.size(); ++i) {
            transpondersConfList.put((String)aTranspondersFiles.get(i), (PropertiesLoader)aConfsInFile.get(i));
        }
    }
}

