/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.misc;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class FileType
implements XmlOutputMethods {
    protected static final String DEFAULT_ROOT_ELEMENT = "file";
    protected String id;
    protected String name;
    protected String type;
    protected String href;
    protected String description;
    protected Document doc;
    protected String originalFilePath;

    public FileType() {
        this.name = this.id = NameNormalizer.getRandomID();
        this.type = "unknown";
        this.href = "benthos2.conf";
        this.description = "";
        this.originalFilePath = "";
    }

    public FileType(String xml) {
        this.name = this.id = NameNormalizer.getRandomID();
        this.type = "unknown";
        this.href = "benthos2.conf";
        this.description = "";
        this.originalFilePath = "";
        this.load(xml);
    }

    public boolean load(String xml) {
        try {
            NeptusLog.pub().debug((Object)("FileType:\n" + xml));
            this.doc = DocumentHelper.parseText((String)xml);
            this.setId(this.doc.selectSingleNode("/file/id").getText());
            this.setName(this.doc.selectSingleNode("/file/name").getText());
            Node nd = this.doc.selectSingleNode("/file/type");
            if (nd != null) {
                this.setType(nd.getText());
            } else {
                this.setType("unknown");
            }
            if ("".equals(this.originalFilePath)) {
                this.setHref(this.doc.selectSingleNode("/file/href").getText());
            } else {
                this.setHref(ConfigFetch.resolvePathWithParent(this.originalFilePath, this.doc.selectSingleNode("/file/href").getText()));
            }
            nd = this.doc.selectSingleNode("/file/description");
            if (nd != null) {
                this.setDescription(nd.getText());
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("id").addText(this.getId());
        root.addElement("name").addText(this.getName());
        root.addElement("type").addText(this.getType());
        if ("".equals(this.originalFilePath)) {
            root.addElement("href").addText(this.getHref());
        } else {
            root.addElement("href").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, this.getHref()));
        }
        if (!this.description.equalsIgnoreCase("")) {
            root.addElement("description").addText(this.getDescription());
        }
        return document;
    }

    public String toString() {
        return this.getName() + " (" + this.getId() + ")";
    }
}

