/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.misc;

import java.util.Vector;
import pt.lsts.neptus.messages.RawData;

public class RawDataVector<T>
extends Vector<T>
implements Comparable<RawDataVector<T>> {
    private static final int MAX_PRINTABLE_DATA = 10;
    private int maxPrintableData = 10;

    public int getMaxPrintableData() {
        return this.maxPrintableData;
    }

    public void setMaxPrintableData(int maxPrintableData) {
        this.maxPrintableData = maxPrintableData < 0 ? maxPrintableData * -1 : maxPrintableData;
    }

    @Override
    public synchronized String toString() {
        String data = this.toStringComplete();
        if (data.length() > this.maxPrintableData) {
            data = data.substring(0, this.maxPrintableData / 2 * 3) + " ... " + data.substring(data.length() - this.maxPrintableData / 2 * 3 - 2);
        }
        return data;
    }

    public synchronized String toStringComplete() {
        if (this.isEmpty()) {
            return super.toString();
        }
        if (this.firstElement() instanceof Byte) {
            String ret = "";
            for (Object elem : this) {
                Byte elemB = (Byte)elem;
                int val = elemB < 0 ? 256 + elemB : elemB;
                ret = ret + " " + Integer.toHexString(val);
            }
            return ret;
        }
        return super.toString();
    }

    public synchronized Byte[] toArray() {
        if (this.isEmpty()) {
            return new Byte[0];
        }
        if (this.firstElement() instanceof Byte) {
            Byte[] elemB = new Byte[this.size()];
            return super.toArray(elemB);
        }
        return new Byte[0];
    }

    public RawData toRawData() {
        return new RawData(this.toArray());
    }

    @Override
    public int compareTo(RawDataVector<T> arg0) throws ClassCastException {
        try {
            RawDataVector<T> comp = arg0;
        }
        catch (RuntimeException e) {
            ClassCastException ccexp = new ClassCastException("The type should be RawDataType and was found" + arg0);
            ccexp.initCause(e);
            throw ccexp;
        }
        return 1;
    }

    public synchronized boolean addAll(T[] o) {
        boolean res = true;
        for (T e : o) {
            res = res && super.add(e);
        }
        return res;
    }

    public synchronized boolean addAll(byte[] o) {
        boolean res = true;
        for (byte el : o) {
            Byte valueOf;
            try {
                valueOf = el;
            }
            catch (Exception exp) {
                return false;
            }
            Byte el1 = valueOf;
            res = res && super.add(el1);
        }
        return res;
    }
}

