/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.mission;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.mission.ActionType;
import pt.lsts.neptus.types.mission.ConditionType;
import pt.lsts.neptus.types.mission.TransitionType;
import pt.lsts.neptus.util.NameNormalizer;

public class GraphType
implements XmlOutputMethods {
    protected static final String DEFAULT_ROOT_ELEMENT = "graph";
    protected LinkedHashMap<String, Maneuver> maneuvers = new LinkedHashMap();
    protected LinkedHashMap<String, TransitionType> transitions = new LinkedHashMap();
    protected String initialManeuver = null;
    private boolean saveGotoSequenceAsTrajectory = false;

    public Vector<TransitionType> getExitingTransitions(Maneuver man) {
        Vector<TransitionType> exitingTrans = new Vector<TransitionType>();
        for (TransitionType t : this.transitions.values()) {
            if (!t.sourceManeuver.equals(man.getId())) continue;
            exitingTrans.add(t);
        }
        return exitingTrans;
    }

    public Vector<TransitionType> getIncomingTransitions(Maneuver man) {
        Vector<TransitionType> incomingTrans = new Vector<TransitionType>();
        for (TransitionType t : this.transitions.values()) {
            if (!t.targetManeuver.equals(man.getId())) continue;
            incomingTrans.add(t);
        }
        return incomingTrans;
    }

    public GraphType() {
    }

    public GraphType(String xml) {
        this.load(xml);
    }

    public boolean load(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Object[] nodes = doc.selectNodes("./graph/node").toArray();
            for (int i = 0; i < nodes.length; ++i) {
                Element node = (Element)nodes[i];
                Maneuver man = Maneuver.createFromXML(node.asXML());
                this.addManeuver(man, false);
                if (!man.isInitialManeuver() && this.initialManeuver != null) continue;
                this.setInitialManeuver(man.getId());
            }
            Object[] edges = doc.selectNodes("/graph/edge").toArray();
            for (int i = 0; i < edges.length; ++i) {
                Element edge = (Element)edges[i];
                String id = edge.selectSingleNode("./id").getText();
                String source = edge.selectSingleNode("./source").getText();
                String target = edge.selectSingleNode("./target").getText();
                String guard = edge.selectSingleNode("./guard").getText();
                if ("true".equalsIgnoreCase(guard)) {
                    guard = "ManeuverIsDone";
                }
                String actions = "";
                Node nda = edge.selectSingleNode("./actions");
                if (nda != null) {
                    actions = nda.getText();
                }
                this.addTransition(id, source, target, guard, actions);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void addManeuver(Maneuver maneuver) {
        this.addManeuver(maneuver, true);
    }

    public void addManeuver(Maneuver maneuver, boolean clearInitialManeuverFlagIfOtherMAneuverIsSetToInitial) {
        if (maneuver == null) {
            NeptusLog.pub().error((Object)"Maneuver is null, so not added!!");
            return;
        }
        this.maneuvers.put(maneuver.getId(), maneuver);
        if (!clearInitialManeuverFlagIfOtherMAneuverIsSetToInitial) {
            return;
        }
        if (this.getInitialManeuverId() == null) {
            maneuver.setInitialManeuver(true);
            this.setInitialManeuver(maneuver.getId());
        } else {
            maneuver.setInitialManeuver(false);
        }
    }

    public void removeManeuver(Maneuver maneuver) {
        if (this.getInitialManeuverId() != null && this.getInitialManeuverId().equals(maneuver.getId()) && this.getFollowingManeuver(this.getInitialManeuverId()) != null) {
            this.setInitialManeuver(this.getFollowingManeuver(this.getInitialManeuverId()).getId());
            this.getManeuver(this.getInitialManeuverId()).setInitialManeuver(true);
        }
        for (TransitionType t : this.getExitingTransitions(maneuver)) {
            this.transitions.remove(t.getId());
        }
        for (TransitionType t : this.getIncomingTransitions(maneuver)) {
            this.transitions.remove(t.getId());
        }
        this.maneuvers.remove(maneuver.getId());
    }

    public Maneuver getManeuver(String maneuverID) {
        return this.maneuvers.get(maneuverID);
    }

    public TransitionType addTransition(String sourceManeuverID, String targetManeuverID, Object condition) {
        return this.addTransition(null, sourceManeuverID, targetManeuverID, condition);
    }

    public TransitionType addTransition(String sourceManeuverID, String targetManeuverID, Object condition, Object action) {
        return this.addTransition(null, sourceManeuverID, targetManeuverID, condition, action);
    }

    public TransitionType addTransition(String id, String sourceManeuverID, String targetManeuverID, Object condition) {
        return this.addTransition(id, sourceManeuverID, targetManeuverID, condition, "");
    }

    public TransitionType addTransition(String id, String sourceManeuverID, String targetManeuverID, Object condition, Object action) {
        this.removeTransition(sourceManeuverID, targetManeuverID);
        TransitionType tt = new TransitionType(sourceManeuverID, targetManeuverID);
        if (id == null) {
            tt.setId(NameNormalizer.getRandomID());
        } else if (id.equalsIgnoreCase("")) {
            tt.setId(NameNormalizer.getRandomID());
        } else {
            tt.setId(id);
        }
        ConditionType ct = new ConditionType();
        ct.setCondition(condition.toString());
        tt.setCondition(ct);
        ActionType at = new ActionType();
        at.setAction(action.toString());
        tt.setAction(at);
        this.transitions.put(tt.getId(), tt);
        if (this.maneuvers.get(sourceManeuverID) != null) {
            this.maneuvers.get(sourceManeuverID).addTransition(targetManeuverID, "true");
        } else {
            new Exception().printStackTrace();
            NeptusLog.pub().error((Object)("Error occured while adding transition from " + sourceManeuverID));
        }
        return tt;
    }

    public void removeTransition(TransitionType transition) {
        String sourceManeuver = transition.getSourceManeuver();
        String targetManeuver = transition.getTargetManeuver();
        TransitionType tt = (TransitionType)this.transitions.remove(transition.id);
        if (tt == null) {
            System.err.println("Tried to remove transition " + transition.id + " which doesn't exists");
        }
        if (this.maneuvers.containsKey(sourceManeuver)) {
            this.maneuvers.get(sourceManeuver).removeTransition(targetManeuver);
        }
    }

    public void addTransition(TransitionType tt) {
        if (this.maneuvers.containsKey(tt.getSourceManeuver())) {
            this.maneuvers.get(tt.getSourceManeuver()).addTransition(tt.getTargetManeuver(), "true");
            this.transitions.put(tt.getId(), tt);
        } else {
            System.err.println("Transition from " + tt.getSourceManeuver() + " cannot be added because source maneuver does not exists.");
        }
    }

    public TransitionType removeTransition(String sourceManeuverID, String targetManeuverID) {
        for (TransitionType tt : this.transitions.values()) {
            if (!tt.getSourceManeuver().equals(sourceManeuverID) || !tt.getTargetManeuver().equals(targetManeuverID)) continue;
            TransitionType removed = (TransitionType)this.transitions.remove(tt.getId());
            if (this.maneuvers.containsKey(sourceManeuverID)) {
                this.maneuvers.get(sourceManeuverID).removeTransition(targetManeuverID);
            }
            return removed;
        }
        return null;
    }

    public String[] getReacheableManeuvers(String sourceManeuverID) {
        if (this.maneuvers.get(sourceManeuverID) != null) {
            return this.maneuvers.get(sourceManeuverID).getReacheableManeuvers();
        }
        return null;
    }

    public Object getTransitionCondition(String sourceManeuverID, String targetManeuverID) {
        if (this.maneuvers.get(sourceManeuverID) != null) {
            return this.maneuvers.get(sourceManeuverID).getTransitionCondition(targetManeuverID);
        }
        return null;
    }

    public TransitionType getTransition(String sourceId, String targetId) {
        for (TransitionType tt : this.transitions.values()) {
            if (!tt.getSourceManeuver().equals(sourceId) || !tt.getTargetManeuver().equals(targetId)) continue;
            return tt;
        }
        return null;
    }

    public Maneuver[] getAllManeuvers() {
        return this.maneuvers.values().toArray(new Maneuver[0]);
    }

    public TransitionType[] getAllEdges() {
        return this.transitions.values().toArray(new TransitionType[0]);
    }

    public Maneuver[] getManeuversSequence(Maneuver startManeuver) {
        Vector<Maneuver> mans = new Vector<Maneuver>();
        Vector<String> visitedIDs = new Vector<String>();
        String curID = startManeuver.getId();
        block0: while (curID != null && !visitedIDs.contains(curID)) {
            visitedIDs.add(curID);
            mans.add(this.getManeuver(curID));
            String[] ways = this.getReacheableManeuvers(curID);
            if (ways == null) break;
            if (ways.length == 0) {
                curID = null;
                continue;
            }
            if (ways.length == 1) {
                curID = ways[0];
                continue;
            }
            curID = null;
            for (int i = 0; i < ways.length; ++i) {
                if (visitedIDs.contains(ways[i])) continue;
                curID = ways[i];
                continue block0;
            }
        }
        return mans.toArray(new Maneuver[0]);
    }

    public Maneuver[] getManeuversSequence() {
        if (this.getInitialManeuverId() == null) {
            return new Maneuver[0];
        }
        return this.getManeuversSequence(this.getManeuver(this.getInitialManeuverId()));
    }

    public Maneuver getLastManeuver() {
        Maneuver[] mans = this.getManeuversSequence();
        if (mans.length > 0) {
            return mans[mans.length - 1];
        }
        return null;
    }

    public Maneuver getFollowingManeuver(String maneuverID) {
        String[] reachSet = this.getReacheableManeuvers(maneuverID);
        if (reachSet != null && reachSet.length > 0) {
            return this.maneuvers.get(reachSet[0]);
        }
        return null;
    }

    public Maneuver[] getPreviousManeuvers(String maneuverID) {
        if (!this.maneuvers.containsKey(maneuverID)) {
            return new Maneuver[0];
        }
        Vector<TransitionType> incomingTrans = this.getIncomingTransitions(this.maneuvers.get(maneuverID));
        Vector<Maneuver> prevMans = new Vector<Maneuver>();
        for (TransitionType t : incomingTrans) {
            if (!this.maneuvers.containsKey(t.getSourceManeuver())) continue;
            prevMans.add(this.maneuvers.get(t.getSourceManeuver()));
        }
        return prevMans.toArray(new Maneuver[0]);
    }

    public String getGraphAsManeuversSeq() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("maneuvers");
        if (this.isSaveGotoSequenceAsTrajectory()) {
            Element manElemRoot = new FollowPath(this).asElement();
            Element idElem = (Element)manElemRoot.selectSingleNode("./id").detach();
            Element manElem = (Element)manElemRoot.selectSingleNode("./maneuver").detach();
            manElem.addAttribute("id", idElem.getText());
            root.add(manElem);
            return document.asXML();
        }
        Vector<String> visitedIDs = new Vector<String>();
        String curID = this.getInitialManeuverId();
        while (curID != null && !visitedIDs.contains(curID)) {
            Element manElemRoot = this.getManeuver(curID).asElement();
            Element idElem = (Element)manElemRoot.selectSingleNode("./id").detach();
            Element manElem = (Element)manElemRoot.selectSingleNode("./maneuver").detach();
            manElem.addAttribute("id", idElem.getText());
            root.add(manElem);
            visitedIDs.add(curID);
            String[] ways = this.getReacheableManeuvers(curID);
            if (ways.length > 1) {
                System.err.println("The function getGraphAsManeuverSequence() doesn't support more than one transitions for a node!\nOnly the first node will be processed. ");
            }
            if (ways.length == 0) {
                curID = null;
                continue;
            }
            curID = ways[0];
        }
        return document.asXML();
    }

    public LinkedList<Maneuver> getGraphAsManeuversList() {
        LinkedList<Maneuver> ret = new LinkedList<Maneuver>();
        Vector<String> visitedIDs = new Vector<String>();
        String curID = this.getInitialManeuverId();
        while (curID != null && !visitedIDs.contains(curID)) {
            Maneuver man = this.getManeuver(curID);
            ret.add(man);
            visitedIDs.add(curID);
            String[] ways = this.getReacheableManeuvers(curID);
            if (ways != null && ways.length > 1) {
                System.err.println("The function getGraphAsManeuverSequence() doesn't support more than one transitions for a node!\nOnly the first node will be processed. ");
            }
            if (ways == null || ways.length == 0) {
                curID = null;
                continue;
            }
            curID = ways[0];
        }
        return ret;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        Maneuver[] mans = this.getAllManeuvers();
        for (int i = 0; i < mans.length; ++i) {
            root.add(mans[i].asElement("node"));
        }
        TransitionType[] edges = this.getAllEdges();
        for (int i = 0; i < edges.length; ++i) {
            root.add(edges[i].asElement());
        }
        return document;
    }

    public Document asDocument2(String rootElementName) {
        NeptusLog.pub().info((Object)"<###>Save as trajectory!");
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        FollowPath trajManeuver = new FollowPath(this);
        root.add(trajManeuver.asElement("node"));
        return document;
    }

    public String getInitialManeuverId() {
        if (this.maneuvers.containsKey(this.initialManeuver)) {
            return this.initialManeuver;
        }
        return null;
    }

    public void setInitialManeuver(String initialManeuverId) {
        if (this.initialManeuver != null && !this.initialManeuver.equals(initialManeuverId) && this.maneuvers.get(this.initialManeuver) != null) {
            this.maneuvers.get(this.initialManeuver).setInitialManeuver(false);
        }
        if (this.maneuvers.get(initialManeuverId) != null) {
            this.maneuvers.get(initialManeuverId).setInitialManeuver(true);
        }
        this.initialManeuver = initialManeuverId;
    }

    public boolean isSaveGotoSequenceAsTrajectory() {
        return this.saveGotoSequenceAsTrajectory;
    }

    public void setSaveGotoSequenceAsTrajectory(boolean saveGotoSequenceAsTrajectory) {
        this.saveGotoSequenceAsTrajectory = saveGotoSequenceAsTrajectory;
    }

    public GraphType clone() {
        GraphType graph = new GraphType();
        for (Maneuver m : this.maneuvers.values()) {
            graph.addManeuver((Maneuver)m.clone());
        }
        for (TransitionType t : this.transitions.values()) {
            graph.addTransition(t.getSourceManeuver(), t.getTargetManeuver(), (ConditionType)t.getCondition().clone());
        }
        graph.setInitialManeuver(this.getInitialManeuverId());
        return graph;
    }

    public void clear() {
        this.maneuvers.clear();
        this.transitions.clear();
        this.initialManeuver = null;
        this.setSaveGotoSequenceAsTrajectory(false);
    }

    public LinkedHashMap<String, TransitionType> getTransitions() {
        return this.transitions;
    }
}

