/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.mission;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.ProgressMonitor;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import pt.lsts.imc.ImcStringDefs;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.XmlInputMethods;
import pt.lsts.neptus.types.XmlInputMethodsFromFile;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.mission.ChecklistMission;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.VehicleMission;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.Dom4JUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.NameNormalizer;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.XMLValidator;
import pt.lsts.neptus.util.ZipUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class MissionType
implements XmlOutputMethods,
XmlInputMethods,
XmlInputMethodsFromFile {
    protected static final String DEFAULT_ROOT_ELEMENT = "mission-def";
    private String id = NameNormalizer.getRandomID();
    private String name = "Unnamed Mission";
    private String type = "Test";
    private String description = "No description available";
    private final LinkedList<String> notesList = new LinkedList();
    private LinkedHashMap<String, VehicleMission> vehiclesList = new LinkedHashMap();
    private LinkedHashMap<String, MapMission> mapsList = new LinkedHashMap();
    private LinkedHashMap<String, ChecklistMission> checklistsList = new LinkedHashMap();
    private HomeReference homeRef = new HomeReference();
    private TreeMap<String, PlanType> individualPlansList = new TreeMap();
    private Document doc;
    protected boolean isLoadOk = true;
    private String originalFilePath = "";
    private String compressedFilePath = null;
    private Component parentWindow = null;
    boolean showProgress = true;

    public MissionType(String url) {
        this.loadFile(url);
    }

    public MissionType(String url, Component parentWindow) {
        this.showProgress = true;
        this.parentWindow = parentWindow;
        this.loadFile(url);
    }

    public MissionType() {
    }

    public static MissionType createZippedMission(File fileToSave) {
        String sep = System.getProperty("file.separator", "/");
        String tmpDir = ConfigFetch.getNeptusTmpDir();
        MissionType mt = new MissionType();
        File outDir = new File(tmpDir, "mission_" + mt.getId());
        if (outDir.exists()) {
            FileUtil.deltree(outDir.getAbsolutePath());
        }
        outDir.mkdirs();
        outDir.deleteOnExit();
        mt.setOriginalFilePath(new File(outDir, "mission.nmis").getAbsolutePath());
        mt.setCompressedFilePath(fileToSave.getAbsolutePath());
        MapType map = new MapType();
        map.saveFile(outDir + sep + "maps" + sep + "map.nmap");
        MapMission mm = new MapMission();
        mm.setHref(map.getHref());
        mm.setId(map.getId());
        mm.setName(map.getName());
        mm.setMap(map);
        mt.addMap(mm);
        mt.save(false);
        return mt;
    }

    @Override
    public boolean load(Element elem) {
        this.doc = Dom4JUtil.elementToDocument(elem);
        if (this.doc == null) {
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    @Override
    public boolean load(String xml) {
        try {
            this.doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            this.isLoadOk = false;
            return false;
        }
        return this.load();
    }

    private boolean load() {
        long initTime = System.currentTimeMillis();
        ProgressMonitor pmon = null;
        if (this.showProgress) {
            pmon = new ProgressMonitor(ConfigFetch.getSuperParentFrame(), I18n.text("Loading mission"), I18n.text("Verifying against schema..."), 0, 100);
            pmon.setMillisToDecideToPopup(1000);
        }
        try {
            Object mm;
            Element velem;
            Element elem;
            if (this.showProgress) {
                pmon.setProgress(10);
                pmon.setNote(I18n.text("Loading mission header..."));
            }
            this.isLoadOk = MissionType.validate(this.doc);
            this.setId(this.doc.selectSingleNode("/mission-def/header/id").getText());
            this.setName(this.doc.selectSingleNode("/mission-def/header/name").getText());
            this.setType(this.doc.selectSingleNode("/mission-def/header/type").getText());
            Node nd = this.doc.selectSingleNode("/mission-def/header/description");
            if (nd != null) {
                this.setDescription(nd.getText());
            }
            List lst = this.doc.selectNodes("/mission-def/header/notes/note");
            ListIterator lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                this.notesList.add(elem.getText());
            }
            nd = this.doc.selectSingleNode("/mission-def/definitions/home-referential");
            if (nd == null) {
                nd = this.doc.selectSingleNode("/mission-def/definitions/home-reference");
            }
            if (this.showProgress) {
                pmon.setProgress(20);
                pmon.setNote(I18n.text("Loading home reference..."));
            }
            if (nd != null) {
                this.homeRef = new HomeReference(nd.asXML());
            }
            if (this.showProgress) {
                pmon.setProgress(40);
                pmon.setNote(I18n.text("Loading vehicles..."));
            }
            lst = this.doc.selectNodes("/mission-def/definitions/vehicles/vehicle");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                velem = (Element)lstIt.next();
                VehicleMission vm = new VehicleMission();
                vm.setId(velem.selectSingleNode("./id").getText());
                vm.setName(velem.selectSingleNode("./name").getText());
                nd = velem.selectSingleNode("./vehicle-referential");
                if (nd == null) {
                    nd = velem.selectSingleNode("./vehicle-reference");
                }
                if (nd == null) {
                    vm.setCoordinateSystem(this.homeRef);
                    vm.setHomeRefUsed(true);
                } else {
                    String xml1 = nd.asXML();
                    CoordinateSystem cs = new CoordinateSystem(xml1);
                    vm.setCoordinateSystem(cs);
                }
                vm.setVehicle(VehiclesHolder.getVehicleById(vm.getId()));
                this.vehiclesList.put(vm.getId(), vm);
            }
            lst = this.doc.selectNodes("/mission-def/definitions/maps/map");
            lstIt = lst.listIterator();
            if (this.showProgress) {
                pmon.setProgress(60);
                pmon.setNote(I18n.text("Loading maps..."));
            }
            while (lstIt.hasNext()) {
                velem = (Element)lstIt.next();
                mm = new MapMission();
                ((MapMission)mm).setId(velem.selectSingleNode("./id").getText());
                ((MapMission)mm).setName(velem.selectSingleNode("./name").getText());
                if ("".equals(this.originalFilePath)) {
                    ((MapMission)mm).setHref(velem.selectSingleNode("./href").getText());
                } else {
                    ((MapMission)mm).setHrefAndLoadMap(ConfigFetch.resolvePathWithParent(this.originalFilePath, velem.selectSingleNode("./href").getText()));
                }
                this.mapsList.put(((MapMission)mm).getId(), (MapMission)mm);
            }
            if (this.showProgress) {
                pmon.setProgress(80);
                pmon.setNote(I18n.text("Loading Checklists..."));
            }
            lst = this.doc.selectNodes("/mission-def/definitions/checklists/checklist");
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                velem = (Element)lstIt.next();
                ChecklistMission cm = new ChecklistMission();
                cm.setId(velem.selectSingleNode("./id").getText());
                cm.setName(velem.selectSingleNode("./name").getText());
                if ("".equals(this.originalFilePath)) {
                    cm.setHref(velem.selectSingleNode("./href").getText());
                } else {
                    cm.setHrefAndLoadChecklist(ConfigFetch.resolvePathWithParent(this.originalFilePath, velem.selectSingleNode("./href").getText()));
                }
                this.checklistsList.put(cm.getId(), cm);
            }
            if (this.showProgress) {
                pmon.setProgress(95);
                pmon.setNote(I18n.text("Loading plans..."));
            }
            if ((lst = this.doc.selectNodes("/mission-def/body/plan")) == null || lst.size() == 0) {
                lst = this.doc.selectNodes("/mission-def/body/individual-plan");
            }
            lstIt = lst.listIterator();
            while (lstIt.hasNext()) {
                elem = (Element)lstIt.next();
                mm = new PlanType(elem.asXML(), this);
                this.individualPlansList.put(((PlanType)mm).getId(), (PlanType)mm);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)this, (Throwable)e);
            this.isLoadOk = false;
            long totalTime = System.currentTimeMillis() - initTime;
            NeptusLog.pub().info((Object)(this + ": Total mission load time: " + totalTime + " ms."));
            return false;
        }
        if (this.showProgress) {
            pmon.setProgress(100);
            pmon.setNote(I18n.text("Complete"));
        }
        long totalTime = System.currentTimeMillis() - initTime;
        NeptusLog.pub().debug((Object)(this + ": Total mission load time: " + totalTime + " ms."));
        this.isLoadOk = true;
        return true;
    }

    @Override
    public boolean loadFile(File file) {
        return this.loadFile(file.getAbsolutePath());
    }

    @Override
    public boolean loadFile(String url) {
        String extension;
        ProgressMonitor pmon = null;
        if (this.showProgress) {
            pmon = new ProgressMonitor(this.parentWindow, I18n.text("Loading mission"), I18n.text("Verifying against schema..."), 0, 100);
            pmon.setMillisToDecideToPopup(0);
        }
        if ((extension = url.substring(url.lastIndexOf(46) + 1, url.length())).equalsIgnoreCase("nmisz") || extension.equals("zip")) {
            String tmpDir = ConfigFetch.getNeptusTmpDir();
            File outDir = new File(tmpDir, "mission_" + this.getId());
            if (outDir.exists()) {
                FileUtil.deltree(outDir.getAbsolutePath());
            }
            outDir.mkdirs();
            outDir.deleteOnExit();
            NeptusLog.pub().debug((Object)("uncompressing mission to " + outDir));
            ZipUtils.unZip(url, outDir.getAbsolutePath());
            this.originalFilePath = new File(outDir, "mission.nmis").getAbsolutePath();
            this.compressedFilePath = url;
        } else {
            this.originalFilePath = new File(url).getAbsolutePath();
            this.compressedFilePath = null;
        }
        String fileAsString = FileUtil.getFileAsString(this.originalFilePath);
        return this.load(fileAsString);
    }

    @Override
    public boolean isLoadOk() {
        return this.isLoadOk;
    }

    public static boolean validate(Document doc) {
        try {
            String sLoc = new File(ConfigFetch.getMissionSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(doc, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"MissionType:validate", (Throwable)e);
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), e);
            return false;
        }
    }

    public static boolean validate(String xml) {
        try {
            String sLoc = new File(ConfigFetch.getMissionSchemaLocation()).getAbsoluteFile().toURI().toASCIIString();
            XMLValidator xmlVal = new XMLValidator(xml, sLoc);
            boolean ret = xmlVal.validate();
            return ret;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"MissionType:validate", (Throwable)e);
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), e);
            return false;
        }
    }

    public static boolean validate(File file) {
        try {
            String xml = FileUtil.getFileAsString(file);
            return MissionType.validate(xml);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"MissionType:validate", (Throwable)e);
            GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), e);
            return false;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LinkedHashMap<String, MapMission> getMapsList() {
        return this.mapsList;
    }

    public LinkedHashMap<String, ChecklistMission> getChecklistsList() {
        return this.checklistsList;
    }

    public void setChecklistsList(LinkedHashMap<String, ChecklistMission> checklistsList) {
        this.checklistsList = checklistsList;
    }

    public LinkedHashMap<String, VehicleMission> getVehiclesList() {
        return this.vehiclesList;
    }

    public LinkedList<?> getNotesList() {
        return this.notesList;
    }

    public HomeReference getHomeRef() {
        this.homeRef.setMission(this);
        return this.homeRef;
    }

    public void setHomeRef(HomeReference homeRef) {
        this.homeRef = homeRef;
    }

    public void setHomeRef(CoordinateSystem cs) {
        this.homeRef.setLocation(cs);
        this.homeRef.setAnglesUsed(cs.isAnglesUsed());
        this.homeRef.setRoll(cs.getRoll());
        this.homeRef.setPitch(cs.getPitch());
        this.homeRef.setYaw(cs.getYaw());
        this.homeRef.setId("home");
    }

    public TreeMap<String, PlanType> getIndividualPlansList() {
        return this.individualPlansList;
    }

    public String getOriginalFilePath() {
        return this.originalFilePath;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.originalFilePath = originalFilePath;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addComment(ConfigFetch.getSaveAsCommentForXML());
        Element header = root.addElement("header");
        header.addElement("id").addText(this.getId());
        header.addElement("name").addText(this.getName());
        header.addElement("type").addText(this.getType());
        if (!this.description.equalsIgnoreCase("")) {
            header.addElement("description").addText(this.getDescription());
        }
        if (this.notesList.size() != 0) {
            Element notes = header.addElement("notes");
            Iterator iter = this.notesList.iterator();
            while (iter.hasNext()) {
                notes.addElement("note").addText((String)iter.next());
            }
        }
        Element definitions = root.addElement("definitions");
        Element vehicles = definitions.addElement("vehicles");
        for (VehicleMission vm : this.vehiclesList.values()) {
            Element ve = vehicles.addElement("vehicle");
            ve.addElement("id").addText(vm.getId());
            ve.addElement("name").addText(vm.getName());
            CoordinateSystem vcs = vm.getCoordinateSystem();
            if (vcs == null || "home".equals(vcs.getId())) continue;
            ve.add(vcs.asElement("vehicle-reference"));
        }
        Element maps = definitions.addElement("maps");
        for (MapMission mm : this.mapsList.values()) {
            Element ma = maps.addElement("map");
            ma.addElement("id").addText(mm.getId());
            ma.addElement("name").addText(mm.getName());
            if ("".equals(this.originalFilePath)) {
                ma.addElement("href").addText(mm.getHref());
                continue;
            }
            ma.addElement("href").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, mm.getHref()));
        }
        Element checklists = definitions.addElement("checklists");
        for (ChecklistMission cm : this.checklistsList.values()) {
            Element cl = checklists.addElement("checklist");
            cl.addElement("id").addText(cm.getId());
            cl.addElement("name").addText(cm.getName());
            if ("".equals(this.originalFilePath)) {
                cl.addElement("href").addText(cm.getHref());
                continue;
            }
            cl.addElement("href").addText(FileUtil.relativizeFilePathAsURI(this.originalFilePath, cm.getHref()));
        }
        definitions.add(this.homeRef.asElement("home-reference"));
        Element body = root.addElement("body");
        for (PlanType indp : this.individualPlansList.values()) {
            body.add(indp.asElement());
        }
        return document;
    }

    public void addVehicle(VehicleMission vm) {
        this.vehiclesList.put(vm.getId(), vm);
    }

    public void addMap(MapMission map) {
        this.mapsList.put(map.getId(), map);
    }

    public void addPlan(PlanType ipt) {
        this.individualPlansList.put(ipt.getId(), ipt);
    }

    public void setMapsList(LinkedHashMap<String, MapMission> mapsList) {
        this.mapsList = mapsList;
    }

    public void setPlanList(TreeMap<String, PlanType> planList) {
        this.individualPlansList = planList;
    }

    public void setVehiclesList(LinkedHashMap<String, VehicleMission> vehiclesList) {
        this.vehiclesList = vehiclesList;
    }

    public boolean asZipFile(String filename, boolean saveNeptusConfigurations) {
        String sep = System.getProperty("file.separator");
        String tmpDir = ConfigFetch.getNeptusTmpDir();
        File outDir = new File(tmpDir, "tmpMission");
        if (outDir.exists()) {
            FileUtil.deltree(outDir.getAbsolutePath());
        }
        outDir.mkdirs();
        outDir.deleteOnExit();
        File mapsDir = new File(outDir, "maps");
        mapsDir.mkdirs();
        File imgsDir = new File(outDir, "images");
        imgsDir.mkdirs();
        File modelsDir = new File(outDir, "models");
        modelsDir.mkdirs();
        File chkDir = new File(outDir, "checklists");
        chkDir.mkdirs();
        Document myDoc = this.asDocument();
        if (this.originalFilePath == null || this.originalFilePath.length() == 0) {
            GuiUtils.errorMessage(null, I18n.text("Mission not saved"), I18n.text("The mission has to be saved first"));
            return false;
        }
        String oldPath = this.compressedFilePath;
        this.compressedFilePath = null;
        this.save(false);
        this.compressedFilePath = oldPath;
        String missionDir = this.originalFilePath.substring(0, this.originalFilePath.lastIndexOf(sep));
        List lst = myDoc.selectNodes("//href");
        for (Node n : lst) {
            String oldHref = ConfigFetch.resolvePathWithParent(missionDir, n.getText());
            String newHref = oldHref.substring(oldHref.lastIndexOf(sep) + 1, oldHref.length());
            if (n.getPath().contains("/map/")) {
                newHref = "maps/" + newHref;
            }
            if (n.getPath().contains("/checklist/")) {
                newHref = "checklists/" + newHref;
            }
            n.setText(newHref);
        }
        for (MapMission map : this.mapsList.values()) {
            String imgName;
            String imgHref;
            String mapHref = map.getHref();
            mapHref = ConfigFetch.resolvePathWithParent(missionDir, mapHref);
            String mapDir = mapHref.substring(0, mapHref.lastIndexOf(sep));
            Document mapDoc = map.getMap().asDocument();
            List l = mapDoc.selectNodes("//map/features/image/href");
            for (Node n : l) {
                imgHref = ConfigFetch.resolvePathWithParent(mapDir, n.getText());
                imgName = imgHref.substring(imgHref.lastIndexOf(sep) + 1, imgHref.length());
                FileUtil.copyFile(imgHref, outDir.getAbsolutePath() + sep + "images" + sep + imgName);
                n.setText("../images/" + imgName);
            }
            l = mapDoc.selectNodes("//map/features/image/bathymetryImage");
            for (Node n : l) {
                imgHref = ConfigFetch.resolvePathWithParent(mapDir, n.getText());
                imgName = imgHref.substring(imgHref.lastIndexOf(sep) + 1, imgHref.length());
                FileUtil.copyFile(imgHref, outDir.getAbsolutePath() + sep + "images" + sep + imgName);
                n.setText("../images/" + imgName);
            }
            l = mapDoc.selectNodes("//map/features/image/href-altitude");
            for (Node n : l) {
                imgHref = ConfigFetch.resolvePathWithParent(mapDir, n.getText());
                imgName = imgHref.substring(imgHref.lastIndexOf(sep) + 1, imgHref.length());
                FileUtil.copyFile(imgHref, outDir.getAbsolutePath() + sep + "images" + sep + imgName);
                n.setText("../images/" + imgName);
            }
            l = mapDoc.selectNodes("//map/features/model3d/href");
            for (Node n : l) {
                imgHref = ConfigFetch.resolvePathWithParent(mapDir, n.getText());
                imgName = imgHref.substring(imgHref.lastIndexOf(sep) + 1, imgHref.length());
                FileUtil.copyFile(imgHref, outDir.getAbsolutePath() + sep + "models" + sep + imgName);
                n.setText("../models/" + imgName);
                String imgHrefTex = imgHref + ".textures";
                String imgNameTex = imgName + ".textures";
                File fxTex = new File(imgHrefTex);
                if (!fxTex.exists()) continue;
                FileUtil.copyFile(imgHrefTex, outDir.getAbsolutePath() + sep + "models" + sep + imgNameTex);
                String strFx = FileUtil.getFileAsString(fxTex);
                StringTokenizer strTok = new StringTokenizer(strFx);
                while (strTok.hasMoreTokens()) {
                    String tFx = strTok.nextToken();
                    String tFxAbs = ConfigFetch.resolvePathWithParent(imgHrefTex, tFx);
                    FileUtil.copyFile(tFxAbs, outDir.getAbsolutePath() + sep + "models" + sep + tFx);
                }
            }
            l = mapDoc.selectNodes("//map/features/model3d/href-2d");
            for (Node n : l) {
                imgHref = ConfigFetch.resolvePathWithParent(mapDir, n.getText());
                imgName = imgHref.substring(imgHref.lastIndexOf(sep) + 1, imgHref.length());
                FileUtil.copyFile(imgHref, outDir.getAbsolutePath() + sep + "models" + sep + imgName);
                n.setText("../models/" + imgName);
            }
            String mapName = mapHref.substring(mapHref.lastIndexOf(sep), mapHref.length());
            FileUtil.saveToFile(outDir + sep + "maps" + sep + mapName, FileUtil.getAsPrettyPrintFormatedXMLString(mapDoc));
        }
        for (ChecklistMission clist : this.checklistsList.values()) {
            String href = clist.getHref();
            href = ConfigFetch.resolvePathWithParent(missionDir, href);
            String clName = href.substring(href.lastIndexOf(sep), href.length());
            FileUtil.saveToFile(outDir + sep + "checklists" + sep + clName, FileUtil.getAsPrettyPrintFormatedXMLString(clist.getChecklist().asDocument()));
        }
        FileUtil.saveToFile(outDir.getAbsolutePath() + sep + "mission.nmis", FileUtil.getAsPrettyPrintFormatedXMLString(FileUtil.getAsCompactFormatedXMLString(myDoc)));
        if (saveNeptusConfigurations) {
            FileUtil.copyFile(ConfigFetch.resolvePath("conf/general-properties.xml"), outDir + sep + "general-properties.xml");
            FileUtil.saveToFile(outDir + sep + "IMC.xml", ImcStringDefs.getDefinitions());
        }
        try {
            ZipUtils.zipDir(filename, outDir.getAbsolutePath());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
        return true;
    }

    public MapGroup generateMapGroup() {
        MapGroup mg = MapGroup.getNewInstance(this.getHomeRef());
        Object[] maps = this.getMapsList().values().toArray();
        for (int i = 0; i < maps.length; ++i) {
            MapMission mm = (MapMission)maps[i];
            MapType mt = mm.getMap();
            mt.setHref(mm.getHref());
            mt.setChanged(false);
            mt.setMission(this);
            mt.setMapGroup(mg);
            mg.addMap(mt);
        }
        return mg;
    }

    public synchronized boolean save(boolean savePreviousState) {
        long startTimeMillis = System.currentTimeMillis();
        String caller = ReflectionUtil.getCallerStamp();
        if (this.getOriginalFilePath() == null || this.getOriginalFilePath().equals("")) {
            if (this.compressedFilePath != null) {
                File fxTmp = new File(this.compressedFilePath);
                if (!fxTmp.exists()) {
                    try {
                        fxTmp.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!fxTmp.exists()) {
                    GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Save mission"), I18n.text("Cannot save mission: file name is non existant"));
                    NeptusLog.pub().error((Object)"Cannot save mission file: compressedFilePath is NULL");
                    return false;
                }
                this.setOriginalFilePath(fxTmp.getParentFile().getAbsolutePath() + "/tmp-mission.nmis");
            } else {
                GuiUtils.errorMessage(ConfigFetch.getSuperParentFrame(), I18n.text("Save mission"), I18n.text("Cannot save mission: file name is empty"));
                NeptusLog.pub().error((Object)"Cannot save mission file: OriginalFilePath is NULL");
                return false;
            }
        }
        if (savePreviousState) {
            String missionlog = GuiUtils.getLogFileName("mission_state", "zip");
            boolean sr = this.asZipFile(missionlog, true);
            NeptusLog.pub().debug((Object)("The current mission state was" + (sr ? "" : " NOT") + " saved on " + missionlog + " in " + this.getFormatedDuration(startTimeMillis) + " from " + caller));
        }
        if (this.compressedFilePath != null) {
            boolean sr = this.asZipFile(this.compressedFilePath, false);
            NeptusLog.pub().info((Object)("The mission was" + (sr ? "" : " NOT") + " saved to " + this.compressedFilePath + " in " + this.getFormatedDuration(startTimeMillis) + " from " + caller));
            return sr;
        }
        boolean sr = FileUtil.saveToFile(this.getOriginalFilePath(), FileUtil.getAsPrettyPrintFormatedXMLString(this.asDocument()));
        NeptusLog.pub().info((Object)("The mission '" + this.getId() + "' was" + (sr ? "" : " NOT") + " saved to '" + this.getOriginalFilePath() + "'" + " in " + this.getFormatedDuration(startTimeMillis) + " from " + caller));
        return sr;
    }

    private String getFormatedDuration(long startTimeMillis) {
        return DateTimeUtil.milliSecondsToFormatedString(System.currentTimeMillis() - startTimeMillis);
    }

    public File getMissionFile() {
        if (this.compressedFilePath != null) {
            return new File(this.compressedFilePath);
        }
        return new File(this.originalFilePath);
    }

    public void setMissionFile(File fileToSave) {
        String ext = FileUtil.getFileExtension(fileToSave);
        if (ext.equalsIgnoreCase("nmisz") || ext.equalsIgnoreCase("zip")) {
            this.compressedFilePath = fileToSave.getAbsolutePath();
        } else {
            this.originalFilePath = fileToSave.getAbsolutePath();
            this.compressedFilePath = null;
        }
    }

    public LocationType getStartLocation() {
        return IMCUtils.lookForStartPosition(this);
    }

    public String getCompressedFilePath() {
        return this.compressedFilePath;
    }

    public void setCompressedFilePath(String compressedFilePath) {
        this.compressedFilePath = compressedFilePath;
    }
}

