/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.types.mission;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.lsts.neptus.types.XmlOutputMethods;
import pt.lsts.neptus.types.mission.ActionType;
import pt.lsts.neptus.types.mission.ConditionType;
import pt.lsts.neptus.util.NameNormalizer;

public class TransitionType
implements XmlOutputMethods {
    String id;
    String sourceManeuver;
    String targetManeuver;
    ConditionType condition;
    ActionType action;
    private static final String DEFAULT_ROOT_ELEMENT = "edge";

    public TransitionType(String source, String target) {
        this.setId(NameNormalizer.getRandomID());
        this.setSourceManeuver(source);
        this.setTargetManeuver(target);
        this.setCondition(new ConditionType());
    }

    public ConditionType getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionType condition) {
        this.condition = condition;
    }

    public ActionType getAction() {
        return this.action;
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSourceManeuver() {
        return this.sourceManeuver;
    }

    public void setSourceManeuver(String sourceManeuver) {
        this.sourceManeuver = sourceManeuver;
    }

    public String getTargetManeuver() {
        return this.targetManeuver;
    }

    public void setTargetManeuver(String targetManeuver) {
        this.targetManeuver = targetManeuver;
    }

    @Override
    public String asXML() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asXML(rootElementName);
    }

    @Override
    public String asXML(String rootElementName) {
        String result = "";
        Document document = this.asDocument(rootElementName);
        result = document.asXML();
        return result;
    }

    @Override
    public Element asElement() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asElement(rootElementName);
    }

    @Override
    public Element asElement(String rootElementName) {
        return (Element)this.asDocument(rootElementName).getRootElement().detach();
    }

    @Override
    public Document asDocument() {
        String rootElementName = DEFAULT_ROOT_ELEMENT;
        return this.asDocument(rootElementName);
    }

    @Override
    public Document asDocument(String rootElementName) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootElementName);
        root.addElement("id").setText(this.getId());
        root.addElement("source").setText(this.getSourceManeuver());
        root.addElement("target").setText(this.getTargetManeuver());
        root.addElement("guard").setText(this.getCondition().toString());
        if (!"".equalsIgnoreCase(this.getAction().toString())) {
            root.addElement("actions").setText(this.getAction().toString());
        }
        return document;
    }

    public String toString() {
        return "[" + this.getId() + "] " + this.sourceManeuver + " -> " + this.targetManeuver + " (" + this.condition + (!"".equalsIgnoreCase(this.getAction().toString()) ? " / " + this.action : "") + ")";
    }
}

